/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.handlers;

import com.google.common.collect.ImmutableCollection;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.manager.RequestMappingHandler;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.LogHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.ResolverHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.TokenHandler;
import com.minecolonies.coremod.colony.requestsystem.management.manager.wrapped.WrappedBlacklistAssignmentRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.manager.wrapped.WrappedStaticStateRequestManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class RequestHandler {
    public static <Request extends IRequestable> IRequest<Request> createRequest(IStandardRequestManager manager, IRequester requester, Request request) {
        IToken token = TokenHandler.generateNewToken(manager);
        IRequest constructedRequest = (IRequest)manager.getFactoryController().getNewInstance(TypeToken.of((Class)((Class)RequestMappingHandler.getRequestableMappings().get(request.getClass()))), request, token, requester);
        LogHandler.log("Creating request for: " + request + ", token: " + token + " and output: " + constructedRequest);
        RequestHandler.registerRequest(manager, constructedRequest);
        return constructedRequest;
    }

    public static void registerRequest(IStandardRequestManager manager, IRequest<?> request) {
        if (manager.getRequestIdentitiesDataStore().getIdentities().containsKey(request.getToken()) || manager.getRequestIdentitiesDataStore().getIdentities().containsValue(request)) {
            throw new IllegalArgumentException("The given request is already known to this manager");
        }
        LogHandler.log("Registering request: " + request);
        manager.getRequestIdentitiesDataStore().getIdentities().put(request.getToken(), request);
    }

    public static void assignRequest(IStandardRequestManager manager, IRequest<?> request) {
        RequestHandler.assignRequest(manager, request, Collections.emptyList());
    }

    public static IToken<?> assignRequest(IStandardRequestManager manager, IRequest<?> request, Collection<IToken<?>> resolverTokenBlackList) {
        switch (request.getStrategy()) {
            case PRIORITY_BASED: {
                return RequestHandler.assignRequestDefault(manager, request, resolverTokenBlackList);
            }
            case FASTED_FIRST: {
                MineColonies.getLogger().warn("Fastest First strategy not implemented yet.");
                return RequestHandler.assignRequestDefault(manager, request, resolverTokenBlackList);
            }
        }
        return null;
    }

    public static IToken<?> assignRequestDefault(IStandardRequestManager manager, IRequest request, Collection<IToken<?>> resolverTokenBlackList) {
        RequestHandler.getRequest(manager, request.getToken());
        LogHandler.log("Starting resolver assignment search for request: " + request);
        request.setState(new WrappedStaticStateRequestManager(manager), RequestState.ASSIGNING);
        Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
        requestTypes.remove(TypeConstants.OBJECT);
        LinkedList<TypeToken> typeIndexList = new LinkedList<TypeToken>(requestTypes);
        Set resolvers = requestTypes.stream().filter(typeToken -> manager.getRequestableTypeRequestResolverAssignmentDataStore().getAssignments().containsKey(typeToken)).flatMap(type -> manager.getRequestableTypeRequestResolverAssignmentDataStore().getAssignments().get(type).stream().map(iToken -> ResolverHandler.getResolver(manager, iToken))).filter(iRequestResolver -> typeIndexList.contains(iRequestResolver.getRequestType())).sorted(Comparator.comparingInt(r -> -1 * r.getPriority()).thenComparingInt(r -> typeIndexList.indexOf(r.getRequestType()))).collect(Collectors.toCollection(LinkedHashSet::new));
        for (IRequestResolver resolver : resolvers) {
            List<IToken<?>> attemptResult;
            if (resolverTokenBlackList.contains(resolver.getRequesterId()) || !resolver.canResolve(manager, request) || (attemptResult = resolver.attemptResolve(new WrappedBlacklistAssignmentRequestManager(manager, resolverTokenBlackList), request)) == null) continue;
            LogHandler.log("Finished resolver assignment search for request: " + request + " successfully");
            ResolverHandler.addRequestToResolver(manager, resolver, request);
            for (IToken<?> childRequestToken : attemptResult) {
                IRequest childRequest = RequestHandler.getRequest(manager, childRequestToken);
                childRequest.setParent(request.getToken());
                request.addChild(childRequest.getToken());
                if (RequestHandler.isAssigned(manager, childRequestToken)) continue;
                RequestHandler.assignRequest(manager, childRequest, resolverTokenBlackList);
            }
            if (request.getState().ordinal() < RequestState.IN_PROGRESS.ordinal()) {
                request.setState(new WrappedStaticStateRequestManager(manager), RequestState.IN_PROGRESS);
                if (!request.hasChildren()) {
                    RequestHandler.resolveRequest(manager, request);
                }
            }
            return resolver.getRequesterId();
        }
        return null;
    }

    public static IToken<?> reassignRequest(IStandardRequestManager manager, IRequest<?> request, Collection<IToken<?>> resolverTokenBlackList) {
        IRequestResolver<? extends IRequestable> currentResolver = null;
        if (RequestHandler.isAssigned(manager, request.getToken())) {
            currentResolver = ResolverHandler.getResolverForRequest(manager, request);
        }
        IToken<?> parent = null;
        if (request.hasParent()) {
            parent = (IToken<?>)request.getParent();
        }
        RequestHandler.processInternalCancellation(manager, request.getToken());
        if (currentResolver != null && manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(currentResolver.getRequesterId())) {
            manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(currentResolver.getRequesterId()).remove(request.getToken());
            if (manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(currentResolver.getRequesterId()).isEmpty()) {
                manager.getRequestResolverRequestAssignmentDataStore().getAssignments().remove(currentResolver.getRequesterId());
            }
        }
        manager.updateRequestState((IToken<?>)request.getToken(), RequestState.REPORTED);
        IToken<?> resolver = RequestHandler.assignRequest(manager, request, resolverTokenBlackList);
        if (parent != null) {
            request.setParent(parent);
            IRequest parentRequest = RequestHandler.getRequest(manager, parent);
            parentRequest.addChild(request.getToken());
        }
        return resolver;
    }

    public static boolean isAssigned(IStandardRequestManager manager, IToken<?> token) {
        return manager.getRequestResolverRequestAssignmentDataStore().getAssignmentForValue(token) != null;
    }

    public static void onRequestSuccessful(IStandardRequestManager manager, IToken<?> token) {
        IRequest request = RequestHandler.getRequest(manager, token);
        IRequestResolver<? extends IRequestable> resolver = ResolverHandler.getResolverForRequest(manager, token);
        request.getRequester().onRequestComplete(manager, token);
        IRequest<?> followupRequest = resolver.getFollowupRequestForCompletion(manager, request);
        if (request.hasParent()) {
            IRequest parentRequest = RequestHandler.getRequest(manager, request.getParent());
            if (followupRequest != null) {
                parentRequest.addChild(followupRequest.getToken());
            }
            manager.updateRequestState((IToken<?>)request.getToken(), RequestState.RECEIVED);
            parentRequest.removeChild(request.getToken());
            if (!parentRequest.hasChildren() && parentRequest.getState() == RequestState.IN_PROGRESS) {
                RequestHandler.resolveRequest(manager, parentRequest);
            }
            request.setParent(null);
        }
        if (followupRequest != null && !RequestHandler.isAssigned(manager, followupRequest.getToken())) {
            RequestHandler.assignRequest(manager, followupRequest);
        }
    }

    public static void onRequestOverruled(IStandardRequestManager manager, IToken<?> token) {
        IRequest request = RequestHandler.getRequest(manager, token);
        if (manager.getRequestResolverRequestAssignmentDataStore().getAssignmentForValue(token) == null) {
            manager.getRequestIdentitiesDataStore().getIdentities().remove(token);
            return;
        }
        if (request.hasChildren()) {
            ImmutableCollection<IToken> currentChildren = request.getChildren();
            currentChildren.forEach(t -> RequestHandler.onRequestCancelled(manager, t));
        }
        ResolverHandler.getResolverForRequest(manager, token).onRequestBeingOverruled(manager, request);
        manager.updateRequestState(token, RequestState.COMPLETED);
    }

    public static void onRequestCancelled(IStandardRequestManager manager, IToken<?> token) {
        IRequest request = RequestHandler.getRequest(manager, token);
        if (request == null) {
            return;
        }
        request.setState(new WrappedStaticStateRequestManager(manager), RequestState.CANCELLED);
        RequestHandler.processInternalCancellation(manager, token);
        IRequester requester = request.getRequester();
        requester.onRequestCancelled(manager, token);
        RequestHandler.cleanRequestData(manager, token);
    }

    public static void processInternalCancellation(IStandardRequestManager manager, IToken<?> token) {
        IRequest request = RequestHandler.getRequest(manager, token);
        if (manager.getRequestResolverRequestAssignmentDataStore().getAssignmentForValue(token) == null) {
            return;
        }
        if (request.hasChildren()) {
            ImmutableCollection<IToken> currentChildren = request.getChildren();
            currentChildren.forEach(t -> RequestHandler.onRequestCancelled(manager, t));
        }
        IRequestResolver<? extends IRequestable> targetResolver = ResolverHandler.getResolverForRequest(manager, request);
        RequestHandler.processParentReplacement(manager, request, targetResolver.onRequestCancelled((IRequestManager)manager, request));
        manager.updateRequestState(token, RequestState.FINALIZING);
    }

    public static void processParentReplacement(IStandardRequestManager manager, IRequest target, IRequest newParent) {
        if (target.hasParent()) {
            IRequest currentParent = RequestHandler.getRequest(manager, target.getParent());
            currentParent.removeChild(target.getToken());
            target.setParent(null);
        }
        if (newParent != null) {
            newParent.addChild(target.getToken());
            target.setParent(newParent.getToken());
            if (!RequestHandler.isAssigned(manager, newParent.getToken())) {
                RequestHandler.assignRequest(manager, newParent);
            }
        }
    }

    public static void resolveRequest(IStandardRequestManager manager, IRequest request) {
        RequestHandler.getRequest(manager, request.getToken());
        if (!RequestHandler.isAssigned(manager, request.getToken())) {
            throw new IllegalArgumentException("The given request is not resolved");
        }
        if (request.getState() != RequestState.IN_PROGRESS) {
            throw new IllegalArgumentException("The given request is not in the right state. Required: " + (Object)((Object)RequestState.IN_PROGRESS) + " - Found:" + (Object)((Object)request.getState()));
        }
        if (request.hasChildren()) {
            throw new IllegalArgumentException("Cannot resolve request with open Children");
        }
        IRequestResolver<? extends IRequestable> resolver = ResolverHandler.getResolverForRequest(manager, request);
        request.setState(new WrappedStaticStateRequestManager(manager), RequestState.IN_PROGRESS);
        resolver.resolve(manager, request);
    }

    public static void cleanRequestData(IStandardRequestManager manager, IToken<?> token) {
        LogHandler.log("Removing " + token + " from the Manager as it has been completed and its package has been received by the requester.");
        RequestHandler.getRequest(manager, token);
        if (RequestHandler.isAssigned(manager, token)) {
            IRequestResolver<? extends IRequestable> resolver = ResolverHandler.getResolverForRequest(manager, token);
            manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getRequesterId()).remove(token);
            if (manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getRequesterId()).isEmpty()) {
                manager.getRequestResolverRequestAssignmentDataStore().getAssignments().remove(resolver.getRequesterId());
            }
        }
        manager.getRequestIdentitiesDataStore().getIdentities().remove(token);
    }

    public static IRequest getRequest(IStandardRequestManager manager, IToken<?> token) {
        if (!manager.getRequestIdentitiesDataStore().getIdentities().containsKey(token)) {
            throw new IllegalArgumentException("The given token is not registered as a request to this manager");
        }
        return RequestHandler.getRequestOrNull(manager, token);
    }

    public static IRequest getRequestOrNull(IStandardRequestManager manager, IToken<?> token) {
        LogHandler.log("Retrieving the request for: " + token);
        return (IRequest)manager.getRequestIdentitiesDataStore().getIdentities().get(token);
    }

    private static final class AssigningResult<T>
    implements Comparable<AssigningResult<T>> {
        private final IRequestResolver resolver;
        private final List<IToken<T>> children;

        private AssigningResult(IRequestResolver resolver, List<IToken<T>> children) {
            this.resolver = resolver;
            this.children = new ArrayList<IToken<T>>(children);
        }

        @Override
        public int compareTo(@NotNull AssigningResult<T> o) {
            return this.children.size() != o.children.size() ? this.children.size() - o.children.size() : o.getResolver().getPriority() - this.getResolver().getPriority();
        }

        public IRequestResolver getResolver() {
            return this.resolver;
        }
    }
}

