/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.data;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class StandardRequestSystemBuildingDataStore
implements IRequestSystemBuildingDataStore {
    private IToken<?> id;
    private final Map<TypeToken<?>, Collection<IToken<?>>> openRequestsByRequestableType;
    private final Map<Integer, Collection<IToken<?>>> openRequestsByCitizen;
    private final Map<Integer, Collection<IToken<?>>> completedRequestsByCitizen;
    private final Map<IToken<?>, Integer> citizenByOpenRequest;

    public StandardRequestSystemBuildingDataStore(IToken<?> id, Map<TypeToken<?>, Collection<IToken<?>>> openRequestsByRequestableType, Map<Integer, Collection<IToken<?>>> openRequestsByCitizen, Map<Integer, Collection<IToken<?>>> completedRequestsByCitizen, Map<IToken<?>, Integer> citizenByOpenRequest) {
        this.id = id;
        this.openRequestsByRequestableType = openRequestsByRequestableType;
        this.openRequestsByCitizen = openRequestsByCitizen;
        this.completedRequestsByCitizen = completedRequestsByCitizen;
        this.citizenByOpenRequest = citizenByOpenRequest;
    }

    public StandardRequestSystemBuildingDataStore() {
        this(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new HashMap(), new HashMap(), new HashMap(), new HashMap());
    }

    @Override
    public Map<TypeToken<?>, Collection<IToken<?>>> getOpenRequestsByRequestableType() {
        return this.openRequestsByRequestableType;
    }

    @Override
    public Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.openRequestsByCitizen;
    }

    @Override
    public Map<Integer, Collection<IToken<?>>> getCompletedRequestsByCitizen() {
        return this.completedRequestsByCitizen;
    }

    @Override
    public Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.citizenByOpenRequest;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardRequestSystemBuildingDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardRequestSystemBuildingDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardRequestSystemBuildingDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardRequestSystemBuildingDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardRequestSystemBuildingDataStore();
        }

        @Override
        @NotNull
        public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull StandardRequestSystemBuildingDataStore standardRequestSystemBuildingDataStore) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("Token", (NBTBase)controller.serialize(standardRequestSystemBuildingDataStore.id));
            compound.func_74782_a("OpenRequestByRequestableType", (NBTBase)standardRequestSystemBuildingDataStore.openRequestsByRequestableType.keySet().stream().map(typeToken -> {
                NBTTagCompound entryCompound = new NBTTagCompound();
                entryCompound.func_74782_a("Token", (NBTBase)controller.serialize(typeToken));
                entryCompound.func_74782_a("List", (NBTBase)((Collection)standardRequestSystemBuildingDataStore.openRequestsByRequestableType.get(typeToken)).stream().map(controller::serialize).collect(NBTUtils.toNBTTagList()));
                return entryCompound;
            }).collect(NBTUtils.toNBTTagList()));
            compound.func_74782_a("OpenRequestByCitizen", (NBTBase)standardRequestSystemBuildingDataStore.openRequestsByCitizen.keySet().stream().map(integer -> {
                NBTTagCompound entryCompound = new NBTTagCompound();
                entryCompound.func_74782_a("Token", (NBTBase)controller.serialize(integer));
                entryCompound.func_74782_a("List", (NBTBase)((Collection)standardRequestSystemBuildingDataStore.openRequestsByCitizen.get(integer)).stream().map(controller::serialize).collect(NBTUtils.toNBTTagList()));
                return entryCompound;
            }).collect(NBTUtils.toNBTTagList()));
            compound.func_74782_a("CompletedRequestByCitizen", (NBTBase)standardRequestSystemBuildingDataStore.completedRequestsByCitizen.keySet().stream().map(integer -> {
                NBTTagCompound entryCompound = new NBTTagCompound();
                entryCompound.func_74782_a("Token", (NBTBase)controller.serialize(integer));
                entryCompound.func_74782_a("List", (NBTBase)((Collection)standardRequestSystemBuildingDataStore.completedRequestsByCitizen.get(integer)).stream().map(controller::serialize).collect(NBTUtils.toNBTTagList()));
                return entryCompound;
            }).collect(NBTUtils.toNBTTagList()));
            compound.func_74782_a("CitizenByOpenRequest", (NBTBase)standardRequestSystemBuildingDataStore.citizenByOpenRequest.keySet().stream().map(iToken -> {
                NBTTagCompound entryCompound = new NBTTagCompound();
                entryCompound.func_74782_a("Token", (NBTBase)controller.serialize(iToken));
                entryCompound.func_74782_a("Value", (NBTBase)controller.serialize(standardRequestSystemBuildingDataStore.citizenByOpenRequest.get(iToken)));
                return entryCompound;
            }).collect(NBTUtils.toNBTTagList()));
            return compound;
        }

        @Override
        @NotNull
        public StandardRequestSystemBuildingDataStore deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) throws Throwable {
            IToken token = (IToken)controller.deserialize(nbt.func_74775_l("Token"));
            Map<TypeToken<?>, Collection<IToken<?>>> openRequestsByRequestableType = NBTUtils.streamCompound(nbt.func_150295_c("OpenRequestByRequestableType", 10)).map(nbtTagCompound -> {
                TypeToken key = (TypeToken)controller.deserialize(nbtTagCompound.func_74775_l("Token"));
                Collection values = NBTUtils.streamCompound(nbtTagCompound.func_150295_c("List", 10)).map(elementCompound -> (IToken)controller.deserialize((NBTTagCompound)elementCompound)).collect(Collectors.toList());
                return new Tuple((Object)key, (Object)values);
            }).collect(Collectors.toMap(Tuple::func_76341_a, Tuple::func_76340_b));
            Map<Integer, Collection<IToken<?>>> openRequestsByCitizen = NBTUtils.streamCompound(nbt.func_150295_c("OpenRequestByCitizen", 10)).map(nbtTagCompound -> {
                Integer key = (Integer)controller.deserialize(nbtTagCompound.func_74775_l("Token"));
                Collection values = NBTUtils.streamCompound(nbtTagCompound.func_150295_c("List", 10)).map(elementCompound -> (IToken)controller.deserialize((NBTTagCompound)elementCompound)).collect(Collectors.toList());
                return new Tuple((Object)key, (Object)values);
            }).collect(Collectors.toMap(Tuple::func_76341_a, Tuple::func_76340_b));
            Map<Integer, Collection<IToken<?>>> completedRequestsByCitizen = NBTUtils.streamCompound(nbt.func_150295_c("CompletedRequestByCitizen", 10)).map(nbtTagCompound -> {
                Integer key = (Integer)controller.deserialize(nbtTagCompound.func_74775_l("Token"));
                Collection values = NBTUtils.streamCompound(nbtTagCompound.func_150295_c("List", 10)).map(elementCompound -> (IToken)controller.deserialize((NBTTagCompound)elementCompound)).collect(Collectors.toList());
                return new Tuple((Object)key, (Object)values);
            }).collect(Collectors.toMap(Tuple::func_76341_a, Tuple::func_76340_b));
            Map<IToken<?>, Integer> citizenByOpenRequest = NBTUtils.streamCompound(nbt.func_150295_c("CitizenByOpenRequest", 10)).map(nbtTagCompound -> {
                IToken key = (IToken)controller.deserialize(nbtTagCompound.func_74775_l("Token"));
                Integer value = (Integer)controller.deserialize(nbtTagCompound.func_74775_l("Value"));
                return new Tuple((Object)key, (Object)value);
            }).collect(Collectors.toMap(Tuple::func_76341_a, Tuple::func_76340_b));
            return new StandardRequestSystemBuildingDataStore(token, openRequestsByRequestableType, openRequestsByCitizen, completedRequestsByCitizen, citizenByOpenRequest);
        }
    }
}

