/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracksTower;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.network.messages.ColonyViewCitizenViewMessage;
import com.minecolonies.coremod.network.messages.ColonyViewRemoveCitizenMessage;
import com.minecolonies.coremod.network.messages.HappinessDataMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenManager
implements ICitizenManager {
    @NotNull
    private final Map<Integer, CitizenData> citizens = new HashMap<Integer, CitizenData>();
    private boolean isCitizensDirty = false;
    private int topCitizenId = 0;
    private int maxCitizens;
    private final Colony colony;

    public CitizenManager(Colony colony) {
        this.maxCitizens = Configurations.gameplay.maxCitizens;
        this.colony = colony;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.maxCitizens = compound.func_74762_e("maxCitizens");
        this.citizens.putAll(NBTUtils.streamCompound(compound.func_150295_c("citizens", 10)).map(this::deserializeCitizen).collect(Collectors.toMap(CitizenData::getId, Function.identity())));
    }

    private CitizenData deserializeCitizen(@NotNull NBTTagCompound compound) {
        CitizenData data = CitizenData.createFromNBT(compound, this.colony);
        this.topCitizenId = Math.max(this.topCitizenId, data.getId());
        return data;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        compound.func_74768_a("maxCitizens", this.maxCitizens);
        NBTTagList citizenTagList = this.citizens.values().stream().map(citizen -> citizen.writeToNBT(new NBTTagCompound())).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a("citizens", (NBTBase)citizenTagList);
    }

    @Override
    public void sendPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers, @NotNull Set<EntityPlayerMP> subscribers) {
        if (this.isCitizensDirty || hasNewSubscribers) {
            for (CitizenData citizen : this.citizens.values()) {
                if (!citizen.getCitizenEntity().isPresent()) continue;
                List list = this.colony.getWorld().func_175644_a(EntityCitizen.class, entityCitizen -> entityCitizen.getCitizenColonyHandler().getColony().getID() == this.colony.getID() && entityCitizen.getCitizenData().getId() == citizen.getId());
                if (!list.isEmpty() && citizen.getCitizenEntity().get().func_145782_y() != ((EntityCitizen)((Object)list.get(0))).func_145782_y()) {
                    citizen.setCitizenEntity((EntityCitizen)((Object)list.get(0)));
                }
                for (int i = 1; i < list.size(); ++i) {
                    Log.getLogger().warn("Removing duplicate entity now!");
                    this.colony.getWorld().func_72900_e((Entity)list.get(i));
                }
                if (!citizen.isDirty() && !hasNewSubscribers) continue;
                subscribers.stream().filter(player -> citizen.isDirty() || !oldSubscribers.contains(player)).forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewCitizenViewMessage(this.colony, citizen), player));
            }
            subscribers.stream().filter(player -> !oldSubscribers.contains(player)).forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new HappinessDataMessage(this.colony, this.colony.getHappinessData()), player));
        }
    }

    @Override
    public void spawnCitizen(@Nullable CitizenData data, @Nullable World world, boolean force) {
        if (!this.colony.getBuildingManager().hasTownHall()) {
            return;
        }
        BlockPos townHallLocation = this.colony.getBuildingManager().getTownHall().getLocation();
        if (!world.func_175667_e(townHallLocation)) {
            return;
        }
        BlockPos spawnPoint = EntityUtils.getSpawnPoint(world, townHallLocation);
        if (spawnPoint != null) {
            EntityCitizen entity = new EntityCitizen(world);
            CitizenData citizenData = data;
            if (citizenData == null) {
                for (int i = 1; i <= this.getCurrentCitizenCount() + 1; ++i) {
                    if (this.getCitizen(i) != null) continue;
                    this.topCitizenId = i;
                    break;
                }
                citizenData = new CitizenData(this.topCitizenId, this.colony);
                citizenData.initializeFromEntity(entity);
                this.citizens.put(citizenData.getId(), citizenData);
                if (this.getMaxCitizens() == this.getCitizens().size() && !force) {
                    LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "tile.blockHutTownHall.messageMaxSize", this.colony.getName());
                }
            } else {
                citizenData.setCitizenEntity(entity);
            }
            entity.getCitizenColonyHandler().setColony(this.colony, citizenData);
            entity.func_70107_b((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o() + 0.1, (double)spawnPoint.func_177952_p() + 0.5);
            world.func_72838_d((Entity)entity);
            this.colony.getProgressManager().progressCitizenSpawn(this.citizens.size(), this.citizens.values().stream().filter(tempDate -> tempDate.getJob() != null).collect(Collectors.toList()).size());
            this.colony.getStatsManager().checkAchievements();
            this.markCitizensDirty();
        } else {
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.coremod.citizens.nospace", new Object[0]);
        }
    }

    @Override
    public void removeCitizen(@NotNull CitizenData citizen) {
        this.citizens.remove(citizen.getId());
        if (citizen.getWorkBuilding() != null) {
            citizen.getWorkBuilding().cancelAllRequestsOfCitizen(citizen);
        }
        if (citizen.getHomeBuilding() != null) {
            citizen.getHomeBuilding().cancelAllRequestsOfCitizen(citizen);
        }
        for (AbstractBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            building.removeCitizen(citizen);
        }
        this.colony.getWorkManager().clearWorkForCitizen(citizen);
        for (EntityPlayerMP player : this.colony.getPackageManager().getSubscribers()) {
            MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveCitizenMessage(this.colony, citizen.getId()), player);
        }
        this.colony.markDirty();
    }

    @Override
    public CitizenData getJoblessCitizen() {
        for (CitizenData citizen : this.citizens.values()) {
            if (citizen.getWorkBuilding() != null) continue;
            return citizen;
        }
        return null;
    }

    @Override
    public void calculateMaxCitizens() {
        int newMaxCitizens = 0;
        for (AbstractBuilding b : this.colony.getBuildingManager().getBuildings().values()) {
            if (b.getBuildingLevel() <= 0) continue;
            if (b instanceof BuildingHome) {
                newMaxCitizens += b.getMaxInhabitants();
                continue;
            }
            if (!(b instanceof BuildingBarracksTower)) continue;
            newMaxCitizens += b.getBuildingLevel();
        }
        newMaxCitizens = Math.max(Configurations.gameplay.maxCitizens, newMaxCitizens);
        if (this.getMaxCitizens() != newMaxCitizens) {
            this.setMaxCitizens(Math.min(newMaxCitizens, Configurations.gameplay.maxCitizenPerColony));
        }
        this.colony.markDirty();
    }

    @Override
    public void spawnCitizen() {
        this.spawnCitizen(null, this.colony.getWorld());
    }

    @Override
    @NotNull
    public Map<Integer, CitizenData> getCitizenMap() {
        return Collections.unmodifiableMap(this.citizens);
    }

    @Override
    public void markCitizensDirty() {
        this.colony.markDirty();
        this.isCitizensDirty = true;
    }

    @Override
    public CitizenData getCitizen(int citizenId) {
        return this.citizens.get(citizenId);
    }

    @Override
    public void clearDirty() {
        this.isCitizensDirty = false;
        this.citizens.values().forEach(CitizenData::clearDirty);
    }

    @Override
    public List<CitizenData> getCitizens() {
        return new ArrayList<CitizenData>(this.citizens.values());
    }

    @Override
    public int getMaxCitizens() {
        return this.maxCitizens;
    }

    @Override
    public int getCurrentCitizenCount() {
        return this.citizens.size();
    }

    @Override
    public void setMaxCitizens(int newMaxCitizens) {
        this.maxCitizens = newMaxCitizens;
    }

    @Override
    public void checkCitizensForHappiness() {
        int guards = 1;
        int housing = 0;
        int workers = 1;
        boolean hasJob = false;
        boolean hasHouse = false;
        double saturation = 0.0;
        for (CitizenData citizen : this.getCitizens()) {
            AbstractBuilding home;
            hasJob = false;
            hasHouse = false;
            AbstractBuildingWorker buildingWorker = citizen.getWorkBuilding();
            if (buildingWorker != null) {
                hasJob = true;
                if (buildingWorker instanceof AbstractBuildingGuards) {
                    guards += buildingWorker.getBuildingLevel();
                } else {
                    workers += buildingWorker.getBuildingLevel();
                }
            }
            if ((home = citizen.getHomeBuilding()) != null) {
                hasHouse = true;
                housing += home.getBuildingLevel();
            }
            if (citizen.getCitizenEntity().isPresent()) {
                citizen.getCitizenHappinessHandler().processDailyHappiness(hasHouse, hasJob);
            }
            saturation += citizen.getSaturation();
        }
        int averageHousing = housing / Math.max(1, this.getCitizens().size());
        if (averageHousing > 1) {
            this.colony.getHappinessData().setHousing(1);
        } else if (averageHousing < 1) {
            this.colony.getHappinessData().setHousing(-1);
        } else {
            this.colony.getHappinessData().setHousing(0);
        }
        int averageSaturation = (int)(saturation / (double)this.getCitizens().size());
        if (averageSaturation < 5) {
            this.colony.getHappinessData().setSaturation(-1);
        } else if (averageSaturation > 5) {
            this.colony.getHappinessData().setSaturation(1);
        } else {
            this.colony.getHappinessData().setSaturation(0);
        }
        int relation = workers / guards;
        if (relation > 1) {
            this.colony.getHappinessData().setHousingModifier((double)relation * 0.1);
            this.colony.getHappinessData().setGuards(-1);
        } else if (relation < 1) {
            this.colony.getHappinessData().setGuards(1);
        } else {
            this.colony.getHappinessData().setGuards(0);
        }
    }

    @Override
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (Colony.shallUpdate(event.world, 100) && this.colony.areAllColonyChunksLoaded(event) && this.colony.hasTownHall()) {
            this.getCitizens().stream().filter(Objects::nonNull).forEach(CitizenData::updateCitizenEntityIfNecessary);
        }
        if (this.colony.hasTownHall() && this.getCitizens().size() < this.getMaxCitizens()) {
            int respawnInterval = Configurations.gameplay.citizenRespawnInterval * 20;
            if ((event.world.func_82737_E() + 1L) % (long)((respawnInterval -= 60 * this.colony.getBuildingManager().getTownHall().getBuildingLevel()) + 1) == 0L) {
                this.spawnCitizen();
            }
        }
    }

    @Override
    public void updateCitizenMourn(boolean mourn) {
        for (CitizenData citizen : this.getCitizens()) {
            if (!citizen.getCitizenEntity().isPresent() || citizen.getJob() instanceof AbstractJobGuard) continue;
            citizen.getCitizenEntity().get().setMourning(mourn);
        }
    }
}

