/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.registry.BuildingRegistry;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.managers.interfaces.IBuildingManager;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.network.messages.ColonyViewBuildingViewMessage;
import com.minecolonies.coremod.network.messages.ColonyViewRemoveBuildingMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingManager
implements IBuildingManager {
    @NotNull
    private final Map<BlockPos, AbstractBuilding> buildings = new HashMap<BlockPos, AbstractBuilding>();
    private final List<BlockPos> fields = new ArrayList<BlockPos>();
    private BuildingWareHouse wareHouse = null;
    @Nullable
    private BuildingTownHall townHall;
    private boolean isBuildingsDirty = false;
    private boolean isFieldsDirty = false;
    private final Colony colony;

    public BuildingManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagList buildingTagList = compound.func_150295_c("buildings", 10);
        for (int i = 0; i < buildingTagList.func_74745_c(); ++i) {
            NBTTagCompound buildingCompound = buildingTagList.func_150305_b(i);
            AbstractBuilding b = BuildingRegistry.createFromNBT(this.colony, buildingCompound);
            if (b == null) continue;
            this.addBuilding(b);
        }
        if (compound.func_74764_b("newFields")) {
            NBTTagList fieldTagList = compound.func_150295_c("newFields", 10);
            for (int i = 0; i < fieldTagList.func_74745_c(); ++i) {
                this.addField(BlockPosUtil.readFromNBT(fieldTagList.func_150305_b(i), "pos"));
            }
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList buildingTagList = new NBTTagList();
        for (AbstractBuilding b : this.buildings.values()) {
            NBTTagCompound buildingCompound = new NBTTagCompound();
            b.writeToNBT(buildingCompound);
            buildingTagList.func_74742_a((NBTBase)buildingCompound);
        }
        compound.func_74782_a("buildings", (NBTBase)buildingTagList);
        NBTTagList fieldTagList = new NBTTagList();
        for (BlockPos pos : this.fields) {
            NBTTagCompound fieldCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(fieldCompound, "pos", pos);
            fieldTagList.func_74742_a((NBTBase)fieldCompound);
        }
        compound.func_74782_a("newFields", (NBTBase)fieldTagList);
    }

    @Override
    public void tick(TickEvent.ServerTickEvent event) {
        for (AbstractBuilding b : this.buildings.values()) {
            b.onServerTick(event);
        }
    }

    @Override
    public void clearDirty() {
        this.isBuildingsDirty = false;
        this.buildings.values().forEach(AbstractSchematicProvider::clearDirty);
    }

    @Override
    public void sendPackets(Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers, Set<EntityPlayerMP> subscribers) {
        this.sendBuildingPackets(oldSubscribers, hasNewSubscribers, subscribers);
        this.sendFieldPackets(hasNewSubscribers, subscribers);
        this.isBuildingsDirty = false;
        this.isFieldsDirty = false;
    }

    @Override
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        for (AbstractBuilding building : this.buildings.values()) {
            if (!event.world.func_175667_e(building.getLocation())) continue;
            building.onWorldTick(event);
        }
    }

    @Override
    public void markBuildingsDirty() {
        this.isBuildingsDirty = true;
    }

    @Override
    public void cleanUpBuildings(@NotNull TickEvent.WorldTickEvent event) {
        ArrayList<AbstractBuilding> removedBuildings = new ArrayList<AbstractBuilding>();
        ArrayList<AbstractBuilding> tempBuildings = new ArrayList<AbstractBuilding>(this.buildings.values());
        for (AbstractBuilding building : tempBuildings) {
            BlockPos loc = building.getLocation();
            if (!event.world.func_175667_e(loc) || building.isMatchingBlock(event.world.func_180495_p(loc).func_177230_c())) continue;
            removedBuildings.add(building);
        }
        ArrayList<BlockPos> tempFields = new ArrayList<BlockPos>(this.fields);
        for (BlockPos pos : tempFields) {
            ScarecrowTileEntity scarecrow;
            if (!event.world.func_175667_e(pos) || (scarecrow = (ScarecrowTileEntity)event.world.func_175625_s(pos)) != null) continue;
            this.removeField(pos);
        }
        removedBuildings.forEach(AbstractBuilding::destroy);
    }

    @Override
    public AbstractBuilding getBuilding(BlockPos buildingId) {
        if (buildingId != null) {
            return this.buildings.get(buildingId);
        }
        return null;
    }

    @Override
    public Map<BlockPos, AbstractBuilding> getBuildings() {
        return Collections.unmodifiableMap(this.buildings);
    }

    @Override
    public BuildingTownHall getTownHall() {
        return this.townHall;
    }

    @Override
    public boolean hasWarehouse() {
        return this.wareHouse != null;
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    public List<BlockPos> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public ScarecrowTileEntity getFreeField(int owner, World world) {
        for (BlockPos pos : this.fields) {
            TileEntity field = world.func_175625_s(pos);
            if (!(field instanceof ScarecrowTileEntity) || ((ScarecrowTileEntity)field).isTaken()) continue;
            return (ScarecrowTileEntity)field;
        }
        return null;
    }

    @Override
    public <B extends AbstractBuilding> B getBuilding(BlockPos buildingId, @NotNull Class<B> type) {
        try {
            return (B)((AbstractBuilding)type.cast(this.buildings.get(buildingId)));
        }
        catch (ClassCastException e) {
            Log.getLogger().warn("getBuilding called with wrong type: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public void addNewField(ScarecrowTileEntity tileEntity, BlockPos pos, World world) {
        this.addField(pos);
        tileEntity.calculateSize(world, pos.func_177977_b());
        this.markFieldsDirty();
    }

    @Override
    public AbstractBuilding addNewBuilding(@NotNull TileEntityColonyBuilding tileEntity, World world) {
        tileEntity.setColony(this.colony);
        if (!this.buildings.containsKey(tileEntity.getPosition())) {
            AbstractBuilding building = BuildingRegistry.create(this.colony, tileEntity);
            if (building != null) {
                this.addBuilding(building);
                tileEntity.setBuilding(building);
                Log.getLogger().info(String.format("Colony %d - new AbstractBuilding for %s at %s", this.colony.getID(), tileEntity.func_145838_q().getClass(), tileEntity.getPosition()));
                if (tileEntity.isMirrored()) {
                    building.invertMirror();
                }
                if (!tileEntity.getStyle().isEmpty()) {
                    building.setStyle(tileEntity.getStyle());
                } else {
                    building.setStyle(this.colony.getStyle());
                }
                ConstructionTapeHelper.placeConstructionTape(building.getLocation(), building.getCorners(), world);
                this.colony.getRequestManager().onProviderAddedToColony(building);
            } else {
                Log.getLogger().error(String.format("Colony %d unable to create AbstractBuilding for %s at %s", this.colony.getID(), tileEntity.func_145838_q().getClass(), tileEntity.getPosition()));
            }
            this.colony.getCitizenManager().calculateMaxCitizens();
            return building;
        }
        return null;
    }

    @Override
    public void removeBuilding(@NotNull AbstractBuilding building, Set<EntityPlayerMP> subscribers) {
        if (this.buildings.remove(building.getID()) != null) {
            for (EntityPlayerMP player : subscribers) {
                MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveBuildingMessage(this.colony, building.getID()), player);
            }
            Log.getLogger().info(String.format("Colony %d - removed AbstractBuilding %s of type %s", this.colony.getID(), building.getID(), building.getSchematicName()));
        }
        if (building instanceof BuildingTownHall) {
            this.townHall = null;
        } else if (building instanceof BuildingWareHouse) {
            this.wareHouse = null;
        }
        this.colony.getRequestManager().onProviderRemovedFromColony(building);
        for (CitizenData citizen : this.colony.getCitizenManager().getCitizens()) {
            citizen.onRemoveBuilding(building);
        }
        this.colony.getCitizenManager().calculateMaxCitizens();
    }

    @Override
    public void removeField(BlockPos pos) {
        this.markFieldsDirty();
        this.fields.remove(pos);
        this.colony.markDirty();
    }

    @Override
    public BlockPos getBestRestaurant(EntityCitizen citizen) {
        double distance = Double.MAX_VALUE;
        BlockPos goodCook = null;
        for (AbstractBuilding building : citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().values()) {
            double localDistance;
            if (!(building instanceof BuildingCook) || building.getBuildingLevel() <= 0 || !((localDistance = building.getLocation().func_177951_i((Vec3i)citizen.func_180425_c())) < distance)) continue;
            distance = localDistance;
            goodCook = building.getLocation();
        }
        return goodCook;
    }

    @Override
    public void setTownHall(@Nullable BuildingTownHall building) {
        this.townHall = building;
    }

    @Override
    public void setWareHouse(@Nullable BuildingWareHouse building) {
        this.wareHouse = building;
    }

    private void markFieldsDirty() {
        this.isFieldsDirty = true;
    }

    private void addBuilding(@NotNull AbstractBuilding building) {
        this.buildings.put(building.getID(), building);
        building.markDirty();
        if (building instanceof BuildingTownHall && this.townHall == null) {
            this.townHall = (BuildingTownHall)building;
        }
        if (building instanceof BuildingWareHouse && this.wareHouse == null) {
            this.wareHouse = (BuildingWareHouse)building;
        }
    }

    private void sendBuildingPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers, Set<EntityPlayerMP> subscribers) {
        if (this.isBuildingsDirty || hasNewSubscribers) {
            for (AbstractBuilding building : this.buildings.values()) {
                if (!building.isDirty() && !hasNewSubscribers) continue;
                subscribers.stream().filter(player -> building.isDirty() || !oldSubscribers.contains(player)).forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewBuildingViewMessage(building), player));
            }
        }
    }

    private void sendFieldPackets(boolean hasNewSubscribers, Set<EntityPlayerMP> subscribers) {
        if (this.isFieldsDirty || hasNewSubscribers) {
            for (AbstractBuilding building : this.buildings.values()) {
                if (!(building instanceof BuildingFarmer)) continue;
                subscribers.forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewBuildingViewMessage(building), player));
            }
        }
    }

    private void addField(@NotNull BlockPos pos) {
        if (!this.fields.contains(pos)) {
            this.fields.add(pos);
        }
        this.colony.markDirty();
    }
}

