/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.fisherman.EntityAIWorkFisherman;
import com.minecolonies.coremod.sounds.FishermanSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class JobFisherman
extends AbstractJob {
    private static final String TAG_WATER = "Pond";
    private static final String TAG_PONDS = "Ponds";
    private BlockPos water;
    @NotNull
    private ArrayList<BlockPos> ponds = new ArrayList();

    public JobFisherman(CitizenData entity) {
        super(entity);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b(TAG_WATER)) {
            this.water = BlockPosUtil.readFromNBT(compound, TAG_WATER);
        }
        this.ponds = new ArrayList();
        NBTTagList listOfPonds = compound.func_150295_c(TAG_PONDS, 10);
        for (int i = 0; i < listOfPonds.func_74745_c(); ++i) {
            this.ponds.add(BlockPosUtil.readFromNBTTagList(listOfPonds, i));
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Fisherman";
    }

    @Override
    @NotNull
    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.FISHERMAN;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagCompound waterTag = new NBTTagCompound();
        if (this.water != null) {
            BlockPosUtil.writeToNBT(waterTag, TAG_WATER, this.water);
        }
        NBTTagList lakes = new NBTTagList();
        for (BlockPos pond : this.ponds) {
            BlockPosUtil.writeToNBTTagList(lakes, pond);
        }
        compound.func_74782_a(TAG_PONDS, (NBTBase)lakes);
    }

    @NotNull
    public AbstractAISkeleton<JobFisherman> generateAI() {
        return new EntityAIWorkFisherman(this);
    }

    @Override
    public SoundEvent getBedTimeSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? FishermanSounds.Female.offToBed : FishermanSounds.Male.offToBed;
        }
        return null;
    }

    @Override
    public SoundEvent getBadWeatherSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? FishermanSounds.Female.badWeather : FishermanSounds.Male.badWeather;
        }
        return null;
    }

    @Override
    public void triggerDeathAchievement(DamageSource source, EntityCitizen citizen) {
        super.triggerDeathAchievement(source, citizen);
        if (source.func_76346_g() instanceof EntityGuardian) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementFisherDeathGuardian);
        }
    }

    public BlockPos getWater() {
        return this.water;
    }

    public void setWater(BlockPos water) {
        this.water = water;
    }

    @NotNull
    public List<BlockPos> getPonds() {
        return new ArrayList<BlockPos>(this.ponds);
    }

    public void addToPonds(BlockPos pond) {
        this.ponds.add(pond);
    }

    public void removeFromPonds(BlockPos pond) {
        this.ponds.remove(pond);
    }
}

