/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.baker.EntityAIWorkBaker;
import com.minecolonies.coremod.sounds.BakerSounds;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobBaker
extends AbstractJob {
    public JobBaker(CitizenData entity) {
        super(entity);
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.baker";
    }

    @Override
    @NotNull
    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.BAKER;
    }

    @NotNull
    public AbstractAISkeleton<JobBaker> generateAI() {
        return new EntityAIWorkBaker(this);
    }

    @Override
    @Nullable
    public SoundEvent getBedTimeSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? BakerSounds.Female.offToBed : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getBadWeatherSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? BakerSounds.Female.badWeather : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getMoveAwaySound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? BakerSounds.Female.hostile : null;
        }
        return null;
    }
}

