/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.jobs.registry.JobRegistry;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.util.AIState;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJob {
    private static final String TAG_ASYNC_REQUESTS = "asyncRequests";
    private static final String TAG_ACTIONS_DONE = "actionsDone";
    private int actionsDone = 0;
    private static final int TASK_PRIORITY = 3;
    private final CitizenData citizen;
    private String nameTag = "";
    private final Set<IToken> asyncRequests = new HashSet<IToken>();
    private boolean searchedForFoodToday;
    private WeakReference<AbstractAISkeleton> workerAI = new WeakReference<Object>(null);

    public AbstractJob(CitizenData entity) {
        this.citizen = entity;
    }

    public abstract String getName();

    public String getExperienceTag() {
        return this.getName();
    }

    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.CITIZEN;
    }

    public Colony getColony() {
        return this.citizen.getColony();
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        String s = JobRegistry.getClassToNameMap().get(this.getClass());
        if (s == null) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compound.func_74778_a("type", s);
        compound.func_74782_a(TAG_ASYNC_REQUESTS, (NBTBase)this.getAsyncRequests().stream().map(StandardFactoryController.getInstance()::serialize).collect(NBTUtils.toNBTTagList()));
        compound.func_74768_a(TAG_ACTIONS_DONE, this.actionsDone);
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.asyncRequests.clear();
        if (compound.func_74764_b(TAG_ASYNC_REQUESTS)) {
            this.asyncRequests.addAll(NBTUtils.streamCompound(compound.func_150295_c(TAG_ASYNC_REQUESTS, 10)).map(StandardFactoryController.getInstance()::deserialize).map(o -> (IToken)o).collect(Collectors.toSet()));
        }
        if (compound.func_74764_b(TAG_ACTIONS_DONE)) {
            this.actionsDone = compound.func_74762_e(TAG_ACTIONS_DONE);
        }
    }

    public Set<IToken> getAsyncRequests() {
        return this.asyncRequests;
    }

    public void addWorkerAIToTaskList(@NotNull EntityAITasks tasks) {
        AbstractAISkeleton<? extends AbstractJob> tempAI = this.generateAI();
        this.workerAI = new WeakReference<AbstractAISkeleton<? extends AbstractJob>>(tempAI);
        tasks.func_75776_a(3, tempAI);
    }

    public abstract AbstractAISkeleton<? extends AbstractJob> generateAI();

    public boolean hasCheckedForFoodToday() {
        return this.searchedForFoodToday;
    }

    public void setCheckedForFood() {
        this.searchedForFoodToday = true;
    }

    public String getNameTagDescription() {
        return this.nameTag;
    }

    public final void setNameTag(String nameTag) {
        this.nameTag = nameTag;
    }

    public SoundEvent getBedTimeSound() {
        return null;
    }

    public SoundEvent getBadWeatherSound() {
        return null;
    }

    public SoundEvent getMoveAwaySound() {
        return null;
    }

    public void triggerDeathAchievement(DamageSource source, EntityCitizen citizen) {
    }

    public boolean onStackPickUp(@NotNull ItemStack pickedUpStack) {
        if (this.getCitizen().getWorkBuilding() != null && this.getCitizen().getWorkBuilding().overruleNextOpenRequestOfCitizenWithStack(this.getCitizen(), pickedUpStack.func_77946_l())) {
            return true;
        }
        return this.getCitizen().getHomeBuilding() != null && this.getCitizen().getHomeBuilding().overruleNextOpenRequestOfCitizenWithStack(this.getCitizen(), pickedUpStack.func_77946_l());
    }

    public void onLevelUp(int newLevel) {
    }

    public CitizenData getCitizen() {
        return this.citizen;
    }

    public void onWakeUp() {
        this.searchedForFoodToday = false;
    }

    public boolean isOkayToEat() {
        return this.workerAI.get() != null && ((AbstractAISkeleton)((Object)this.workerAI.get())).isOkayToEat();
    }

    public int getActionsDone() {
        return this.actionsDone;
    }

    public void incrementActionsDone() {
        ++this.actionsDone;
    }

    public void clearActionsDone() {
        this.actionsDone = 0;
    }

    public AbstractAISkeleton getWorkerAI() {
        return (AbstractAISkeleton)((Object)this.workerAI.get());
    }

    public boolean isIdling() {
        return this.workerAI.get() != null && ((AbstractAISkeleton)((Object)this.workerAI.get())).getState() == AIState.IDLE;
    }

    public void resetAIAfterEating() {
        if (this.workerAI.get() != null) {
            ((AbstractAISkeleton)((Object)this.workerAI.get())).resetAIToIdle();
        }
    }
}

