/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.entity.EntityCitizen;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

public class BuildingHome
extends AbstractBuilding {
    private static final String CITIZEN = "Citizen";
    @NotNull
    private final List<BlockPos> bedList = new ArrayList<BlockPos>();

    public BuildingHome(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b("residents")) {
            int[] residentIds;
            for (int citizenId : residentIds = compound.func_74759_k("residents")) {
                CitizenData citizen = this.getColony().getCitizenManager().getCitizen(citizenId);
                if (citizen == null) continue;
                this.assignCitizen(citizen);
            }
        }
        NBTTagList bedTagList = compound.func_150295_c("beds", 10);
        for (int i = 0; i < bedTagList.func_74745_c(); ++i) {
            NBTTagCompound bedCompound = bedTagList.func_150305_b(i);
            BlockPos bedPos = NBTUtil.func_186861_c((NBTTagCompound)bedCompound);
            if (this.bedList.contains(bedPos)) continue;
            this.bedList.add(bedPos);
        }
    }

    @Override
    public void onWakeUp() {
        World world = this.getColony().getWorld();
        if (world == null) {
            return;
        }
        for (BlockPos pos : this.bedList) {
            IBlockState state = world.func_180495_p(pos);
            if (!((state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos)).func_177230_c() instanceof BlockBed) || !((Boolean)state.func_177229_b((IProperty)BlockBed.field_176471_b)).booleanValue() || !((BlockBed.EnumPartType)state.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.HEAD)) continue;
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CITIZEN;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.hasAssignedCitizen()) {
            int[] residentIds = new int[this.getAssignedCitizen().size()];
            for (int i = 0; i < this.getAssignedCitizen().size(); ++i) {
                residentIds[i] = this.getAssignedCitizen().get(i).getId();
            }
            compound.func_74783_a("residents", residentIds);
        }
        if (!this.bedList.isEmpty()) {
            NBTTagList bedTagList = new NBTTagList();
            for (BlockPos pos : this.bedList) {
                bedTagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            }
            compound.func_74782_a("beds", (NBTBase)bedTagList);
        }
    }

    @Override
    public void registerBlockPosition(@NotNull IBlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(blockState, pos, world);
        BlockPos registrationPosition = pos;
        if (blockState.func_177230_c() instanceof BlockBed) {
            if (blockState.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT) {
                registrationPosition = registrationPosition.func_177972_a((EnumFacing)blockState.func_177229_b((IProperty)BlockBed.field_185512_D));
            }
            if (!this.bedList.contains(registrationPosition)) {
                this.bedList.add(registrationPosition);
            }
        }
    }

    @Override
    public void onDestroyed() {
        super.onDestroyed();
        this.getAssignedCitizen().stream().filter(Objects::nonNull).forEach(citizen -> citizen.setHomeBuilding(null));
    }

    @Override
    public void removeCitizen(@NotNull CitizenData citizen) {
        if (this.isCitizenAssigned(citizen)) {
            super.removeCitizen(citizen);
            citizen.setHomeBuilding(null);
        }
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (!Colony.shallUpdate(event.world, 20)) {
            return;
        }
        if (this.getAssignedCitizen().size() < this.getMaxInhabitants() && this.getColony() != null && !this.getColony().isManualHousing()) {
            this.addHomelessCitizens();
        }
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel();
    }

    private void addHomelessCitizens() {
        for (CitizenData citizen : this.getColony().getCitizenManager().getCitizens()) {
            if (citizen.getHomeBuilding() instanceof BuildingHome && citizen.getHomeBuilding().getBuildingLevel() < this.getBuildingLevel()) {
                citizen.getHomeBuilding().removeCitizen(citizen);
            }
            if (citizen.getHomeBuilding() != null) continue;
            this.assignCitizen(citizen);
            if (!this.isFull()) continue;
            break;
        }
    }

    @Override
    public boolean assignCitizen(CitizenData citizen) {
        if (!super.assignCitizen(citizen)) {
            return false;
        }
        citizen.setHomeBuilding(this);
        return true;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingColonist);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeColonistMax);
        }
        for (Optional<EntityCitizen> entityCitizen : this.getAssignedEntities()) {
            if (!entityCitizen.isPresent() || entityCitizen.get().getCitizenJobHandler().getColonyJob() != null) continue;
            entityCitizen.get().getCitizenJobHandler().setModelDependingOnJob(null);
        }
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.getAssignedCitizen().size());
        for (CitizenData citizen : this.getAssignedCitizen()) {
            buf.writeInt(citizen.getId());
        }
    }

    @Override
    public void setBuildingLevel(int level) {
        super.setBuildingLevel(level);
        this.getColony().getCitizenManager().calculateMaxCitizens();
    }

    @NotNull
    public List<BlockPos> getBedList() {
        return new ArrayList<BlockPos>(this.bedList);
    }

    public static class View
    extends AbstractBuildingView {
        @NotNull
        private final List<Integer> residents = new ArrayList<Integer>();

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @NotNull
        public List<Integer> getResidents() {
            return Collections.unmodifiableList(this.residents);
        }

        public void removeResident(int index) {
            this.residents.remove(index);
        }

        public void addResident(int id) {
            this.residents.add(id);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCitizen(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            int numResidents = buf.readInt();
            for (int i = 0; i < numResidents; ++i) {
                this.residents.add(buf.readInt());
            }
        }
    }
}

