/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowHutCowboy;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobCowboy;
import com.minecolonies.coremod.network.messages.CowboySetMilkCowsMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildingCowboy
extends AbstractBuildingWorker {
    private static final String COWBOY = "Cowboy";
    private static final String NBT_MILK_COWS = "MILK_COWS";
    private static final int MAX_BUILDING_LEVEL = 5;
    private boolean milkCows = true;

    public BuildingCowboy(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COWBOY;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return COWBOY;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobCowboy(citizen);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.milkCows);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74757_a(NBT_MILK_COWS, this.milkCows);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.milkCows = compound.func_74767_n(NBT_MILK_COWS);
    }

    public boolean isMilkingCows() {
        return this.milkCows;
    }

    public void setMilkCows(boolean milkCows) {
        this.milkCows = milkCows;
        this.markDirty();
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private boolean milkCows = true;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCowboy(this);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.DEXTERITY;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        public void setMilkCows(boolean milkCows) {
            MineColonies.getNetwork().sendToServer((IMessage)new CowboySetMilkCowsMessage(this, milkCows));
            this.milkCows = milkCows;
        }

        public boolean isMilkCows() {
            return this.milkCows;
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.milkCows = buf.readBoolean();
        }
    }
}

