/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.client.gui.WindowHutComposter;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobComposter;
import com.minecolonies.coremod.network.messages.AssignComposterItemMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildingComposter
extends AbstractBuildingWorker {
    private static final String COMPOSTER = "Composter";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_POS = "pos";
    private static final String TAG_BARRELS = "barrels";
    private final List<BlockPos> barrels = new ArrayList<BlockPos>();
    private static final String TAG_ITEMLIST = "itemList";
    private final List<ItemStorage> itemsAllowed = new ArrayList<ItemStorage>();

    public BuildingComposter(@NotNull Colony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> this.isAllowedItem(new ItemStorage((ItemStack)stack)), new Tuple((Object)Integer.MAX_VALUE, (Object)true));
    }

    public List<BlockPos> getBarrels() {
        return ImmutableList.copyOf(this.barrels);
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobComposter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return COMPOSTER;
    }

    @Override
    public String getSchematicName() {
        return COMPOSTER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block == ModBlocks.blockBarrel && !this.barrels.contains(pos)) {
            this.barrels.add(pos);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList furnacesTagList = new NBTTagList();
        for (BlockPos entry : this.barrels) {
            NBTTagCompound furnaceCompound = new NBTTagCompound();
            furnaceCompound.func_74782_a(TAG_POS, (NBTBase)NBTUtil.func_186859_a((BlockPos)entry));
            furnacesTagList.func_74742_a((NBTBase)furnaceCompound);
        }
        compound.func_74782_a(TAG_BARRELS, (NBTBase)furnacesTagList);
        NBTTagList itemsToCompost = new NBTTagList();
        for (ItemStorage entry : this.itemsAllowed) {
            NBTTagCompound itemCompound = new NBTTagCompound();
            entry.getItemStack().func_77955_b(itemCompound);
            itemsToCompost.func_74742_a((NBTBase)itemCompound);
        }
        compound.func_74782_a(TAG_ITEMLIST, (NBTBase)itemsToCompost);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList furnaceTagList = compound.func_150295_c(TAG_BARRELS, 10);
        for (int i = 0; i < furnaceTagList.func_74745_c(); ++i) {
            this.barrels.add(NBTUtil.func_186861_c((NBTTagCompound)furnaceTagList.func_150305_b(i).func_74775_l(TAG_POS)));
        }
        NBTTagList itemsToCompost = compound.func_150295_c(TAG_ITEMLIST, 10);
        for (int i = 0; i < itemsToCompost.func_74745_c(); ++i) {
            try {
                this.itemsAllowed.add(new ItemStorage(new ItemStack(itemsToCompost.func_150305_b(i))));
                continue;
            }
            catch (Exception e) {
                Log.getLogger().info("Removing incompatible stack");
            }
        }
    }

    public void addCompostableItem(ItemStorage item) {
        if (!this.itemsAllowed.contains(item)) {
            this.itemsAllowed.add(item);
        }
    }

    public boolean isAllowedItem(ItemStorage item) {
        return this.itemsAllowed.contains(item);
    }

    public void removeCompostableItem(ItemStorage item) {
        if (this.itemsAllowed.contains(item)) {
            this.itemsAllowed.remove(item);
        }
    }

    public List<ItemStorage> getCopyOfAllowedItems() {
        return new ArrayList<ItemStorage>(this.itemsAllowed);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.itemsAllowed.size());
        for (ItemStorage item : this.itemsAllowed) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)item.getItemStack());
        }
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private final List<ItemStorage> listOfItems = new ArrayList<ItemStorage>();

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        public void addCompostableItem(ItemStorage item) {
            MineColonies.getNetwork().sendToServer((IMessage)new AssignComposterItemMessage(this, item, true));
            if (!this.listOfItems.contains(item)) {
                this.listOfItems.add(item);
            }
        }

        public boolean isAllowedItem(ItemStorage item) {
            return this.listOfItems.contains(item);
        }

        public void removeCompostableItem(ItemStorage item) {
            MineColonies.getNetwork().sendToServer((IMessage)new AssignComposterItemMessage(this, item, false));
            if (this.listOfItems.contains(item)) {
                this.listOfItems.remove(item);
            }
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutComposter(this);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.DEXTERITY;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.listOfItems.add(new ItemStorage(ByteBufUtils.readItemStack((ByteBuf)buf)));
            }
        }
    }
}

