/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.blocks.huts.BlockHutBarracksTower;
import com.minecolonies.coremod.client.gui.WindowBarracksBuilding;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracksTower;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import java.util.Locale;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingBarracks
extends AbstractBuilding {
    private static final String SCHEMATIC_NAME = "Barracks";
    private static final int BARRACKS_HUT_MAX_LEVEL = 5;
    private static final int TOWER_OFFSET = 8;

    public BuildingBarracks(@NotNull Colony colony, BlockPos pos) {
        super(colony, pos);
    }

    @Override
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onDestroyed() {
        World world = this.getColony().getWorld();
        if (world != null) {
            for (int i = 1; i <= this.getBuildingLevel() && i < 5; ++i) {
                Tuple<BlockPos, EnumFacing> tuple = this.getPositionAndFacingForLevel(i);
                if (!(world.func_180495_p((BlockPos)tuple.func_76341_a()).func_177230_c() instanceof BlockHutBarracksTower)) continue;
                world.func_175656_a((BlockPos)tuple.func_76341_a(), Blocks.field_150350_a.func_176223_P());
            }
        }
        super.onDestroyed();
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        World world = this.getColony().getWorld();
        if (world != null) {
            for (int i = 1; i <= newLevel && i < 5; ++i) {
                AbstractBuilding building;
                Tuple<BlockPos, EnumFacing> tuple = this.getPositionAndFacingForLevel(i);
                if (!(world.func_180495_p((BlockPos)tuple.func_76341_a()).func_177230_c() instanceof BlockHutBarracksTower)) {
                    world.func_175656_a((BlockPos)tuple.func_76341_a(), ModBlocks.blockHutBarracksTower.func_176223_P().func_177226_a((IProperty)BlockHutBarracksTower.FACING, (Comparable)tuple.func_76340_b()));
                    this.getColony().getBuildingManager().addNewBuilding((TileEntityColonyBuilding)world.func_175625_s((BlockPos)tuple.func_76341_a()), world);
                }
                if (!((building = this.getColony().getBuildingManager().getBuilding((BlockPos)tuple.func_76341_a())) instanceof BuildingBarracksTower)) continue;
                building.setStyle(this.getStyle());
                ((BuildingBarracksTower)building).addBarracks(this.getLocation());
            }
        }
        super.onUpgradeComplete(newLevel);
    }

    private final Tuple<BlockPos, EnumFacing> getPositionAndFacingForLevel(int level) {
        BlockPos position = this.getLocation();
        int tempLevel = level;
        if (this.isMirrored()) {
            ++tempLevel;
        }
        switch (this.getRotation()) {
            case 1: {
                tempLevel += 3;
                break;
            }
            case 2: {
                ++tempLevel;
                break;
            }
            case 3: {
                tempLevel += 2;
                break;
            }
        }
        if (tempLevel > 4) {
            tempLevel -= 4;
        }
        EnumFacing facing = EnumFacing.NORTH;
        String styleName = this.getStyle().toLowerCase(Locale.ENGLISH);
        int offset = 8;
        if (styleName.contains("birch")) {
            ++offset;
        } else if (styleName.contains("sandstone")) {
            --offset;
        }
        switch (tempLevel) {
            case 1: {
                position = position.func_177967_a(EnumFacing.SOUTH, offset).func_177967_a(EnumFacing.WEST, offset);
                break;
            }
            case 2: {
                position = position.func_177967_a(EnumFacing.NORTH, offset).func_177967_a(EnumFacing.EAST, offset);
                facing = EnumFacing.SOUTH;
                break;
            }
            case 3: {
                position = position.func_177967_a(EnumFacing.SOUTH, offset).func_177967_a(EnumFacing.EAST, offset);
                facing = EnumFacing.WEST;
                break;
            }
            case 4: {
                position = position.func_177967_a(EnumFacing.NORTH, offset).func_177967_a(EnumFacing.WEST, offset);
                facing = EnumFacing.EAST;
                break;
            }
        }
        return new Tuple((Object)position, (Object)facing);
    }

    public static class View
    extends AbstractBuildingView {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowBarracksBuilding(this);
        }
    }
}

