/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowHutBuilder;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.network.messages.MarkBuildingDirtyMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowResourceList
extends AbstractWindowSkeleton {
    @Nullable
    private final BuildingBuilder.View builder;
    @NotNull
    private final List<BuildingBuilderResource> resources = new ArrayList<BuildingBuilderResource>();

    public WindowResourceList(int colonyId, BlockPos buildingPos) {
        super("minecolonies:gui/windowresourcescroll.xml");
        AbstractBuildingView buildingView;
        ColonyView colonyView = ColonyManager.getColonyView(colonyId);
        if (colonyView != null && (buildingView = colonyView.getBuilding(buildingPos)) instanceof AbstractBuildingBuilderView) {
            this.builder = (BuildingBuilder.View)buildingView;
            return;
        }
        LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "com.minecolonies.coremod.gui.resourcescroll.nobuilder", new Object[0]);
        this.builder = null;
    }

    private void pullResourcesFromHut() {
        AbstractBuildingView newView = this.builder.getColony().getBuilding(this.builder.getID());
        if (newView instanceof BuildingBuilder.View) {
            BuildingBuilder.View updatedView = (BuildingBuilder.View)newView;
            InventoryPlayer inventory = this.mc.field_71439_g.field_71071_by;
            boolean isCreative = this.mc.field_71439_g.field_71075_bZ.field_75098_d;
            this.resources.clear();
            this.resources.addAll(updatedView.getResources().values());
            for (BuildingBuilderResource resource : this.resources) {
                int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), stack -> ItemStackUtils.isEmpty(stack) == false && stack.func_77969_a(resource.getItemStack()));
                resource.setPlayerAmount(amountToSet);
            }
            this.resources.sort(new BuildingBuilderResource.ResourceComparator());
        }
    }

    @Override
    public void onOpened() {
        if (this.builder == null) {
            this.close();
            return;
        }
        super.onOpened();
        this.pullResourcesFromHut();
        ScrollingList resourceList = this.findPaneOfTypeByID("resources", ScrollingList.class);
        resourceList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowResourceList.this.resources.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                WindowResourceList.this.updateResourcePane(index, rowPane);
            }
        });
        MineColonies.getNetwork().sendToServer((IMessage)new MarkBuildingDirtyMessage(this.builder));
        this.findPaneOfTypeByID("constructionName", Label.class).setLabelText(this.builder.getConstructionName());
    }

    private void updateResourcePane(int index, @NotNull Pane rowPane) {
        BuildingBuilderResource resource = this.resources.get(index);
        Label resourceLabel = rowPane.findPaneOfTypeByID("resourceName", Label.class);
        Label resourceMissingLabel = rowPane.findPaneOfTypeByID("resourceMissing", Label.class);
        Label neededLabel = rowPane.findPaneOfTypeByID("resourceAvailableNeeded", Label.class);
        switch (resource.getAvailabilityStatus()) {
            case DONT_HAVE: {
                resourceLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                resourceMissingLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                neededLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                break;
            }
            case NEED_MORE: {
                resourceLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                resourceMissingLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                neededLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                break;
            }
            case HAVE_ENOUGH: {
                resourceLabel.setColor(WindowHutBuilder.DARKGREEN, WindowHutBuilder.DARKGREEN);
                resourceMissingLabel.setColor(WindowHutBuilder.DARKGREEN, WindowHutBuilder.DARKGREEN);
                neededLabel.setColor(WindowHutBuilder.DARKGREEN, WindowHutBuilder.DARKGREEN);
                break;
            }
            default: {
                resourceLabel.setColor(WindowHutBuilder.BLACK, WindowHutBuilder.BLACK);
                resourceMissingLabel.setColor(WindowHutBuilder.BLACK, WindowHutBuilder.BLACK);
                neededLabel.setColor(WindowHutBuilder.BLACK, WindowHutBuilder.BLACK);
            }
        }
        resourceLabel.setLabelText(resource.getName());
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setLabelText(Integer.toString(missing));
        } else {
            resourceMissingLabel.setLabelText("");
        }
        neededLabel.setLabelText(Integer.toString(resource.getAvailable()) + " / " + Integer.toString(resource.getAmount()));
        rowPane.findPaneOfTypeByID("resourceId", Label.class).setLabelText(Integer.toString(index));
        rowPane.findPaneOfTypeByID("resourceQuantity", Label.class).setLabelText(Integer.toString(resource.getAmount() - resource.getAvailable()));
        ItemStack stack = new ItemStack(resource.getItem(), 1, resource.getDamageValue());
        stack.func_77982_d(resource.getItemStack().func_77978_p());
        rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(stack);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.pullResourcesFromHut();
        this.window.findPaneOfTypeByID("resources", ScrollingList.class).refreshElementPanes();
    }
}

