/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.BuildingMoveMessage;
import com.structurize.coremod.client.gui.WindowBuildTool;
import com.structurize.coremod.management.StructureName;
import com.structurize.coremod.management.Structures;
import com.structurize.coremod.network.messages.SchematicRequestMessage;
import com.structurize.structures.helpers.Settings;
import com.structurize.structures.helpers.Structure;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowMoveBuilding
extends AbstractWindowSkeleton {
    private static final int POSSIBLE_ROTATIONS = 4;
    private static final int ROTATE_RIGHT = 1;
    private static final int ROTATE_180 = 2;
    private static final int ROTATE_LEFT = 3;
    @NotNull
    private final BlockPos pos;
    private final String schematicName;
    private final AbstractBuildingView building;

    public WindowMoveBuilding(@Nullable BlockPos pos, AbstractBuildingView building, String schematicName) {
        super("minecolonies:gui/windowmovebuilding.xml");
        this.building = building;
        this.schematicName = schematicName;
        this.pos = pos;
        this.init();
    }

    private void init() {
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("left", this::moveLeftClicked);
        this.registerButton("mirror", WindowMoveBuilding::mirror);
        this.registerButton("right", this::moveRightClicked);
        this.registerButton("down", this::moveBackClicked);
        this.registerButton("up", this::moveForwardClicked);
        this.registerButton("plus", WindowMoveBuilding::moveUpClicked);
        this.registerButton("minus", WindowMoveBuilding::moveDownClicked);
        this.registerButton("rotateRight", this::rotateRightClicked);
        this.registerButton("rotateLeft", this::rotateLeftClicked);
    }

    private static void mirror() {
        Settings.instance.mirror();
    }

    @Override
    public void onOpened() {
        if (Settings.instance.getActiveStructure() == null) {
            Settings.instance.setRotation(this.building.getRotation());
            if (this.building.isMirrored()) {
                Settings.instance.mirror();
            }
            Settings.instance.setPosition(this.pos);
            StructureName structureName = new StructureName("schematics", this.schematicName, this.building.getSchematicName() + this.building.getBuildingLevel());
            Structure structure = new Structure(null, structureName.toString(), new PlacementSettings().func_186220_a(BlockUtils.getRotation(Settings.instance.getRotation())).func_186214_a(Settings.instance.getMirror()));
            String md5 = Structures.getMD5((String)structureName.toString());
            if (structure.isTemplateMissing() || !structure.isCorrectMD5(md5)) {
                if (structure.isTemplateMissing()) {
                    Log.getLogger().info("Template structure " + structureName + " missing");
                } else {
                    Log.getLogger().info("structure " + structureName + " md5 error");
                }
                Log.getLogger().info("Request To Server for structure " + structureName);
                if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
                    MineColonies.getNetwork().sendToServer((IMessage)new SchematicRequestMessage(structureName.toString()));
                    return;
                }
                Log.getLogger().error("WindowMinecoloniesBuildTool: Need to download schematic on a standalone client/server. This should never happen");
            }
            Settings.instance.setStructureName(structureName.toString());
            Settings.instance.setActiveSchematic(structure);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (ColonyManager.isSchematicDownloaded()) {
            ColonyManager.setSchematicDownloaded(false);
        }
    }

    private static void moveUpClicked() {
        Settings.instance.moveTo(new BlockPos(0, 1, 0));
    }

    private static void moveDownClicked() {
        Settings.instance.moveTo(new BlockPos(0, -1, 0));
    }

    private void moveLeftClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176735_f()));
    }

    private void moveRightClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176746_e()));
    }

    private void moveForwardClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO()));
    }

    private void moveBackClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176734_d()));
    }

    private void rotateRightClicked() {
        WindowMoveBuilding.updateRotation((Settings.instance.getRotation() + 1) % 4);
    }

    private void rotateLeftClicked() {
        WindowMoveBuilding.updateRotation((Settings.instance.getRotation() + 3) % 4);
    }

    private void confirmClicked() {
        StructureName structureName = new StructureName(Settings.instance.getStructureName());
        if (structureName.getPrefix().equals("scans") && FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            WindowBuildTool.requestScannedSchematic((StructureName)structureName);
        } else {
            MineColonies.getNetwork().sendToServer((IMessage)new BuildingMoveMessage(structureName.toString(), structureName.toString(), Settings.instance.getPosition(), Settings.instance.getRotation(), Settings.instance.getMirror(), this.building));
        }
        if (!GuiScreen.func_146272_n()) {
            this.cancelClicked();
        }
    }

    private void cancelClicked() {
        this.building.openGui(false);
        Settings.instance.reset();
        this.close();
    }

    private static void updateRotation(int rotation) {
        PlacementSettings settings = new PlacementSettings();
        switch (rotation) {
            case 1: {
                settings.func_186220_a(Rotation.CLOCKWISE_90);
                break;
            }
            case 2: {
                settings.func_186220_a(Rotation.CLOCKWISE_180);
                break;
            }
            case 3: {
                settings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
                break;
            }
            default: {
                settings.func_186220_a(Rotation.NONE);
            }
        }
        Settings.instance.setRotation(rotation);
        if (Settings.instance.getActiveStructure() != null) {
            Settings.instance.getActiveStructure().setPlacementSettings(settings.func_186214_a(Settings.instance.getMirror()));
        }
    }
}

