/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingComposter;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WindowHutComposter
extends AbstractWindowWorkerBuilding<BuildingComposter.View> {
    private static final String BUTTON_PREV_PAGE = "prevPage";
    private static final String BUTTON_NEXT_PAGE = "nextPage";
    private static final String TAG_BUTTON_ASSIGN = "addItem";
    private static final String LIST_RECIPES = "items";
    private Button buttonPrevPage;
    private Button buttonNextPage;
    private ScrollingList recipeList;
    private static final String VIEW_PAGES = "pages";
    private static final String TAG_NAME = "name";
    private static final String RED_X = "X";
    private static final String APPROVE = Character.toString('\u2713');
    private static final String TAG_ICON = "icon";
    private final List<ItemStorage> compostableItems;

    public WindowHutComposter(BuildingComposter.View building) {
        super(building, "minecolonies:gui/windowHutComposter.xml");
        this.registerButton(BUTTON_PREV_PAGE, this::prevClicked);
        this.registerButton(BUTTON_NEXT_PAGE, this::nextClicked);
        this.registerButton(TAG_BUTTON_ASSIGN, this::assignClicked);
        this.compostableItems = ColonyManager.getCompatibilityManager().getCopyOfCompostableItems();
    }

    private void assignClicked(@NotNull Button button) {
        int row = this.recipeList.getListElementIndexByPane(button);
        if (button.getLabel().equals(APPROVE)) {
            button.setLabel(RED_X);
            ((BuildingComposter.View)this.building).removeCompostableItem(this.compostableItems.get(row));
        } else {
            button.setLabel(APPROVE);
            ((BuildingComposter.View)this.building).addCompostableItem(this.compostableItems.get(row));
        }
        this.window.findPaneOfTypeByID(LIST_RECIPES, ScrollingList.class).refreshElementPanes();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.findPaneOfTypeByID(BUTTON_PREV_PAGE, Button.class).setEnabled(false);
        this.buttonPrevPage = this.findPaneOfTypeByID(BUTTON_PREV_PAGE, Button.class);
        this.buttonNextPage = this.findPaneOfTypeByID(BUTTON_NEXT_PAGE, Button.class);
        this.recipeList = this.findPaneOfTypeByID(LIST_RECIPES, ScrollingList.class);
        this.recipeList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHutComposter.this.compostableItems.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage item = (ItemStorage)WindowHutComposter.this.compostableItems.get(index);
                ItemStack stack = item.getItemStack();
                String owner = stack.func_82833_r();
                rowPane.findPaneOfTypeByID(WindowHutComposter.TAG_NAME, Label.class).setLabelText(owner);
                Button assignButton = rowPane.findPaneOfTypeByID(WindowHutComposter.TAG_BUTTON_ASSIGN, Button.class);
                if (((BuildingComposter.View)WindowHutComposter.this.building).isAllowedItem(item)) {
                    assignButton.setLabel(APPROVE);
                } else {
                    assignButton.setLabel(WindowHutComposter.RED_X);
                }
                rowPane.findPaneOfTypeByID(WindowHutComposter.TAG_ICON, ItemIcon.class).setItem(stack);
            }
        });
    }

    @Override
    public String getBuildingName() {
        return "Composter Hut";
    }

    private void prevClicked() {
        this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).previousView();
        this.buttonPrevPage.setEnabled(false);
        this.buttonNextPage.setEnabled(true);
    }

    private void nextClicked() {
        this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).nextView();
        this.buttonPrevPage.setEnabled(true);
        this.buttonNextPage.setEnabled(false);
    }
}

