/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBaker;
import com.minecolonies.coremod.entity.ai.citizen.baker.BakerRecipes;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WindowHutBaker
extends AbstractWindowWorkerBuilding<BuildingBaker.View> {
    private static final String TAG_BUTTON_ASSIGN = "assignRecipe";
    private static final String LIST_RECIPES = "recipes";
    private Button buttonPrevPage;
    private Button buttonNextPage;
    private ScrollingList recipeList;
    private static final String VIEW_PAGES = "pages";
    private static final String TAG_NAME = "name";
    private static final String RED_X = "X";
    private static final String APPROVE = " ";
    private static final String TAG_ICON = "icon";

    public WindowHutBaker(BuildingBaker.View building) {
        super(building, "minecolonies:gui/windowHutBaker.xml");
        this.registerButton("prevPage", this::prevClicked);
        this.registerButton("nextPage", this::nextClicked);
        this.registerButton(TAG_BUTTON_ASSIGN, this::assignClicked);
    }

    private void assignClicked(@NotNull Button button) {
        int row = this.recipeList.getListElementIndexByPane(button);
        if (button.getLabel().equals(RED_X)) {
            button.setLabel(APPROVE);
            ((BuildingBaker.View)this.building).setRecipeAllowed(row, false, ((BuildingBaker.View)this.building).getID());
        } else {
            button.setLabel(RED_X);
            ((BuildingBaker.View)this.building).setRecipeAllowed(row, true, ((BuildingBaker.View)this.building).getID());
        }
        this.window.findPaneOfTypeByID(LIST_RECIPES, ScrollingList.class).refreshElementPanes();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        final List<IRecipeStorage> recipes = BakerRecipes.getRecipes();
        this.findPaneOfTypeByID("prevPage", Button.class).setEnabled(false);
        this.buttonPrevPage = this.findPaneOfTypeByID("prevPage", Button.class);
        this.buttonNextPage = this.findPaneOfTypeByID("nextPage", Button.class);
        this.recipeList = this.findPaneOfTypeByID(LIST_RECIPES, ScrollingList.class);
        this.recipeList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return recipes.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                IRecipeStorage recipe = (IRecipeStorage)recipes.get(index);
                ItemStack stack = recipe.getPrimaryOutput();
                String owner = stack.func_82833_r();
                rowPane.findPaneOfTypeByID(WindowHutBaker.TAG_NAME, Label.class).setLabelText(owner);
                Button assignButton = rowPane.findPaneOfTypeByID(WindowHutBaker.TAG_BUTTON_ASSIGN, Button.class);
                if (((BuildingBaker.View)WindowHutBaker.this.building).isRecipeAllowed(index)) {
                    assignButton.setLabel(WindowHutBaker.RED_X);
                } else {
                    assignButton.setLabel(WindowHutBaker.APPROVE);
                }
                rowPane.findPaneOfTypeByID(WindowHutBaker.TAG_ICON, ItemIcon.class).setItem(stack);
            }
        });
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.baker";
    }

    private void prevClicked() {
        this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).previousView();
        this.buttonPrevPage.setEnabled(false);
        this.buttonNextPage.setEnabled(true);
    }

    private void nextClicked() {
        this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).nextView();
        this.buttonPrevPage.setEnabled(true);
        this.buttonNextPage.setEnabled(false);
    }
}

