/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.HireFireMessage;
import com.minecolonies.coremod.network.messages.PauseCitizenMessage;
import com.minecolonies.coremod.network.messages.RestartCitizenMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHireWorker
extends Window
implements ButtonHandler {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String CITIZEN_LABEL = "citizen";
    private static final String CITIZEN_LIST = "unemployed";
    private static final String ATTRIBUTES_LABEL = "attributes";
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowhireworker.xml";
    private static final String BUTTON_FIRE = "fire";
    private static final String AUTO_HIRE_WARN = "autoHireWarn";
    private static final String BUTTON_PAUSE = "pause";
    private static final String BUTTON_RESTART = "restart";
    private final AbstractBuildingWorker.View building;
    private final ColonyView colony;
    private List<CitizenDataView> citizens = new ArrayList<CitizenDataView>();
    private final ScrollingList citizenList;

    public WindowHireWorker(ColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowhireworker.xml");
        this.colony = c;
        this.building = (AbstractBuildingWorker.View)this.colony.getBuilding(buildingId);
        this.citizenList = this.findPaneOfTypeByID(CITIZEN_LIST, ScrollingList.class);
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(this.colony.getCitizens().values());
        this.citizens = this.colony.getCitizens().values().stream().filter(citizen -> citizen.getWorkBuilding() == null && !this.building.hasEnoughWorkers() || this.building.getLocation().equals((Object)citizen.getWorkBuilding())).sorted(Comparator.comparing(CitizenDataView::getName)).collect(Collectors.toList());
    }

    @Override
    public void onOpened() {
        this.updateCitizens();
        this.findPaneOfTypeByID(AUTO_HIRE_WARN, Label.class).off();
        this.citizenList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHireWorker.this.citizens.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                CitizenDataView citizen = (CitizenDataView)WindowHireWorker.this.citizens.get(index);
                AbstractBuildingWorker.Skill primary = WindowHireWorker.this.building.getPrimarySkill();
                AbstractBuildingWorker.Skill secondary = WindowHireWorker.this.building.getSecondarySkill();
                Button isPaused = rowPane.findPaneOfTypeByID(WindowHireWorker.BUTTON_PAUSE, Button.class);
                if (citizen.getWorkBuilding() == null) {
                    rowPane.findPaneOfTypeByID(WindowHireWorker.BUTTON_FIRE, Button.class).off();
                    rowPane.findPaneOfTypeByID(WindowHireWorker.BUTTON_DONE, Button.class).on();
                    isPaused.off();
                } else {
                    rowPane.findPaneOfTypeByID(WindowHireWorker.BUTTON_DONE, Button.class).off();
                    rowPane.findPaneOfTypeByID(WindowHireWorker.BUTTON_FIRE, Button.class).on();
                    if (!WindowHireWorker.this.building.getColony().isManualHiring()) {
                        rowPane.findPaneOfTypeByID(WindowHireWorker.BUTTON_FIRE, Button.class).disable();
                        WindowHireWorker.this.findPaneOfTypeByID(WindowHireWorker.AUTO_HIRE_WARN, Label.class).on();
                    }
                    isPaused.on();
                    isPaused.setLabel(LanguageHandler.format(citizen.isPaused() ? "com.minecolonies.coremod.gui.hiring.buttonUnpaused" : "com.minecolonies.coremod.gui.hiring.buttonPaused", new Object[0]));
                }
                if (citizen.isPaused()) {
                    rowPane.findPaneOfTypeByID(WindowHireWorker.BUTTON_RESTART, Button.class).on();
                } else {
                    rowPane.findPaneOfTypeByID(WindowHireWorker.BUTTON_RESTART, Button.class).off();
                }
                String strength = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, AbstractBuildingWorker.Skill.STRENGTH), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.strength", citizen.getStrength()));
                String charisma = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, AbstractBuildingWorker.Skill.CHARISMA), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.charisma", citizen.getCharisma()));
                String dexterity = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, AbstractBuildingWorker.Skill.DEXTERITY), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.dexterity", citizen.getDexterity()));
                String endurance = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, AbstractBuildingWorker.Skill.ENDURANCE), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.endurance", citizen.getEndurance()));
                String intelligence = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, AbstractBuildingWorker.Skill.INTELLIGENCE), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.intelligence", citizen.getIntelligence()));
                String attributes = strength + " | " + charisma + " | " + dexterity + " | " + endurance + " | " + intelligence;
                rowPane.findPaneOfTypeByID(WindowHireWorker.CITIZEN_LABEL, Label.class).setLabelText(citizen.getName());
                rowPane.findPaneOfTypeByID(WindowHireWorker.ATTRIBUTES_LABEL, Label.class).setLabelText(attributes);
            }
        });
    }

    private static String createAttributeText(String color, String text) {
        return color + text + "\u00a7f";
    }

    private static String createColor(AbstractBuildingWorker.Skill primary, AbstractBuildingWorker.Skill secondary, AbstractBuildingWorker.Skill current) {
        if (primary == current) {
            return "\u00a72";
        }
        if (secondary == current) {
            return "\u00a7e";
        }
        return "";
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals(BUTTON_CANCEL)) {
            if (this.colony.getTownHall() != null) {
                this.building.openGui(false);
            }
            return;
        }
        int row = this.citizenList.getListElementIndexByPane(button);
        int id = this.citizens.toArray(new CitizenDataView[this.citizens.size()])[row].getId();
        CitizenDataView citizen = this.citizens.get(row);
        switch (button.getID()) {
            case "done": {
                this.building.addWorkerId(id);
                MineColonies.getNetwork().sendToServer((IMessage)new HireFireMessage(this.building, true, id));
                citizen.setWorkBuilding(this.building.getLocation());
                this.onOpened();
                break;
            }
            case "fire": {
                MineColonies.getNetwork().sendToServer((IMessage)new HireFireMessage(this.building, false, id));
                this.building.removeWorkerId(id);
                citizen.setWorkBuilding(null);
                this.onOpened();
                break;
            }
            case "pause": {
                MineColonies.getNetwork().sendToServer((IMessage)new PauseCitizenMessage(this.building, id));
                citizen.setPaused(!citizen.isPaused());
                break;
            }
            case "restart": {
                MineColonies.getNetwork().sendToServer((IMessage)new RestartCitizenMessage(this.building, id));
                this.close();
                break;
            }
        }
    }
}

