/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.inventory.CraftingGUIBuilding;
import com.minecolonies.coremod.network.messages.AddRemoveRecipeMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WindowGuiCrafting
extends GuiContainer {
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("minecolonies", "textures/gui/crafting2x2.png");
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES3X3 = new ResourceLocation("minecolonies", "textures/gui/crafting3x3.png");
    private static final int BUTTON_X_OFFSET = 1;
    private static final int BUTTON_Y_POS = 170;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int GUI_COLOR = 0x404040;
    private static final int X_OFFSET = 97;
    private static final int Y_OFFSET = 8;
    private static final int CRAFTING_GRID_SIZE = 4;
    private static final int MAX_CRAFTING_GRID_SIZE = 9;
    private GuiButton doneButton;
    private final AbstractBuildingWorker.View building;
    private final boolean completeCrafting;

    public WindowGuiCrafting(InventoryPlayer playerInv, World worldIn, AbstractBuildingWorker.View building) {
        super((Container)new CraftingGUIBuilding(playerInv, worldIn, building.canCraftComplexRecipes()));
        this.building = building;
        this.completeCrafting = building.canCraftComplexRecipes();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.doneButton = this.func_189646_b(new GuiButton(0, this.field_147003_i + 1, this.field_147009_r + 170, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        if (Math.pow(2.0, this.building.getBuildingLevel()) < (double)(this.building.getRecipes().size() + 1)) {
            this.doneButton.field_146126_j = LanguageHandler.format("com.minecolonies.coremod.gui.recipe.full", new Object[0]);
            this.doneButton.field_146124_l = false;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.doneButton.func_146115_a()) {
            LinkedList<ItemStack> input = new LinkedList<ItemStack>();
            ArrayList<ItemStack> secondaryOutput = new ArrayList<ItemStack>();
            for (int i = 1; i <= (this.completeCrafting ? 9 : 4); ++i) {
                ItemStack stack = (ItemStack)this.field_147002_h.func_75138_a().get(i);
                ItemStack copy = stack.func_77946_l();
                ItemStackUtils.setSize(copy, 1);
                input.add(copy);
                if (!copy.func_77973_b().hasContainerItem(copy)) continue;
                secondaryOutput.add(copy.func_77973_b().getContainerItem(copy));
            }
            ItemStack primaryOutput = this.field_147002_h.func_75139_a(0).func_75211_c().func_77946_l();
            if (!ItemStackUtils.isEmpty(primaryOutput).booleanValue()) {
                MineColonies.getNetwork().sendToServer((IMessage)new AddRemoveRecipeMessage(input, this.completeCrafting ? 3 : 2, primaryOutput, secondaryOutput, this.building, false));
                LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "com.minecolonies.coremod.gui.recipe.done", new Object[0]);
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0]), 97, 8, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.completeCrafting) {
            this.field_146297_k.func_110434_K().func_110577_a(CRAFTING_TABLE_GUI_TEXTURES3X3);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(CRAFTING_TABLE_GUI_TEXTURES);
        }
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

