/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Image;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowRequestDetail;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.network.messages.UpdateRequestStateMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowClipBoard
extends AbstractWindowSkeleton {
    private static final String BUILD_TOOL_RESOURCE_SUFFIX = ":gui/windowclipboard.xml";
    private static final String WINDOW_ID_LIST_REQUESTS = "requests";
    private static final String LIST_ELEMENT_ID_REQUEST_STACK = "requestStack";
    private static final String REQUEST_CANCEL = "cancel";
    private static final String REQUEST_DETAIL = "detail";
    private static final String REQUEST_SHORT_DETAIL = "shortDetail";
    private static final String DELIVERY_IMAGE = "deliveryImage";
    private static final String REQUESTER = "requester";
    private static final int LIFE_COUNT_DIVIDER = 30;
    private final ScrollingList resourceList = this.findPaneOfTypeByID("requests", ScrollingList.class);
    private final int colonyId;
    private int lifeCount = 0;

    public WindowClipBoard(@Nullable int colonyId) {
        super("minecolonies:gui/windowclipboard.xml");
        this.colonyId = colonyId;
    }

    @Override
    public void onOpened() {
        this.resourceList.setDataProvider(() -> this.getOpenRequests().size(), (index, rowPane) -> {
            ImmutableList<IRequest> openRequests = this.getOpenRequests();
            if (index < 0 || index >= openRequests.size()) {
                return;
            }
            IRequest request = (IRequest)openRequests.get(index);
            ItemIcon exampleStackDisplay = rowPane.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_STACK, ItemIcon.class);
            List<ItemStack> displayStacks = request.getDisplayStacks();
            if (!displayStacks.isEmpty()) {
                if (exampleStackDisplay != null) {
                    exampleStackDisplay.setItem(displayStacks.get(this.lifeCount / 30 % displayStacks.size()));
                }
            } else {
                Image logo = this.findPaneOfTypeByID(DELIVERY_IMAGE, Image.class);
                logo.setVisible(true);
                logo.setImage(request.getDisplayIcon());
            }
            ColonyView view = ColonyManager.getColonyView(this.colonyId);
            rowPane.findPaneOfTypeByID(REQUESTER, Label.class).setLabelText(request.getRequester().getDisplayName(view.getRequestManager(), (IToken<?>)request.getToken()).func_150254_d());
            rowPane.findPaneOfTypeByID(REQUEST_SHORT_DETAIL, Label.class).setLabelText(request.getShortDisplayString().func_150254_d().replace("\u00a7f", ""));
        });
    }

    private ImmutableList<IRequest> getOpenRequests() {
        ArrayList requests = Lists.newArrayList();
        ColonyView view = ColonyManager.getColonyView(this.colonyId);
        if (view == null) {
            return ImmutableList.of();
        }
        IPlayerRequestResolver resolver = view.getRequestManager().getPlayerResolver();
        IRetryingRequestResolver retryingRequestResolver = view.getRequestManager().getRetryingRequestResolver();
        HashSet requestTokens = new HashSet();
        requestTokens.addAll((Collection<IToken<?>>)resolver.getAllAssignedRequests());
        requestTokens.addAll((Collection<IToken<?>>)retryingRequestResolver.getAllAssignedRequests());
        requests.addAll(requestTokens.stream().map(view.getRequestManager()::getRequestForToken).filter(Objects::nonNull).collect(Collectors.toSet()));
        BlockPos playerPos = Minecraft.func_71410_x().field_71439_g.func_180425_c();
        requests.sort(Comparator.comparing(request -> request.getRequester().getDeliveryLocation().getInDimensionLocation().func_185332_f(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p())).thenComparingInt(request -> request.getToken().hashCode()));
        return ImmutableList.copyOf((Collection)requests);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!GuiScreen.func_146272_n()) {
            ++this.lifeCount;
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        switch (button.getID()) {
            case "detail": {
                this.detailedClicked(button);
                break;
            }
            case "cancel": {
                this.cancel(button);
                break;
            }
        }
    }

    private void detailedClicked(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane(button);
        if (this.getOpenRequests().size() > row && row >= 0) {
            WindowRequestDetail window = new WindowRequestDetail(null, (IRequest)this.getOpenRequests().get(row), this.colonyId);
            window.open();
        }
    }

    private void cancel(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane(button);
        if (this.getOpenRequests().size() > row && row >= 0) {
            IRequest request = (IRequest)this.getOpenRequests().get(row);
            MineColonies.getNetwork().sendToServer((IMessage)new UpdateRequestStateMessage(this.colonyId, (IToken)request.getToken(), RequestState.CANCELLED, null));
        }
    }
}

