/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.constant.WindowConstants;
import com.minecolonies.blockout.Alignment;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonImage;
import com.minecolonies.blockout.controls.Image;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.Box;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.blockout.views.View;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowRequestDetail;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import com.minecolonies.coremod.network.messages.TransferItemsToCitizenRequestMessage;
import com.minecolonies.coremod.network.messages.UpdateRequestStateMessage;
import com.minecolonies.coremod.util.ExperienceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowCitizen
extends AbstractWindowSkeleton {
    private final CitizenDataView citizen;
    private ScrollingList resourceList;
    private final InventoryPlayer inventory;
    private final boolean isCreative;
    private int lifeCount;

    public WindowCitizen(CitizenDataView citizen) {
        super("minecolonies:gui/citizen/windowcitizen.xml");
        this.inventory = this.mc.field_71439_g.field_71071_by;
        this.isCreative = this.mc.field_71439_g.field_71075_bZ.field_75098_d;
        this.lifeCount = 0;
        this.citizen = citizen;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!GuiScreen.func_146272_n()) {
            ++this.lifeCount;
        }
    }

    @Override
    public void onOpened() {
        this.findPaneOfTypeByID("name", Label.class).setLabelText(this.citizen.getName());
        WindowCitizen.createHealthBar(this.citizen, this.findPaneOfTypeByID("healthBar", View.class));
        this.createSaturationBar();
        this.createHappinessBar();
        WindowCitizen.createXpBar(this.citizen, this);
        WindowCitizen.createSkillContent(this.citizen, this);
        this.updateHappiness();
        this.resourceList = this.findPaneOfTypeByID("requests", ScrollingList.class);
        this.updateRequests();
        if (this.citizen.isFemale()) {
            this.findPaneOfTypeByID("gender", Image.class).setImage("minecolonies:textures/gui/citizen/colonist_wax_female_smaller.png");
        }
        this.setPage("");
    }

    private void updateRequests() {
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){
            private List<RequestWrapper> requestWrappers = null;

            @Override
            public int getElementCount() {
                this.requestWrappers = WindowCitizen.this.getOpenRequestTreeOfCitizen();
                return this.requestWrappers.size();
            }

            @Override
            public void updateElement(int index, Pane rowPane) {
                if (index < 0 || index >= this.requestWrappers.size()) {
                    return;
                }
                RequestWrapper wrapper = this.requestWrappers.get(index);
                Box wrapperBox = rowPane.findPaneOfTypeByID("requestx", Box.class);
                wrapperBox.setPosition(wrapperBox.getX() + 10 * wrapper.getDepth(), wrapperBox.getY());
                wrapperBox.setSize(wrapperBox.getParent().getWidth() - 10 * wrapper.getDepth(), wrapperBox.getHeight());
                rowPane.findPaneByID("fulfill").enable();
                IRequest request = wrapper.getRequest();
                ItemIcon exampleStackDisplay = rowPane.findPaneOfTypeByID("requestStack", ItemIcon.class);
                List<ItemStack> displayStacks = request.getDisplayStacks();
                Image logo = rowPane.findPaneOfTypeByID("deliveryImage", Image.class);
                if (!displayStacks.isEmpty()) {
                    logo.setVisible(false);
                    exampleStackDisplay.setVisible(true);
                    exampleStackDisplay.setItem(displayStacks.get(WindowCitizen.this.lifeCount / 30 % displayStacks.size()));
                } else {
                    exampleStackDisplay.setVisible(false);
                    logo.setVisible(true);
                    logo.setImage(request.getDisplayIcon());
                }
                ColonyView view = ColonyManager.getColonyView(WindowCitizen.this.citizen.getColonyId());
                rowPane.findPaneOfTypeByID("requester", Label.class).setLabelText(request.getRequester().getDisplayName(view.getRequestManager(), (IToken<?>)request.getToken()).func_150254_d());
                rowPane.findPaneOfTypeByID("shortDetail", Label.class).setLabelText(request.getShortDisplayString().func_150254_d().replace("\u00a7f", ""));
                if (wrapper.getDepth() > 0) {
                    request.getRequestOfType(IDeliverable.class).ifPresent(requestRequest -> {
                        if (!WindowCitizen.this.isCreative) {
                            if (!InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)WindowCitizen.this.inventory), requestRequest::matches)) {
                                rowPane.findPaneOfTypeByID("fulfill", ButtonImage.class).hide();
                            }
                        }
                    });
                    if (!(request.getRequest() instanceof IDeliverable)) {
                        rowPane.findPaneOfTypeByID("fulfill", ButtonImage.class).hide();
                    }
                    rowPane.findPaneOfTypeByID("cancel", ButtonImage.class).hide();
                } else {
                    request.getRequestOfType(IDeliverable.class).ifPresent(requestRequest -> {
                        if (!WindowCitizen.this.isCreative) {
                            if (!InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)WindowCitizen.this.inventory), requestRequest::matches)) {
                                rowPane.findPaneOfTypeByID("fulfill", ButtonImage.class).hide();
                            }
                        }
                    });
                }
            }
        });
    }

    public static void createHealthBar(CitizenDataView citizen, View healthBarView) {
        int health = (int)citizen.getHealth();
        healthBarView.setAlignment(Alignment.MIDDLE_RIGHT);
        healthBarView.findPaneOfTypeByID("healthLabel", Label.class).setLabelText(Integer.toString(health / 2));
        for (int i = 0; i < 10; ++i) {
            WindowCitizen.addHeart(healthBarView, i, HeartsEnum.EMPTY);
        }
        int heartPos = 0;
        ArrayList<HeartsEnum> heartList = new ArrayList<HeartsEnum>();
        heartList.add(HeartsEnum.BLUE);
        heartList.add(HeartsEnum.GREEN);
        heartList.add(HeartsEnum.GOLDEN);
        heartList.add(HeartsEnum.RED);
        for (HeartsEnum heart : heartList) {
            if (heart.isHalfHeart || heart.prevHeart == null) continue;
            for (int i = heartPos; i < 10 && health > heart.prevHeart.hpValue * 10 + 1; ++i) {
                WindowCitizen.addHeart(healthBarView, heartPos, heart);
                health -= heart.hpValue - heart.prevHeart.hpValue;
                ++heartPos;
            }
            if (health % 2 == 1 && heartPos < 10 && heart.halfHeart != null && health > heart.prevHeart.hpValue * 10) {
                WindowCitizen.addHeart(healthBarView, heartPos, heart.prevHeart);
                WindowCitizen.addHeart(healthBarView, heartPos, heart.halfHeart);
                health -= heart.halfHeart.hpValue - heart.prevHeart.hpValue;
                ++heartPos;
            }
            if (heartPos < 10) continue;
            return;
        }
    }

    private static void addHeart(View healthBarView, int heartPos, HeartsEnum heart) {
        Image heartImage = new Image();
        heartImage.setImage(heart.Image, heart.X, heart.Y, 9, 9, false);
        heartImage.setPosition(heartPos * 10 + 10, 10);
        healthBarView.addChild(heartImage);
    }

    private void createSaturationBar() {
        int saturationPos;
        Image saturation;
        this.findPaneOfTypeByID("saturationBar", View.class).setAlignment(Alignment.MIDDLE_RIGHT);
        for (int i = 0; i < 10; ++i) {
            saturation = new Image();
            saturation.setImage(Gui.field_110324_m, 16, 27, 9, 9, false);
            saturation.setPosition(i * 10 + 10, 10);
            this.findPaneOfTypeByID("saturationBar", View.class).addChild(saturation);
        }
        for (saturationPos = 0; saturationPos < (int)this.citizen.getSaturation(); ++saturationPos) {
            saturation = new Image();
            saturation.setImage(Gui.field_110324_m, 52, 27, 9, 9, false);
            saturation.setPosition(saturationPos * 10 + 10, 10);
            this.findPaneOfTypeByID("saturationBar", View.class).addChild(saturation);
        }
        if (this.citizen.getSaturation() / 2.0 % 1.0 > 0.0) {
            saturation = new Image();
            saturation.setImage(Gui.field_110324_m, 61, 27, 9, 9, false);
            saturation.setPosition(saturationPos * 10 + 10, 10);
            this.findPaneOfTypeByID("saturationBar", View.class).addChild(saturation);
        }
    }

    private void createHappinessBar() {
        double experienceRatio = this.citizen.getHappiness() / 10.0 * 91.0;
        this.findPaneOfTypeByID("happinessBar", View.class).setAlignment(Alignment.MIDDLE_RIGHT);
        this.window.findPaneOfTypeByID("happinessLabel", Label.class).setLabelText(Integer.toString((int)this.citizen.getHappiness()));
        Image xpBar = new Image();
        xpBar.setImage(Gui.field_110324_m, 0, 74, 91, 5, false);
        xpBar.setPosition(10, 10);
        Image xpBar2 = new Image();
        xpBar2.setImage(Gui.field_110324_m, 172, 74, 10, 5, false);
        xpBar2.setPosition(100, 10);
        this.window.findPaneOfTypeByID("happinessBar", View.class).addChild(xpBar);
        this.window.findPaneOfTypeByID("happinessBar", View.class).addChild(xpBar2);
        if (experienceRatio > 0.0) {
            Image xpBarFull = new Image();
            xpBarFull.setImage(Gui.field_110324_m, 0, 79, (int)experienceRatio, 5, false);
            xpBarFull.setPosition(10, 10);
            this.window.findPaneOfTypeByID("happinessBar", View.class).addChild(xpBarFull);
        }
    }

    public static void createXpBar(CitizenDataView citizen, AbstractWindowSkeleton window) {
        double experienceRatio = ExperienceUtils.getPercentOfLevelCompleted(citizen.getExperience(), citizen.getLevel());
        window.findPaneOfTypeByID("xpLabel", Label.class).setLabelText(Integer.toString(citizen.getLevel()));
        Image xpBar = new Image();
        xpBar.setImage(Gui.field_110324_m, 0, 64, 91, 5, false);
        xpBar.setPosition(10, 10);
        Image xpBar2 = new Image();
        xpBar2.setImage(Gui.field_110324_m, 172, 64, 10, 5, false);
        xpBar2.setPosition(100, 10);
        window.findPaneOfTypeByID("xpBar", View.class).addChild(xpBar);
        window.findPaneOfTypeByID("xpBar", View.class).addChild(xpBar2);
        if (experienceRatio > 0.0) {
            Image xpBarFull = new Image();
            xpBarFull.setImage(Gui.field_110324_m, 0, 69, (int)experienceRatio, 5, false);
            xpBarFull.setPosition(10, 10);
            window.findPaneOfTypeByID("xpBar", View.class).addChild(xpBarFull);
        }
    }

    public static void createHappinessBar(CitizenDataView citizen, AbstractWindowSkeleton window) {
        double experienceRatio = citizen.getHappiness() / 10.0 * 91.0;
        window.findPaneOfTypeByID("happinessBar", View.class).setAlignment(Alignment.MIDDLE_RIGHT);
        window.findPaneOfTypeByID("happinessLabel", Label.class).setLabelText(Integer.toString((int)citizen.getHappiness()));
        Image xpBar = new Image();
        xpBar.setImage(Gui.field_110324_m, 0, 74, 91, 5, false);
        xpBar.setPosition(10, 10);
        Image xpBar2 = new Image();
        xpBar2.setImage(Gui.field_110324_m, 172, 74, 10, 5, false);
        xpBar2.setPosition(100, 10);
        window.findPaneOfTypeByID("happinessBar", View.class).addChild(xpBar);
        window.findPaneOfTypeByID("happinessBar", View.class).addChild(xpBar2);
        if (experienceRatio > 0.0) {
            Image xpBarFull = new Image();
            xpBarFull.setImage(Gui.field_110324_m, 0, 79, (int)experienceRatio, 5, false);
            xpBarFull.setPosition(10, 10);
            window.findPaneOfTypeByID("happinessBar", View.class).addChild(xpBarFull);
        }
    }

    public static void createSkillContent(CitizenDataView citizen, AbstractWindowSkeleton window) {
        window.findPaneOfTypeByID("strength", Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.strength", citizen.getStrength()));
        window.findPaneOfTypeByID("endurance", Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.endurance", citizen.getEndurance()));
        window.findPaneOfTypeByID("charisma", Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.charisma", citizen.getCharisma()));
        window.findPaneOfTypeByID("intelligence", Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.intelligence", citizen.getIntelligence()));
        window.findPaneOfTypeByID("dexterity", Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.dexterity", citizen.getDexterity()));
    }

    private ImmutableList<RequestWrapper> getOpenRequestTreeOfCitizen() {
        ColonyView colonyView = ColonyManager.getClosestColonyView((World)FMLClientHandler.instance().getWorldClient(), this.citizen.getWorkBuilding() != null ? this.citizen.getWorkBuilding() : this.citizen.getHomeBuilding());
        if (colonyView == null) {
            return ImmutableList.of();
        }
        ArrayList treeElements = new ArrayList();
        this.getOpenRequestsOfCitizen().stream().forEach(r -> this.constructTreeFromRequest(colonyView.getRequestManager(), (IRequest<?>)r, treeElements, 0));
        return ImmutableList.copyOf(treeElements);
    }

    private void constructTreeFromRequest(@NotNull IRequestManager manager, @NotNull IRequest<?> request, @NotNull List<RequestWrapper> list, int currentDepth) {
        list.add(new RequestWrapper(request, currentDepth));
        if (request.hasChildren()) {
            for (Object o : request.getChildren()) {
                IToken iToken;
                IRequest<?> childRequest;
                if (!(o instanceof IToken) || (childRequest = manager.getRequestForToken(iToken = (IToken)o)) == null) continue;
                this.constructTreeFromRequest(manager, childRequest, list, currentDepth + 1);
            }
        }
    }

    private ImmutableList<IRequest> getOpenRequestsOfCitizen() {
        ArrayList<IRequest> requests = new ArrayList<IRequest>();
        if (this.citizen.getWorkBuilding() != null) {
            requests.addAll((Collection<IRequest>)this.getOpenRequestsOfCitizenFromBuilding(this.citizen.getWorkBuilding()));
        }
        if (this.citizen.getHomeBuilding() != null && !this.citizen.getHomeBuilding().equals((Object)this.citizen.getWorkBuilding())) {
            requests.addAll((Collection<IRequest>)this.getOpenRequestsOfCitizenFromBuilding(this.citizen.getHomeBuilding()));
        }
        BlockPos playerPos = Minecraft.func_71410_x().field_71439_g.func_180425_c();
        requests.sort(Comparator.comparing(request -> request.getRequester().getDeliveryLocation().getInDimensionLocation().func_185332_f(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p())).thenComparingInt(request -> request.getToken().hashCode()));
        return ImmutableList.copyOf(requests);
    }

    private ImmutableList<IRequest> getOpenRequestsOfCitizenFromBuilding(BlockPos buildingPos) {
        ColonyView colonyView = ColonyManager.getClosestColonyView((World)FMLClientHandler.instance().getWorldClient(), buildingPos);
        if (colonyView == null) {
            return ImmutableList.of();
        }
        AbstractBuildingView building = colonyView.getBuilding(buildingPos);
        if (building == null) {
            return ImmutableList.of();
        }
        return building.getOpenRequests(this.citizen);
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        switch (button.getID()) {
            case "requestsTitle": {
                this.findPaneOfTypeByID("head", SwitchView.class).nextView();
                this.buttonPrevPage.off();
                this.buttonNextPage.off();
                this.pageNum.off();
                break;
            }
            case "back": {
                this.findPaneOfTypeByID("head", SwitchView.class).previousView();
                this.setPage("");
                break;
            }
            case "inventory": {
                MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(this.citizen.getName(), this.citizen.getEntityId()));
                break;
            }
            case "detail": {
                this.detailedClicked(button);
                break;
            }
            case "cancel": {
                this.cancel(button);
                break;
            }
            case "fulfill": {
                this.fulfill(button);
                break;
            }
            default: {
                super.onButtonClicked(button);
            }
        }
    }

    private void detailedClicked(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane(button);
        if (this.getOpenRequestTreeOfCitizen().size() > row) {
            WindowRequestDetail window = new WindowRequestDetail(this.citizen, ((RequestWrapper)this.getOpenRequestTreeOfCitizen().get(row)).getRequest(), this.citizen.getColonyId());
            window.open();
        }
    }

    private void cancel(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane(button);
        if (this.getOpenRequestTreeOfCitizen().size() > row && row >= 0) {
            IRequest request = ((RequestWrapper)this.getOpenRequestTreeOfCitizen().get(row)).getRequest();
            MineColonies.getNetwork().sendToServer((IMessage)new UpdateRequestStateMessage(this.citizen.getColonyId(), (IToken)request.getToken(), RequestState.CANCELLED, null));
        }
        this.updateRequests();
    }

    private void fulfill(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane(button);
        if (this.getOpenRequestTreeOfCitizen().size() > row && row >= 0) {
            IRequest tRequest = ((RequestWrapper)this.getOpenRequestTreeOfCitizen().get(row)).getRequest();
            if (!(tRequest.getRequest() instanceof IDeliverable)) {
                return;
            }
            IRequest request = tRequest;
            Predicate<ItemStack> requestPredicate = stack -> ((IDeliverable)request.getRequest()).matches((ItemStack)stack);
            int amount = ((IDeliverable)request.getRequest()).getCount();
            int count = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.inventory), requestPredicate);
            if (!this.isCreative && count <= 0) {
                return;
            }
            ItemStack itemStack = this.isCreative ? request.getDisplayStacks().stream().findFirst().orElse(ItemStack.field_190927_a) : this.inventory.func_70301_a(InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.inventory), requestPredicate));
            MineColonies.getNetwork().sendToServer((IMessage)new TransferItemsToCitizenRequestMessage(this.citizen, itemStack, this.isCreative ? amount : Math.min(amount, count), this.citizen.getColonyId()));
            MineColonies.getNetwork().sendToServer((IMessage)new UpdateRequestStateMessage(this.citizen.getColonyId(), (IToken)request.getToken(), RequestState.OVERRULED, itemStack));
        }
        button.disable();
        this.updateRequests();
    }

    private void updateHappiness() {
        int row = 1;
        double[] levels = new double[]{this.citizen.getFoodModifier(), this.citizen.getHouseModifier(), this.citizen.getDamageModifier(), this.citizen.getJobModifier(), this.citizen.getFieldsModifier(), this.citizen.getToolsModifiers()};
        String[] labelIds = new String[]{"com.minecolonies.coremod.gui.happiness.food", "com.minecolonies.coremod.gui.happiness.damage", "com.minecolonies.coremod.gui.happiness.house", "com.minecolonies.coremod.gui.happiness.job", "com.minecolonies.coremod.gui.happiness.farms", "com.minecolonies.coremod.gui.happiness.tools"};
        this.findPaneOfTypeByID("happinessModifierView", View.class).setAlignment(Alignment.MIDDLE_RIGHT);
        if (this.findPaneByID("happinessModifierView") != null) {
            Image image;
            int i;
            this.findPaneOfTypeByID("happinessModifier", Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.happiness.happinessModifier", new Object[0]));
            for (i = 0; i < levels.length; ++i) {
                image = this.findPaneOfTypeByID("modifierImage" + row, Image.class);
                if (levels[i] < 0.0) {
                    this.findPaneOfTypeByID("modifier" + row, Label.class).setLabelText(LanguageHandler.format(labelIds[i], new Object[0]));
                    image.setImage("minecolonies:textures/gui/red_icon.png");
                    ++row;
                    continue;
                }
                if (!(levels[i] > 0.0)) continue;
                this.findPaneOfTypeByID("modifier" + row, Label.class).setLabelText(LanguageHandler.format(labelIds[i], new Object[0]));
                image.setImage("minecolonies:textures/gui/green_icon.png");
                ++row;
            }
            for (i = row; i <= levels.length; ++i) {
                image = this.findPaneOfTypeByID("modifierImage" + i, Image.class);
                image.hide();
            }
        }
    }

    private final class RequestWrapper {
        private final IRequest request;
        private final int depth;

        private RequestWrapper(IRequest request, int depth) {
            this.request = request;
            this.depth = depth;
        }

        public IRequest getRequest() {
            return this.request;
        }

        public int getDepth() {
            return this.depth;
        }
    }

    private static enum HeartsEnum {
        EMPTY(Gui.field_110324_m, 16, 0, 0, null, null),
        HALF_RED(Gui.field_110324_m, 61, 0, 1, null, EMPTY),
        RED(Gui.field_110324_m, 52, 0, 2, HALF_RED, EMPTY),
        HALF_GOLDEN(Gui.field_110324_m, 169, 0, 3, null, RED),
        GOLDEN(Gui.field_110324_m, 160, 0, 4, HALF_GOLDEN, RED),
        HALF_GREEN(WindowConstants.GREEN_BLUE_ICON, 8, 0, 5, null, GOLDEN),
        GREEN(WindowConstants.GREEN_BLUE_ICON, 0, 0, 6, HALF_GREEN, GOLDEN),
        HALF_BLUE(WindowConstants.GREEN_BLUE_ICON, 8, 8, 7, null, GREEN),
        BLUE(WindowConstants.GREEN_BLUE_ICON, 0, 8, 8, HALF_BLUE, GREEN);

        private final int X;
        private final int Y;
        private final int hpValue;
        private final HeartsEnum prevHeart;
        private final HeartsEnum halfHeart;
        private boolean isHalfHeart = false;
        private final ResourceLocation Image;

        private HeartsEnum(ResourceLocation heartImage, int x, int y, int hpValue, HeartsEnum halfHeart, HeartsEnum prevHeart) {
            this.Image = heartImage;
            this.X = x;
            this.Y = y;
            this.hpValue = hpValue;
            this.halfHeart = halfHeart;
            if (halfHeart == null) {
                this.isHalfHeart = true;
            }
            this.prevHeart = prevHeart;
        }
    }
}

