/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowBuildBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.BuildRequestMessage;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class AbstractWindowBuilding<B extends AbstractBuildingView>
extends AbstractWindowSkeleton {
    protected final B building;
    private final Label title;
    private final Button buttonBuild;
    private final Button buttonRepair;

    public AbstractWindowBuilding(B building, String resource) {
        super(resource);
        this.building = building;
        this.registerButton("build", this::buildClicked);
        this.registerButton("repair", this::repairClicked);
        this.registerButton("inventory", this::inventoryClicked);
        this.title = this.findPaneOfTypeByID("name", Label.class);
        this.buttonBuild = this.findPaneOfTypeByID("build", Button.class);
        this.buttonRepair = this.findPaneOfTypeByID("repair", Button.class);
    }

    private void buildClicked() {
        if (this.buttonBuild.getLabel().equalsIgnoreCase(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelBuild", new Object[0])) || this.buttonBuild.getLabel().equalsIgnoreCase(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelUpgrade", new Object[0]))) {
            MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((AbstractBuildingView)this.building, 0));
        } else {
            WindowBuildBuilding window = new WindowBuildBuilding(((AbstractBuildingView)this.building).getColony(), ((AbstractBuildingView)this.building).getLocation());
            window.open();
        }
    }

    private void repairClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((AbstractBuildingView)this.building, 1));
    }

    private void inventoryClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(((AbstractBuildingView)this.building).getID()));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.switchView.getCurrentView().getID().equals("pageActions")) {
            AbstractBuildingView buildingView = ((AbstractBuildingView)this.building).getColony().getBuilding(((AbstractBuildingView)this.building).getID());
            if (this.title != null) {
                if (this.switchView.getID().equals("switchpageActions")) {
                    this.title.setLabelText(this.getBuildingName());
                    this.findPaneOfTypeByID("level", Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.buildingLevel", new Object[0]) + ": " + buildingView.getBuildingLevel());
                } else {
                    this.title.setLabelText(LanguageHandler.format(this.getBuildingName(), new Object[0]) + " " + buildingView.getBuildingLevel());
                }
            }
            this.updateButtonBuild(buildingView);
            this.updateButtonRepair(buildingView);
        }
    }

    public abstract String getBuildingName();

    private void updateButtonBuild(AbstractBuildingView buildingView) {
        if (this.buttonBuild == null) {
            return;
        }
        if (buildingView.isBuildingMaxLevel()) {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.switchStyle", new Object[0]));
        } else if (buildingView.isBuilding()) {
            if (buildingView.getBuildingLevel() == 0) {
                this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelBuild", new Object[0]));
            } else {
                this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelUpgrade", new Object[0]));
            }
        } else if (buildingView.getBuildingLevel() == 0) {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.build", new Object[0]));
        } else {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.upgrade", new Object[0]));
        }
    }

    private void updateButtonRepair(AbstractBuildingView buildingView) {
        if (this.buttonRepair == null) {
            return;
        }
        this.buttonRepair.setVisible(buildingView.getBuildingLevel() != 0 && !buildingView.isBuilding());
        if (buildingView.isRepairing()) {
            this.buttonRepair.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelRepair", new Object[0]));
        } else {
            this.buttonRepair.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.repair", new Object[0]));
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.setPage("");
    }
}

