/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.AbstractBlockMinecolonies;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.blocks.types.RackType;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.tileentities.TileEntityRack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class BlockMinecoloniesRack
extends AbstractBlockMinecolonies<BlockMinecoloniesRack> {
    public static final PropertyEnum<RackType> VARIANT = PropertyEnum.func_177709_a((String)"variant", RackType.class);
    public static final int DEFAULT_META = RackType.DEFAULT.getMetadata();
    public static final int FULL_META = RackType.FULL.getMetadata();
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final float BLOCK_HARDNESS = 10.0f;
    private static final String BLOCK_NAME = "blockMinecoloniesRack";
    private static final float RESISTANCE = Float.POSITIVE_INFINITY;
    private static final int LIGHT_OPACITY = 0;

    public BlockMinecoloniesRack() {
        super(Material.field_151575_d);
        this.initBlock();
    }

    private void initBlock() {
        this.setRegistryName("minecolonies".toLowerCase() + ":" + BLOCK_NAME);
        this.func_149663_c(String.format("%s.%s", "minecolonies".toLowerCase(), BLOCK_NAME));
        this.func_149647_a(ModCreativeTabs.MINECOLONIES);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(VARIANT, (Comparable)((Object)RackType.DEFAULT)));
        this.func_149711_c(10.0f);
        this.func_149752_b(Float.POSITIVE_INFINITY);
        this.func_149713_g(0);
    }

    public static boolean shouldBlockBeReplacedWithRack(Block block) {
        return block == Blocks.field_150486_ae || block == ModBlocks.blockRack;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumFacing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumFacing);
    }

    public int func_176201_c(@NotNull IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (!(entity instanceof TileEntityRack)) {
            return super.func_176221_a(state, worldIn, pos);
        }
        TileEntityRack rack = (TileEntityRack)entity;
        if (rack.isEmpty() && (rack.getOtherChest() == null || rack.getOtherChest().isEmpty())) {
            if (rack.getOtherChest() != null) {
                if (rack.isMain()) {
                    return state.func_177226_a(VARIANT, (Comparable)((Object)RackType.DEFAULTDOUBLE)).func_177226_a((IProperty)FACING, (Comparable)BlockPosUtil.getFacing(rack.getNeighbor(), pos));
                }
                return state.func_177226_a(VARIANT, (Comparable)((Object)RackType.EMPTYAIR));
            }
            return state.func_177226_a(VARIANT, (Comparable)((Object)RackType.DEFAULT));
        }
        if (rack.getOtherChest() != null) {
            if (rack.isMain()) {
                return state.func_177226_a(VARIANT, (Comparable)((Object)RackType.FULLDOUBLE)).func_177226_a((IProperty)FACING, (Comparable)BlockPosUtil.getFacing(rack.getNeighbor(), pos));
            }
            return state.func_177226_a(VARIANT, (Comparable)((Object)RackType.EMPTYAIR));
        }
        return state.func_177226_a(VARIANT, (Comparable)((Object)RackType.FULL));
    }

    @Deprecated
    @NotNull
    public IBlockState func_185499_a(@NotNull IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Deprecated
    @NotNull
    public IBlockState func_185471_a(@NotNull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177230_c() instanceof BlockMinecoloniesRack) {
            TileEntity rack = worldIn.func_175625_s(pos);
            for (EnumFacing offsetFacing : BlockHorizontal.field_185512_D.func_177700_c()) {
                BlockPos neighbor = pos.func_177972_a(offsetFacing);
                Block block = worldIn.func_180495_p(neighbor).func_177230_c();
                if (!(rack instanceof TileEntityRack) || pos.func_177956_o() != neighbor.func_177956_o() || pos.equals((Object)neighbor) || pos.equals((Object)BlockPos.field_177992_a) || !(block instanceof BlockMinecoloniesRack) && !(blockIn instanceof BlockMinecoloniesRack)) continue;
                ((TileEntityRack)rack).neighborChanged(neighbor);
            }
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public void func_180663_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityRack) {
            IItemHandlerModifiable handler = ((TileEntityRack)tileentity).getInventory();
            InventoryUtils.dropItemHandler((IItemHandler)handler, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Colony colony = ColonyManager.getColonyByPosFromWorld(worldIn, pos);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if ((colony == null || colony.getPermissions().hasPermission(playerIn, Action.ACCESS_HUTS)) && tileEntity instanceof TileEntityRack) {
            if (!worldIn.field_72995_K) {
                playerIn.openGui((Object)MineColonies.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        IBlockState tempState = state;
        tempState = tempState.func_177226_a(VARIANT, (Comparable)((Object)RackType.byMetadata(stack.func_77952_i())));
        tempState = tempState.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
        worldIn.func_180501_a(pos, tempState, 2);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, RackType.DEFAULT.getMetadata()));
    }

    @Deprecated
    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, VARIANT});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityRack();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((Block)this, 1));
        return drops;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1);
    }
}

