/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.blockout;

import com.minecolonies.blockout.Alignment;
import com.minecolonies.blockout.PaneParams;
import com.minecolonies.blockout.Render;
import com.minecolonies.blockout.Screen;
import com.minecolonies.blockout.views.View;
import com.minecolonies.blockout.views.Window;
import java.nio.FloatBuffer;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Pane
extends Gui {
    @NotNull
    private static final Deque<ScissorsInfo> scissorsInfoStack = new ConcurrentLinkedDeque<ScissorsInfo>();
    private static final int SCISSOR_X_INDEX = 12;
    private static final int SCISSOR_Y_INDEX = 13;
    protected static Pane lastClickedPane;
    protected static Pane focus;
    protected Pane onHover;
    protected static boolean debugging;
    protected Minecraft mc = Minecraft.func_71410_x();
    protected String id = "";
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected Alignment alignment = Alignment.TOP_LEFT;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected String onHoverId = "";
    protected Window window;
    protected View parent;

    public Pane() {
    }

    public Pane(@NotNull PaneParams params) {
        this.id = params.getStringAttribute("id", this.id);
        PaneParams.SizePair parentSizePair = new PaneParams.SizePair(params.getParentWidth(), params.getParentHeight());
        PaneParams.SizePair sizePair = params.getSizePairAttribute("size", null, parentSizePair);
        if (sizePair != null) {
            this.width = sizePair.getX();
            this.height = sizePair.getY();
        } else {
            this.width = params.getScalableIntegerAttribute("width", this.width, parentSizePair.getX());
            this.height = params.getScalableIntegerAttribute("height", this.height, parentSizePair.getY());
        }
        sizePair = params.getSizePairAttribute("pos", null, parentSizePair);
        if (sizePair != null) {
            this.x = sizePair.getX();
            this.y = sizePair.getY();
        } else {
            this.x = params.getScalableIntegerAttribute("x", this.x, parentSizePair.getX());
            this.y = params.getScalableIntegerAttribute("y", this.y, parentSizePair.getY());
        }
        this.alignment = params.getEnumAttribute("align", Alignment.class, this.alignment);
        this.visible = params.getBooleanAttribute("visible", this.visible);
        this.enabled = params.getBooleanAttribute("enabled", this.enabled);
        this.onHoverId = params.getStringAttribute("onHoverId");
    }

    public static synchronized Pane getFocus() {
        return focus;
    }

    public static void clearFocus() {
        Pane.setFocus(null);
    }

    public void onFocusLost() {
    }

    public void onFocus() {
    }

    public void parseChildren(PaneParams params) {
    }

    public final String getID() {
        return this.id;
    }

    public final void setID(String id) {
        this.id = id;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setPosition(int newX, int newY) {
        this.x = newX;
        this.y = newY;
    }

    public void moveBy(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public boolean isOn() {
        return this.enabled && this.visible;
    }

    public void on() {
        this.setEnabled(true);
        this.setVisible(true);
    }

    public void off() {
        this.setEnabled(false);
        this.setVisible(false);
    }

    public final void setFocus() {
        Pane.setFocus(this);
    }

    public final synchronized boolean isFocus() {
        return focus == this;
    }

    public static synchronized void setFocus(Pane f) {
        if (focus != null) {
            focus.onFocusLost();
        }
        if ((focus = f) != null) {
            focus.onFocus();
        }
    }

    public final void draw(int mx, int my) {
        if (this.visible) {
            this.drawSelf(mx, my);
            if (debugging) {
                boolean isMouseOver = this.isPointInPane(mx, my);
                int color = isMouseOver ? -16711936 : -16776961;
                Render.drawOutlineRect(this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), color);
                if (isMouseOver && !this.id.isEmpty()) {
                    int stringWidth = this.mc.field_71466_p.func_78256_a(this.id);
                    this.mc.field_71466_p.func_78276_b(this.id, this.x + this.getWidth() - stringWidth, this.y + this.getHeight() - this.mc.field_71466_p.field_78288_b, color);
                }
            }
        }
    }

    public void drawSelf(int mx, int my) {
    }

    protected boolean isPointInPane(int mx, int my) {
        return mx >= this.x && mx < this.x + this.width && my >= this.y && my < this.y + this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public final <T extends Pane> T findPaneOfTypeByID(String id, @NotNull Class<T> type) {
        Pane p = this.findPaneByID(id);
        try {
            return (T)((Object)((Pane)((Object)type.cast((Object)p))));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("No pane with id %s and type %s was found.", id, type), e);
        }
    }

    @Nullable
    public Pane findPaneByID(String id) {
        return this.id.equals(id) ? this : null;
    }

    public final View getParent() {
        return this.parent;
    }

    public final Window getWindow() {
        return this.window;
    }

    public void setWindow(Window w) {
        this.window = w;
    }

    public void putInside(View newParent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = newParent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public boolean isClickable() {
        return this.visible && this.enabled;
    }

    public void click(int mx, int my) {
        Pane.setLastClickedPane(this);
        this.handleClick(mx - this.x, my - this.y);
    }

    public void rightClick(int mx, int my) {
        Pane.setLastClickedPane(this);
        this.handleRightClick(mx - this.x, my - this.y);
    }

    private static synchronized void setLastClickedPane(Pane pane) {
        lastClickedPane = pane;
    }

    public void handleClick(int mx, int my) {
    }

    public void handleRightClick(int mx, int my) {
    }

    public boolean canHandleClick(int mx, int my) {
        return this.visible && this.enabled && this.isPointInPane(mx, my);
    }

    public boolean onKeyTyped(char ch, int key) {
        return false;
    }

    public void onUpdate() {
    }

    protected synchronized void scissorsStart() {
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)64);
        GL11.glGetFloat((int)2982, (FloatBuffer)fb);
        int scissorsX = (int)fb.get(12) + this.getX();
        int scissorsY = (int)fb.get(13) + this.getY();
        int h = this.getHeight();
        int w = this.getWidth();
        if (!scissorsInfoStack.isEmpty()) {
            ScissorsInfo parentInfo = scissorsInfoStack.peek();
            int right = scissorsX + w;
            int bottom = scissorsY + h;
            int parentRight = parentInfo.x + parentInfo.width;
            int parentBottom = parentInfo.y + parentInfo.height;
            scissorsX = Math.max(scissorsX, parentInfo.x);
            scissorsY = Math.max(scissorsY, parentInfo.y);
            w = Math.max(0, Math.min(right, parentRight) - scissorsX);
            h = Math.max(0, Math.min(bottom, parentBottom) - scissorsY);
        }
        GL11.glEnable((int)3089);
        ScissorsInfo info = new ScissorsInfo(scissorsX, scissorsY, w, h);
        scissorsInfoStack.push(info);
        int scale = Screen.getScale();
        GL11.glScissor((int)(info.x * scale), (int)(this.mc.field_71440_d - (info.y + info.height) * scale), (int)(info.width * scale), (int)(info.height * scale));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    protected synchronized void scissorsEnd() {
        scissorsInfoStack.pop();
        GL11.glDisable((int)3089);
        if (!scissorsInfoStack.isEmpty()) {
            GL11.glEnable((int)3089);
            ScissorsInfo info = scissorsInfoStack.peek();
            int scale = Screen.getScale();
            GL11.glScissor((int)(info.x * scale), (int)(this.mc.field_71440_d - (info.y + info.height) * scale), (int)(info.width * scale), (int)(info.height * scale));
        }
    }

    public void scrollInput(int wheel) {
    }

    public void handleHover(int mx, int my) {
        if (this.onHover == null) {
            if (!this.onHoverId.isEmpty()) {
                this.onHover = this.window.findPaneByID(this.onHoverId);
            } else {
                return;
            }
        }
        if (!this.isVisible()) {
            if (this.onHover.isVisible()) {
                this.onHover.off();
            }
            return;
        }
        if (this.onHover.isPointInPane(mx, my) && this.onHover.isVisible()) {
            return;
        }
        if (this.isPointInPane(mx, my) && !this.onHover.isVisible()) {
            this.onHover.on();
            return;
        }
        if (!this.isPointInPane(mx, my) && this.onHover.isVisible()) {
            this.onHover.off();
        }
    }

    static {
        debugging = false;
    }

    private static class ScissorsInfo {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        ScissorsInfo(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }
    }
}

