/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util.constant;

import com.minecolonies.api.util.constant.IToolType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public enum ToolType implements IToolType
{
    NONE("", false, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.none", new Object[0])),
    PICKAXE("pickaxe", true, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.pickaxe", new Object[0])),
    SHOVEL("shovel", true, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.shovel", new Object[0])),
    AXE("axe", true, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.axe", new Object[0])),
    HOE("hoe", true, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.hoe", new Object[0])),
    SWORD("weapon", true, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.sword", new Object[0])),
    BOW("bow", false, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.bow", new Object[0])),
    FISHINGROD("rod", false, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.fishingrod", new Object[0])),
    SHEARS("shears", false, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.shears", new Object[0])),
    SHIELD("shield", false, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.shield", new Object[0])),
    HELMET("helmet", false, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.helmet", new Object[0])),
    LEGGINGS("leggings", false, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.leggings", new Object[0])),
    CHESTPLATE("chestplate", false, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.chestplate", new Object[0])),
    BOOTS("boots", false, (ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.tooltype.boots", new Object[0]));

    private static final Map<String, IToolType> tools;
    private final String name;
    private final boolean variableMaterials;
    private final ITextComponent displayName;

    private ToolType(String name, boolean variableMaterials, ITextComponent displayName) {
        this.name = name;
        this.variableMaterials = variableMaterials;
        this.displayName = displayName;
    }

    public static IToolType getToolType(String tool) {
        if (tools.containsKey(tool)) {
            return tools.get(tool);
        }
        return NONE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasVariableMaterials() {
        return this.variableMaterials;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    static {
        tools = new HashMap<String, IToolType>();
        for (ToolType type : ToolType.values()) {
            tools.put(type.getName(), type);
        }
    }
}

