/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTUtils {
    public static Stream<NBTTagCompound> streamCompound(NBTTagList list) {
        return NBTUtils.streamBase(list).filter(b -> b instanceof NBTTagCompound).map(b -> (NBTTagCompound)b);
    }

    public static Stream<NBTBase> streamBase(NBTTagList list) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new TagListIterator(list), 16), false);
    }

    public static Collector<NBTTagCompound, NBTTagList, NBTTagList> toNBTTagList() {
        return new Collector<NBTTagCompound, NBTTagList, NBTTagList>(){

            @Override
            public Supplier<NBTTagList> supplier() {
                return NBTTagList::new;
            }

            @Override
            public BiConsumer<NBTTagList, NBTTagCompound> accumulator() {
                return NBTTagList::func_74742_a;
            }

            @Override
            public BinaryOperator<NBTTagList> combiner() {
                return (list1, list2) -> {
                    NBTTagList result = this.supplier().get();
                    NBTUtils.streamBase(list1).forEach(arg_0 -> ((NBTTagList)result).func_74742_a(arg_0));
                    NBTUtils.streamBase(list2).forEach(arg_0 -> ((NBTTagList)result).func_74742_a(arg_0));
                    return result;
                };
            }

            @Override
            public Function<NBTTagList, NBTTagList> finisher() {
                return nbtTagList -> nbtTagList;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
            }
        };
    }

    private static class TagListIterator
    implements Iterator<NBTBase> {
        private final NBTTagList list;
        private int currentIndex = 0;

        private TagListIterator(NBTTagList list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.list.func_74745_c();
        }

        @Override
        public NBTBase next() {
            return this.list.func_150305_b(this.currentIndex++);
        }
    }
}

