/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.jetbrains.annotations.NotNull;

public class BlockStateUtils {
    private static final Map<String, IProperty> propertyBlockMap = new HashMap<String, IProperty>();

    private BlockStateUtils() {
    }

    public static boolean stateEqualsStateByBlockAndProp(@NotNull IBlockState state1, @NotNull IBlockState state2, @NotNull String propertyName) {
        if (state1.func_177230_c() != state2.func_177230_c()) {
            return false;
        }
        if (BlockStateUtils.stateEqualsStateInPropertyByName(state1, state2, propertyName)) {
            return true;
        }
        return state1 == state2;
    }

    public static boolean stateEqualsStateInPropertyByName(@NotNull IBlockState state1, @NotNull IBlockState state2, @NotNull String propertyName) {
        IProperty propertyOne = BlockStateUtils.getPropertyByNameFromState(state1, propertyName);
        if (propertyOne != null && state2.func_177227_a().contains(propertyOne)) {
            return state1.func_177229_b(propertyOne) == state2.func_177229_b(propertyOne);
        }
        IProperty propertyTwo = BlockStateUtils.getPropertyByNameFromState(state2, propertyName);
        if (propertyOne != null && propertyTwo != null && state1.func_177227_a().contains(propertyOne) && state2.func_177227_a().contains(propertyTwo)) {
            return state1.func_177229_b(propertyOne).toString().equals(state2.func_177229_b(propertyTwo).toString());
        }
        return false;
    }

    public static IProperty getPropertyByNameFromState(@NotNull IBlockState state, @NotNull String name) {
        IProperty property = propertyBlockMap.get(state.func_177230_c().getRegistryName().toString() + ":" + name);
        if (property != null && state.func_177227_a().contains(property)) {
            return property;
        }
        property = BlockStateUtils.getPropertyByName(state.func_177227_a(), name);
        if (property != null) {
            propertyBlockMap.put(state.func_177230_c().getRegistryName().toString() + ":" + name, property);
        }
        return property;
    }

    public static IProperty getPropertyByName(@NotNull Collection<IProperty<?>> properties, @NotNull String name) {
        for (IProperty<?> tProperty : properties) {
            if (!tProperty.func_177701_a().equals(name)) continue;
            return tProperty;
        }
        return null;
    }

    public static boolean stateEqualsStateWithoutProp(@NotNull IBlockState state1, @NotNull IBlockState state2, @NotNull IProperty prop) {
        if (!state1.func_177227_a().contains(prop) || !state2.func_177227_a().contains(prop)) {
            return state1 == state2;
        }
        return state1.func_177226_a(prop, state2.func_177229_b(prop)) == state2;
    }

    public static boolean stateEqualsStateInBlockAndProp(IBlockState state1, IBlockState state2) {
        if (state1 == null || state2 == null) {
            return false;
        }
        if (state1.func_177230_c() != state2.func_177230_c()) {
            return false;
        }
        if (state1.func_177227_a().size() != state2.func_177227_a().size()) {
            return false;
        }
        for (IProperty prop : state1.func_177227_a()) {
            if (!state2.func_177227_a().contains(prop)) {
                return false;
            }
            if (state1.func_177229_b(prop) == state2.func_177229_b(prop)) continue;
            return false;
        }
        return true;
    }
}

