/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class RecipeStorage
implements IRecipeStorage {
    @NotNull
    private final List<ItemStack> input;
    @NotNull
    private final ItemStack primaryOutput;
    private final Block intermediate;
    private final int gridSize;
    private final IToken token;

    public RecipeStorage(IToken token, List<ItemStack> input, int gridSize, ItemStack primaryOutput, Block intermediate) {
        this.input = Collections.unmodifiableList(input);
        this.primaryOutput = primaryOutput;
        this.gridSize = gridSize;
        this.intermediate = intermediate;
        this.token = token;
    }

    @Override
    public List<ItemStack> getInput() {
        return new ArrayList<ItemStack>(this.input);
    }

    @Override
    public List<ItemStorage> getCleanedInput() {
        ArrayList<ItemStorage> items = new ArrayList<ItemStorage>();
        for (ItemStack stack : this.input) {
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            ItemStorage storage = new ItemStorage(stack);
            if (items.contains(storage)) {
                int index = items.indexOf(storage);
                ItemStorage tempStorage = (ItemStorage)items.remove(index);
                tempStorage.setAmount(tempStorage.getAmount() + storage.getAmount());
                storage = tempStorage;
            }
            items.add(storage);
        }
        return items;
    }

    @Override
    public ItemStack getPrimaryOutput() {
        return this.primaryOutput;
    }

    @Override
    public int getGridSize() {
        return this.gridSize;
    }

    @Override
    public Block getIntermediate() {
        return this.intermediate;
    }

    @Override
    public boolean canFullFillRecipe(IItemHandler ... inventories) {
        List<ItemStorage> items = this.getCleanedInput();
        for (ItemStorage stack : items) {
            int amountNeeded = stack.getAmount();
            boolean hasStack = false;
            for (IItemHandler handler : inventories) {
                hasStack = InventoryUtils.hasItemInItemHandler(handler, itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77969_a(stack.getItemStack()));
                if (!hasStack) continue;
                int count = InventoryUtils.getItemCountInItemHandler(handler, itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77969_a(stack.getItemStack()));
                if (count >= amountNeeded) break;
                hasStack = false;
                amountNeeded -= count;
            }
            if (hasStack) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecipeStorage)) {
            return false;
        }
        RecipeStorage that = (RecipeStorage)o;
        if (this.gridSize != that.gridSize || this.input.size() != that.input.size() || !this.primaryOutput.func_185136_b(that.primaryOutput)) {
            return false;
        }
        for (int i = 0; i < this.input.size(); ++i) {
            if (that.input.get(i).func_77969_a(this.input.get(i))) continue;
            return false;
        }
        return this.intermediate == null ? that.intermediate == null : this.intermediate.equals(that.intermediate);
    }

    public int hashCode() {
        int result = this.input.hashCode();
        result = 31 * result + this.primaryOutput.hashCode();
        result = 31 * result + (this.intermediate != null ? this.intermediate.hashCode() : 0);
        result = 31 * result + this.gridSize;
        return result;
    }

    private boolean checkForFreeSpace(List<IItemHandler> handlers) {
        ArrayList<ItemStack> secondaryStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.input) {
            ItemStack container = stack.func_77973_b().getContainerItem(stack);
            if (ItemStackUtils.isEmpty(container).booleanValue()) continue;
            secondaryStacks.add(container);
        }
        if (secondaryStacks.size() > this.getInput().size()) {
            int freeSpace = 0;
            for (IItemHandler handler : handlers) {
                freeSpace += handler.getSlots() - InventoryUtils.getAmountOfStacksInItemHandler(handler);
            }
            if (freeSpace < secondaryStacks.size() - this.getInput().size()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean fullfillRecipe(List<IItemHandler> handlers) {
        if (!this.checkForFreeSpace(handlers) || !this.canFullFillRecipe(handlers.toArray(new IItemHandler[handlers.size()]))) {
            return false;
        }
        for (ItemStack stack : this.input) {
            int amountNeeded = ItemStackUtils.getSize(stack);
            block1: for (IItemHandler handler : handlers) {
                int slotOfStack = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77969_a(stack));
                while (slotOfStack != -1) {
                    int count = ItemStackUtils.getSize(handler.getStackInSlot(slotOfStack));
                    handler.extractItem(slotOfStack, amountNeeded, false);
                    if (count >= amountNeeded) continue block1;
                    amountNeeded -= count;
                }
            }
        }
        this.insertCraftedItems(handlers);
        return true;
    }

    @Override
    public IToken getToken() {
        return this.token;
    }

    private void insertCraftedItems(List<IItemHandler> handlers) {
        for (IItemHandler handler : handlers) {
            if (InventoryUtils.addItemStackToItemHandler(handler, this.getPrimaryOutput().func_77946_l())) break;
        }
        ArrayList<ItemStack> secondaryStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.input) {
            ItemStack container = stack.func_77973_b().getContainerItem(stack);
            if (ItemStackUtils.isEmpty(container).booleanValue()) continue;
            secondaryStacks.add(container);
        }
        for (ItemStack stack : secondaryStacks) {
            for (IItemHandler handler : handlers) {
                if (InventoryUtils.addItemStackToItemHandler(handler, stack.func_77946_l())) break;
            }
        }
    }
}

