/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility.dynamictrees;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.minecolonies.api.compatibility.dynamictrees.DynamicTreeProxy;
import com.minecolonies.api.util.Log;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;

public final class DynamicTreeCompat
extends DynamicTreeProxy {
    private static DynamicTreeCompat instance = new DynamicTreeCompat();
    private static final String DYNAMIC_MODID = "dynamictrees";
    private static final String DYNAMIC_TREE_DAMAGE = "fallingtree";
    private static Map<Integer, FakePlayer> fakePlayers = new HashMap<Integer, FakePlayer>();

    private DynamicTreeCompat() {
    }

    @Override
    @Optional.Method(modid="dynamictrees")
    protected boolean isDynamicTreePresent() {
        return true;
    }

    public static boolean isDynTreePresent() {
        return instance.isDynamicTreePresent();
    }

    @Override
    @Optional.Method(modid="dynamictrees")
    protected boolean checkForDynamicTreeBlock(@NotNull Block block) {
        return block instanceof BlockBranch;
    }

    public static boolean isDynamicTreeBlock(Block block) {
        return instance.checkForDynamicTreeBlock(block);
    }

    @Override
    @Optional.Method(modid="dynamictrees")
    protected boolean checkForDynamicLeavesBlock(Block block) {
        return block instanceof BlockDynamicLeaves;
    }

    public static boolean isDynamicLeavesBlock(Block block) {
        return instance.checkForDynamicLeavesBlock(block);
    }

    @Override
    @Optional.Method(modid="dynamictrees")
    protected NonNullList<ItemStack> getDropsForLeaf(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull IBlockState blockState, @NotNull int fortune, @NotNull Block leaf) {
        if (DynamicTreeCompat.isDynamicLeavesBlock(leaf)) {
            NonNullList list = NonNullList.func_191196_a();
            for (int i = 0; i < 100 && list.isEmpty(); ++i) {
                list.addAll((Collection)((BlockDynamicLeaves)leaf).getDrops(world, pos, blockState, fortune));
            }
            return list;
        }
        return NonNullList.func_191196_a();
    }

    public static NonNullList<ItemStack> getDropsForLeafCompat(IBlockAccess world, BlockPos pos, IBlockState blockState, int fortune, Block leaf) {
        return instance.getDropsForLeaf(world, pos, blockState, fortune, leaf);
    }

    @Override
    @Optional.Method(modid="dynamictrees")
    protected boolean checkForDynamicSapling(@NotNull Item item) {
        return item instanceof Seed;
    }

    public static boolean isDynamicTreeSapling(Item item) {
        return instance.checkForDynamicSapling(item);
    }

    public static boolean isDynamicTreeSapling(ItemStack stack) {
        return instance.checkForDynamicSapling(stack.func_77973_b());
    }

    @Override
    @Optional.Method(modid="dynamictrees")
    protected Runnable getTreeBreakActionCompat(@NotNull World world, @NotNull BlockPos blockToBreak, ItemStack toolToUse, BlockPos workerPos) {
        return () -> {
            IBlockState curBlockState = world.func_180495_p(blockToBreak);
            Block curBlock = curBlockState.func_177230_c();
            if (world.func_73046_m() == null) {
                Log.getLogger().error("Minecolonies:DynamicTreeCompat unexpected null while trying to get World");
                return;
            }
            int dim = world.field_73011_w.getDimension();
            FakePlayer fake = fakePlayers.get(dim);
            if (fake == null) {
                fakePlayers.put(dim, new FakePlayer(world.func_73046_m().func_71218_a(dim), new GameProfile(UUID.randomUUID(), "minecolonies_LumberjackFake")));
                fake = fakePlayers.get(dim);
            }
            if (workerPos != null) {
                fake.func_70107_b((double)workerPos.func_177958_n(), (double)workerPos.func_177956_o(), (double)workerPos.func_177952_p());
            }
            if (toolToUse != null) {
                fake.func_184611_a(EnumHand.MAIN_HAND, toolToUse);
            }
            curBlock.removedByPlayer(curBlockState, world, blockToBreak, (EntityPlayer)fake, true);
        };
    }

    public static Runnable getTreeBreakAction(World world, BlockPos blockToBreak, ItemStack toolToUse, BlockPos workerPos) {
        return instance.getTreeBreakActionCompat(world, blockToBreak, toolToUse, workerPos);
    }

    @Override
    @Optional.Method(modid="dynamictrees")
    protected boolean plantDynamicSaplingCompat(@NotNull World world, @NotNull BlockPos location, @NotNull ItemStack saplingStack) {
        if (saplingStack.func_77973_b() instanceof Seed) {
            return ((Seed)saplingStack.func_77973_b()).getSpecies(saplingStack).plantSapling(world, location);
        }
        return false;
    }

    public static boolean plantDynamicSapling(World world, BlockPos location, ItemStack sapling) {
        return instance.plantDynamicSaplingCompat(world, location, sapling);
    }

    public static String getDynamicTreeDamage() {
        return DYNAMIC_TREE_DAMAGE;
    }

    @Override
    @Optional.Method(modid="dynamictrees")
    protected boolean hasFittingTreeFamilyCompat(@NotNull BlockPos block1, @NotNull BlockPos block2, @NotNull IBlockAccess world) {
        TreeFamily fam1 = DynamicTreeCompat.getFamilyForBlock(block1, world);
        TreeFamily fam2 = DynamicTreeCompat.getFamilyForBlock(block2, world);
        if (fam1 != null && fam2 != null) {
            return fam1 == fam2;
        }
        return false;
    }

    private static TreeFamily getFamilyForBlock(@NotNull BlockPos blockPos, @NotNull IBlockAccess world) {
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (block instanceof BlockBranch) {
            return ((BlockBranch)block).getFamily();
        }
        if (block instanceof BlockDynamicLeaves) {
            return ((BlockDynamicLeaves)block).getFamily(world.func_180495_p(blockPos), world, blockPos);
        }
        return null;
    }

    public static boolean hasFittingTreeFamily(@NotNull BlockPos block1, @NotNull BlockPos block2, @NotNull IBlockAccess world) {
        return instance.hasFittingTreeFamilyCompat(block1, block2, world);
    }
}

