/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class CompatibilityManager
implements ICompatibilityManager {
    private final BiMap<IBlockState, ItemStorage> leavesToSaplingMap = HashBiMap.create();
    private final List<ItemStorage> saplings = new ArrayList<ItemStorage>();
    private final List<Block> ores = new ArrayList<Block>();
    private final List<ItemStorage> compostableItems = new ArrayList<ItemStorage>();
    private boolean discoveredAlready = false;

    @Override
    public void discover() {
        this.discoverSaplings();
        for (String string : OreDictionary.getOreNames()) {
            if (!string.contains("ore")) continue;
            this.discoverOres(string);
        }
        Log.getLogger().info("Finished discovering ores");
        this.discoverCompostableItems();
        this.discoveredAlready = true;
    }

    @Override
    public boolean isCompost(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        for (String string : Configurations.gameplay.listOfCompostableItems) {
            if (itemStack.func_77973_b().getRegistryName().toString().equals(string)) {
                return true;
            }
            for (int id : OreDictionary.getOreIDs((ItemStack)itemStack)) {
                if (!OreDictionary.getOreName((int)id).equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IBlockState getLeafForSapling(ItemStack stack) {
        if (this.leavesToSaplingMap.inverse().containsKey((Object)new ItemStorage(stack, false, true))) {
            return (IBlockState)this.leavesToSaplingMap.inverse().get((Object)new ItemStorage(stack, false, true));
        }
        return null;
    }

    @Override
    public ItemStack getSaplingForLeaf(IBlockState block) {
        ItemStack stack = new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_176201_c(block));
        IBlockState tempLeaf = BlockLeaves.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77960_j());
        if (this.leavesToSaplingMap.containsKey((Object)tempLeaf)) {
            return ((ItemStorage)this.leavesToSaplingMap.get((Object)tempLeaf)).getItemStack();
        }
        return null;
    }

    @Override
    public List<ItemStorage> getCopyOfSaplings() {
        return new ArrayList<ItemStorage>(this.saplings);
    }

    @Override
    public List<ItemStorage> getCopyOfCompostableItems() {
        return ImmutableList.copyOf(this.compostableItems);
    }

    @Override
    public boolean isOre(IBlockState block) {
        if (block.func_177230_c() instanceof BlockOre || block.func_177230_c() instanceof BlockRedstoneOre) {
            return true;
        }
        return this.ores.contains(block.func_177230_c());
    }

    @Override
    public boolean isOre(@NotNull ItemStack stack) {
        int[] ids;
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)id).contains("ore")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList saplingsLeavesTagList = this.leavesToSaplingMap.entrySet().stream().map(entry -> CompatibilityManager.writeLeafSaplingEntryToNBT((IBlockState)entry.getKey(), (ItemStorage)entry.getValue())).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a("tagSapLeaves", (NBTBase)saplingsLeavesTagList);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTUtils.streamCompound(compound.func_150295_c("tagSapLeaves", 10)).map(CompatibilityManager::readLeafSaplingEntryFromNBT).filter(key -> !this.leavesToSaplingMap.containsKey(key.func_76341_a()) && !this.leavesToSaplingMap.containsValue(key.func_76340_b())).forEach(key -> {
            ItemStorage cfr_ignored_0 = (ItemStorage)this.leavesToSaplingMap.put(key.func_76341_a(), key.func_76340_b());
        });
    }

    @Override
    public void connectLeafToSapling(IBlockState leaf, ItemStack stack) {
        ItemStack tempStack = new ItemStack(leaf.func_177230_c(), 1, leaf.func_177230_c().func_176201_c(leaf));
        IBlockState tempLeaf = BlockLeaves.func_149634_a((Item)tempStack.func_77973_b()).func_176203_a(tempStack.func_77960_j());
        if (!this.leavesToSaplingMap.containsKey((Object)tempLeaf) && !this.leavesToSaplingMap.containsValue((Object)new ItemStorage(stack, false, true))) {
            this.leavesToSaplingMap.put((Object)tempLeaf, (Object)new ItemStorage(stack, false, true));
        }
    }

    @Override
    public boolean isDiscoveredAlready() {
        return this.discoveredAlready;
    }

    private void discoverOres(String string) {
        for (ItemStack ore : OreDictionary.getOres((String)string)) {
            for (CreativeTabs tabs : CreativeTabs.field_78032_a) {
                NonNullList list = NonNullList.func_191196_a();
                ore.func_77973_b().func_150895_a(tabs, list);
                for (ItemStack stack : list) {
                    Block block;
                    if (ItemStackUtils.isEmpty(stack).booleanValue() || !(stack.func_77973_b() instanceof ItemBlock) || this.ores.contains(block = ((ItemBlock)stack.func_77973_b()).func_179223_d())) continue;
                    this.ores.add(block);
                }
            }
        }
        for (String oreString : Configurations.gameplay.extraOres) {
            Block block = Block.func_149684_b((String)oreString);
            if (block == null || this.ores.contains(block)) continue;
            this.ores.add(block);
        }
    }

    private void discoverSaplings() {
        for (ItemStack saps : OreDictionary.getOres((String)"treeSapling")) {
            if (saps.func_77981_g()) {
                for (CreativeTabs tabs : CreativeTabs.field_78032_a) {
                    NonNullList list = NonNullList.func_191196_a();
                    saps.func_77973_b().func_150895_a(tabs, list);
                    for (ItemStack stack : list) {
                        if (ItemStackUtils.isEmpty(stack).booleanValue() || this.leavesToSaplingMap.containsValue((Object)new ItemStorage(stack, false, true)) || this.saplings.contains(new ItemStorage(stack, false, true))) continue;
                        this.saplings.add(new ItemStorage(stack, false, true));
                    }
                }
                continue;
            }
            if (!Compatibility.isDynamicTreeSapling(saps) || ItemStackUtils.isEmpty(saps).booleanValue() || this.leavesToSaplingMap.containsValue((Object)new ItemStorage(saps, false, true)) || this.saplings.contains(new ItemStorage(saps, false, true))) continue;
            this.saplings.add(new ItemStorage(saps, false, true));
        }
        Log.getLogger().info("Finished discovering saplings");
    }

    private void discoverCompostableItems() {
        if (this.compostableItems.isEmpty()) {
            this.compostableItems.addAll((Collection<ItemStorage>)ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(Item.field_150901_e.iterator(), 16), false).flatMap(item -> {
                NonNullList stacks = NonNullList.func_191196_a();
                try {
                    item.func_150895_a(CreativeTabs.field_78027_g, stacks);
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Failed to get sub items from: " + item.getRegistryName());
                }
                return stacks.stream().filter(this::isCompost);
            }).map(ItemStorage::new).collect(Collectors.toList())));
        }
        Log.getLogger().info("Finished discovering compostables");
    }

    private static NBTTagCompound writeLeafSaplingEntryToNBT(IBlockState state, ItemStorage storage) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)compound, (IBlockState)state);
        storage.getItemStack().func_77955_b(compound);
        return compound;
    }

    private static Tuple<IBlockState, ItemStorage> readLeafSaplingEntryFromNBT(NBTTagCompound compound) {
        return new Tuple((Object)NBTUtil.func_190008_d((NBTTagCompound)compound), (Object)new ItemStorage(new ItemStack(compound), false, true));
    }
}

