/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class StackList
implements IDeliverable {
    private static final String NBT_STACK_LIST = "StackList";
    private static final String NBT_MATCHMETA = "MatchMeta";
    private static final String NBT_MATCHNBT = "MatchNBT";
    private static final String NBT_MATCHOREDIC = "MatchOreDic";
    private static final String NBT_RESULT = "Result";
    @NotNull
    private final List<ItemStack> theStacks = new ArrayList<ItemStack>();
    @NotNull
    private boolean matchMeta = false;
    @NotNull
    private boolean matchNBT = false;
    @NotNull
    private boolean matchOreDic = false;
    @NotNull
    private ItemStack result = ItemStackUtils.EMPTY;

    public StackList(@NotNull List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            ItemStack tempStack = stack.func_77946_l();
            tempStack.func_190920_e(Math.min(tempStack.func_190916_E(), tempStack.func_77976_d()));
            this.theStacks.add(tempStack);
        }
        if (stacks.isEmpty()) {
            throw new IllegalArgumentException("Cannot deliver Empty List.");
        }
        this.setMatchMeta(true).setMatchNBT(true);
    }

    public StackList(@NotNull List<ItemStack> stacks, boolean matchMeta, boolean matchNBT, boolean matchOreDic, @NotNull ItemStack result) {
        for (ItemStack stack : stacks) {
            ItemStack tempStack = stack.func_77946_l();
            tempStack.func_190920_e(Math.min(tempStack.func_190916_E(), tempStack.func_77976_d()));
            this.theStacks.add(tempStack);
        }
        this.matchMeta = matchMeta;
        this.matchNBT = matchNBT;
        this.matchOreDic = matchOreDic;
        this.result = result;
    }

    public StackList setMatchNBT(boolean match) {
        this.matchNBT = match;
        return this;
    }

    public StackList setMatchMeta(boolean match) {
        this.matchMeta = match;
        return this;
    }

    public static NBTTagCompound serialize(IFactoryController controller, StackList input) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList neededResTagList = new NBTTagList();
        for (ItemStack resource : input.theStacks) {
            neededResTagList.func_74742_a((NBTBase)resource.serializeNBT());
        }
        compound.func_74782_a(NBT_STACK_LIST, (NBTBase)neededResTagList);
        compound.func_74757_a(NBT_MATCHMETA, input.matchMeta);
        compound.func_74757_a(NBT_MATCHNBT, input.matchNBT);
        compound.func_74757_a(NBT_MATCHOREDIC, input.matchOreDic);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            compound.func_74782_a(NBT_RESULT, (NBTBase)input.result.serializeNBT());
        }
        return compound;
    }

    public static StackList deserialize(IFactoryController controller, NBTTagCompound compound) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        NBTTagList neededResTagList = compound.func_150295_c(NBT_STACK_LIST, 10);
        for (int i = 0; i < neededResTagList.func_74745_c(); ++i) {
            NBTTagCompound neededRes = neededResTagList.func_150305_b(i);
            stacks.add(new ItemStack(neededRes));
        }
        boolean matchMeta = compound.func_74767_n(NBT_MATCHMETA);
        boolean matchNBT = compound.func_74767_n(NBT_MATCHNBT);
        boolean matchOreDic = compound.func_74767_n(NBT_MATCHOREDIC);
        ItemStack result = compound.func_74764_b(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_RESULT)) : ItemStackUtils.EMPTY;
        return new StackList(stacks, matchMeta, matchNBT, matchOreDic, result);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        if (this.matchOreDic) {
            for (ItemStack tempStack : this.theStacks) {
                if (!OreDictionary.itemMatches((ItemStack)tempStack, (ItemStack)stack, (boolean)this.matchMeta)) continue;
                return true;
            }
        }
        return ItemStackUtils.compareItemStackListIgnoreStackSize(this.getStacks(), stack, this.matchMeta, this.matchNBT);
    }

    @Override
    public int getCount() {
        return this.theStacks.isEmpty() ? 0 : this.theStacks.get(0).func_190916_E();
    }

    @NotNull
    public List<ItemStack> getStacks() {
        return this.theStacks;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    public StackList setMatchOreDic(boolean match) {
        this.matchOreDic = match;
        return this;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StackList)) {
            return false;
        }
        StackList stack1 = (StackList)o;
        if (this.matchMeta != stack1.matchMeta) {
            return false;
        }
        if (this.matchNBT != stack1.matchNBT) {
            return false;
        }
        if (this.matchOreDic != stack1.matchOreDic) {
            return false;
        }
        for (ItemStack tempStack : stack1.getStacks()) {
            if (ItemStackUtils.compareItemStackListIgnoreStackSize(this.getStacks(), tempStack)) continue;
            return false;
        }
        for (ItemStack tempStack : this.getStacks()) {
            if (ItemStackUtils.compareItemStackListIgnoreStackSize(stack1.getStacks(), tempStack)) continue;
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), stack1.getResult());
    }

    public int hashCode() {
        int result1 = this.getStacks().hashCode();
        result1 = 31 * result1 + (this.matchMeta ? 1 : 0);
        result1 = 31 * result1 + (this.matchNBT ? 1 : 0);
        result1 = 31 * result1 + (this.matchOreDic ? 1 : 0);
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }
}

