/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class Delivery
implements IRequestable {
    private static final String NBT_START = "Start";
    private static final String NBT_TARGET = "Target";
    private static final String NBT_STACK = "Stack";
    @NotNull
    private final ILocation start;
    @NotNull
    private final ILocation target;
    @NotNull
    private final ItemStack stack;

    public Delivery(@NotNull ILocation start, @NotNull ILocation target, @NotNull ItemStack stack) {
        this.start = start;
        this.target = target;
        this.stack = stack;
    }

    @NotNull
    public static NBTTagCompound serialize(@NotNull IFactoryController controller, Delivery delivery) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(NBT_START, (NBTBase)controller.serialize(delivery.getStart()));
        compound.func_74782_a(NBT_TARGET, (NBTBase)controller.serialize(delivery.getTarget()));
        compound.func_74782_a(NBT_STACK, (NBTBase)delivery.getStack().serializeNBT());
        return compound;
    }

    @NotNull
    public ILocation getStart() {
        return this.start;
    }

    @NotNull
    public ILocation getTarget() {
        return this.target;
    }

    @NotNull
    public ItemStack getStack() {
        return this.stack;
    }

    @NotNull
    public static Delivery deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound compound) {
        ILocation start = (ILocation)controller.deserialize(compound.func_74775_l(NBT_START));
        ILocation target = (ILocation)controller.deserialize(compound.func_74775_l(NBT_TARGET));
        ItemStack stack = ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_STACK));
        return new Delivery(start, target, stack);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Delivery)) {
            return false;
        }
        Delivery delivery = (Delivery)o;
        if (!this.getStart().equals(delivery.getStart())) {
            return false;
        }
        if (!this.getTarget().equals(delivery.getTarget())) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getStack(), delivery.getStack());
    }

    public int hashCode() {
        int result = this.getStart().hashCode();
        result = 31 * result + this.getTarget().hashCode();
        result = 31 * result + this.getStack().hashCode();
        return result;
    }
}

