/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public interface IColonyTagCapability {
    @NotNull
    public IColonyTagCapability removeColony(int var1);

    @NotNull
    public IColonyTagCapability setOwningColony(int var1);

    public int getOwningColony();

    @NotNull
    public List<Integer> getAllCloseColonies();

    @NotNull
    public IColonyTagCapability addColony(int var1);

    public void reset();

    public static class Storage
    implements Capability.IStorage<IColonyTagCapability> {
        public NBTBase writeNBT(@NotNull Capability<IColonyTagCapability> capability, @NotNull IColonyTagCapability instance, @Nullable EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("id", instance.getOwningColony());
            compound.func_74782_a("colonies", (NBTBase)instance.getAllCloseColonies().stream().map(Storage::write).collect(NBTUtils.toNBTTagList()));
            return compound;
        }

        public void readNBT(@NotNull Capability<IColonyTagCapability> capability, @NotNull IColonyTagCapability instance, @Nullable EnumFacing side, @NotNull NBTBase nbt) {
            if (nbt instanceof NBTTagCompound && ((NBTTagCompound)nbt).func_74764_b("id")) {
                instance.setOwningColony(((NBTTagCompound)nbt).func_74762_e("id"));
                NBTUtils.streamCompound(((NBTTagCompound)nbt).func_150295_c("colonies", 10)).map(compound -> compound.func_74762_e("id")).forEach(instance::addColony);
            }
        }

        private static NBTTagCompound write(int id) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("id", id);
            return compound;
        }
    }

    public static class Impl
    implements IColonyTagCapability {
        private final List<Integer> colonies = new ArrayList<Integer>();
        private int owningColony = 0;

        @Override
        @NotNull
        public IColonyTagCapability addColony(int id) {
            if (!this.colonies.contains(id)) {
                this.colonies.add(id);
            }
            return this;
        }

        @Override
        public void reset() {
            this.colonies.clear();
            this.owningColony = 0;
        }

        @Override
        @NotNull
        public IColonyTagCapability removeColony(int id) {
            for (int i = 0; i < this.colonies.size(); ++i) {
                if (this.colonies.get(i) != id) continue;
                this.colonies.remove(i);
            }
            if (this.owningColony == id) {
                this.owningColony = 0;
            }
            return this;
        }

        @Override
        @NotNull
        public IColonyTagCapability setOwningColony(int id) {
            this.owningColony = id;
            return this;
        }

        @Override
        public int getOwningColony() {
            return this.owningColony;
        }

        @Override
        @NotNull
        public List<Integer> getAllCloseColonies() {
            return new ArrayList<Integer>(this.colonies);
        }
    }
}

