/*
 * Decompiled with CFR 0.152.
 */
package lumien.custommainmenu.gui;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.List;
import lumien.custommainmenu.configuration.elements.Label;
import lumien.custommainmenu.gui.GuiCustom;
import lumien.custommainmenu.lib.ANCHOR;
import lumien.custommainmenu.lib.StringReplacer;
import lumien.custommainmenu.lib.texts.TextString;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;

public class GuiCustomLabel
extends Gui {
    Label text;
    int posX;
    int posY;
    FontRenderer fontRendererObj;
    int width;
    int height;
    GuiCustom parent;
    static final String TIME_FORMAT = "HH:mm";
    static final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
    static Field mcpversionField;
    public static String mcpversion;
    boolean hovered;

    public GuiCustomLabel(GuiCustom customGUI, Label text, int posX, int posY) {
        this.text = text;
        this.posX = posX;
        this.posY = posY;
        this.parent = customGUI;
        this.fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        this.hovered = false;
        this.width = this.fontRendererObj.func_78256_a(text.text.get());
        this.height = this.fontRendererObj.field_78288_b;
        if (text.name.equals("fml")) {
            String string = "";
            List brandings = FMLCommonHandler.instance().getBrandings(true);
            for (int i = 0; i < brandings.size(); ++i) {
                String brd = (String)brandings.get(i);
                if (Strings.isNullOrEmpty((String)brd)) continue;
                string = string + brd + (i < brandings.size() - 1 ? "\n" : "");
            }
            this.text.text = this.text.hoverText = new TextString(string);
        }
    }

    public void drawLabel(Minecraft mc, int mouseX, int mouseY) {
        if (this.text.fontSize != 1.0f) {
            GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
            GlStateManager.func_179152_a((float)this.text.fontSize, (float)this.text.fontSize, (float)1.0f);
            GlStateManager.func_179109_b((float)(-this.posX), (float)(-this.posY), (float)0.0f);
        }
        String toDraw = this.hovered ? this.text.hoverText.get() : this.text.text.get();
        boolean newHovered = this.isMouseAboveLabel(mouseX, mouseY);
        if (newHovered && !this.hovered && this.text.hoverSound != null) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation(this.text.hoverSound), SoundCategory.MASTER, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f));
        }
        this.hovered = newHovered;
        if (toDraw.contains("\n")) {
            String[] lines;
            int modY = 0;
            for (String line : lines = toDraw.split("\n")) {
                int offsetX;
                String lineDraw = StringReplacer.replacePlaceholders(line);
                int textWidth = this.fontRendererObj.func_78256_a(lineDraw);
                int n = this.text.anchor == ANCHOR.START ? 0 : (offsetX = this.text.anchor == ANCHOR.MIDDLE ? -(textWidth / 2) : -textWidth);
                if (this.hovered) {
                    this.func_73731_b(this.fontRendererObj, lineDraw, this.posX + offsetX, this.posY + modY, this.text.hoverColor);
                } else {
                    this.func_73731_b(this.fontRendererObj, lineDraw, this.posX + offsetX, this.posY + modY, this.text.color);
                }
                modY += this.fontRendererObj.field_78288_b;
            }
        } else {
            int offsetX;
            toDraw = StringReplacer.replacePlaceholders(toDraw);
            int textWidth = this.fontRendererObj.func_78256_a(toDraw);
            int n = this.text.anchor == ANCHOR.START ? 0 : (offsetX = this.text.anchor == ANCHOR.MIDDLE ? -(textWidth / 2) : -textWidth);
            if (this.hovered) {
                this.func_73731_b(this.fontRendererObj, toDraw, this.posX + offsetX, this.posY, this.text.hoverColor);
            } else {
                this.func_73731_b(this.fontRendererObj, toDraw, this.posX + offsetX, this.posY, this.text.color);
            }
        }
        if (this.text.fontSize != 1.0f) {
            GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
            GlStateManager.func_179152_a((float)(1.0f / this.text.fontSize), (float)(1.0f / this.text.fontSize), (float)1.0f);
            GlStateManager.func_179109_b((float)(-this.posX), (float)(-this.posY), (float)0.0f);
        }
    }

    private boolean isMouseAboveLabel(int mouseX, int mouseY) {
        String stringText = this.text.text.get();
        if (stringText.contains("\n")) {
            String[] lines = stringText.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                int width = this.fontRendererObj.func_78256_a(lines[i]);
                int height = this.fontRendererObj.field_78288_b;
                if (mouseX < this.posX || mouseY < this.posY + this.fontRendererObj.field_78288_b * i || mouseX >= this.posX + width || mouseY >= this.posY + this.fontRendererObj.field_78288_b * i + height) continue;
                return true;
            }
            return false;
        }
        int width = this.fontRendererObj.func_78256_a(stringText);
        int height = this.fontRendererObj.field_78288_b;
        return mouseX >= this.posX && mouseY >= this.posY && mouseX < this.posX + width && mouseY < this.posY + height;
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = this.isMouseAboveLabel(mouseX, mouseY);
        if (flag && this.text.action != null) {
            if (this.text.pressSound != null) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation(this.text.pressSound), SoundCategory.MASTER, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f));
            } else {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation("ui.button.click"), SoundCategory.MASTER, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f));
            }
            this.text.action.perform(this.text, this.parent);
        }
    }

    static {
        try {
            mcpversionField = Loader.class.getDeclaredField("mcpversion");
            mcpversionField.setAccessible(true);
            mcpversion = (String)mcpversionField.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

