/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CapabilityHelper {
    public static boolean isFluidContainer(ItemStack stack, EnumFacing facing) {
        return !stack.func_190926_b() && (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing) || stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing));
    }

    @Nullable
    public static IFluidHandler getFluidHandler(ItemStack stack, EnumFacing facing) {
        IFluidHandler handler = null;
        if (CapabilityHelper.isFluidContainer(stack, facing) && (handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing)) == null) {
            handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
        }
        return handler;
    }

    public static boolean isFluidContainer(TileEntity tile, EnumFacing facing) {
        return tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
    }

    @Nullable
    public static IFluidHandler getFluidHandler(TileEntity tile, EnumFacing facing) {
        return CapabilityHelper.isFluidContainer(tile, facing) ? (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing) : null;
    }

    public static boolean isItemContainer(TileEntity tile, EnumFacing facing) {
        return tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
    }

    @Nullable
    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing facing) {
        return CapabilityHelper.isItemContainer(tile, facing) ? (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing) : null;
    }
}

