/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.google.common.base.Function;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCustomDrawers
extends ItemDrawers {
    private Function nameFunction;

    public ItemCustomDrawers(Block block) {
        this(block, new Function(){

            @Nullable
            public Object apply(Object input) {
                ItemStack stack = (ItemStack)input;
                return EnumBasicDrawer.byMetadata(stack.func_77960_j()).getUnlocalizedName();
            }
        });
    }

    protected ItemCustomDrawers(Block block, Function function) {
        super(block);
        this.func_77627_a(true);
        this.nameFunction = function;
    }

    public String func_77667_c(@Nonnull ItemStack stack) {
        return super.func_77658_a() + "." + this.nameFunction.apply((Object)stack);
    }

    @Override
    public boolean placeBlockAt(@Nonnull ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            return false;
        }
        TileEntityDrawers tile = (TileEntityDrawers)world.func_175625_s(pos);
        if (tile != null && stack.func_77942_o() && !stack.func_77978_p().func_74764_b("tile")) {
            if (stack.func_77978_p().func_74764_b("MatS")) {
                tile.material().setSide(new ItemStack(stack.func_77978_p().func_74775_l("MatS")));
            }
            if (stack.func_77978_p().func_74764_b("MatT")) {
                tile.material().setTrim(new ItemStack(stack.func_77978_p().func_74775_l("MatT")));
            }
            if (stack.func_77978_p().func_74764_b("MatF")) {
                tile.material().setFront(new ItemStack(stack.func_77978_p().func_74775_l("MatF")));
            }
        }
        return true;
    }

    @Nonnull
    public static ItemStack makeItemStack(IBlockState blockState, int count, @Nonnull ItemStack matSide, @Nonnull ItemStack matTrim, @Nonnull ItemStack matFront) {
        Block block = blockState.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        if (!(item instanceof ItemCustomDrawers)) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (!matSide.func_190926_b()) {
            tag.func_74782_a("MatS", (NBTBase)ItemCustomDrawers.getMaterialTag(matSide));
        }
        if (!matTrim.func_190926_b()) {
            tag.func_74782_a("MatT", (NBTBase)ItemCustomDrawers.getMaterialTag(matTrim));
        }
        if (!matFront.func_190926_b()) {
            tag.func_74782_a("MatF", (NBTBase)ItemCustomDrawers.getMaterialTag(matFront));
        }
        ItemStack stack = new ItemStack(item, count, block.func_176201_c(blockState));
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    private static NBTTagCompound getMaterialTag(@Nonnull ItemStack mat) {
        mat = mat.func_77946_l();
        mat.func_190920_e(1);
        NBTTagCompound itag = new NBTTagCompound();
        mat.func_77955_b(itag);
        return itag;
    }
}

