/*
 * Decompiled with CFR 0.152.
 */
package sophisticated_wolves.village;

import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import sophisticated_wolves.api.EnumWolfSpecies;
import sophisticated_wolves.entity.EntitySophisticatedWolf;
import sophisticated_wolves.item.pet_carrier.CatPetCarrier;
import sophisticated_wolves.item.pet_carrier.ParrotPetCarrier;
import sophisticated_wolves.item.pet_carrier.RabbitPetCarrier;
import sophisticated_wolves.village.VillagersHandler;

public class ComponentVillagePetsSeller
extends StructureVillagePieces.Village {
    private int averageGroundLevel = -1;
    private static final int HEIGHT = 8;
    private static final int X_LENGTH = 14;
    private static final int Z_LENGTH = 8;
    protected static final UUID uuid = UUID.randomUUID();
    protected static final Set<Biome> biomeSetSandy = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
    protected static final IBlockState OAK_DOOR = Blocks.field_180413_ao.func_176223_P();
    protected static final IBlockState COBBLESTONE = Blocks.field_150347_e.func_176223_P();
    protected static final IBlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    protected static final IBlockState PLANKS_OAK = Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.OAK);
    protected static final IBlockState OAK = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
    protected static final IBlockState GLASS_PANE = Blocks.field_150410_aZ.func_176223_P();
    protected static final IBlockState OAK_SLAB = Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockWoodSlab.field_176557_b, (Comparable)BlockPlanks.EnumType.OAK);
    protected static final IBlockState SANDSTONE_SLAB = Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SAND);
    protected static final IBlockState OAK_STAIRS = Blocks.field_150476_ad.func_176223_P();
    protected static final IBlockState STONE_STAIRS = Blocks.field_150446_ar.func_176223_P();
    protected static final IBlockState SANDSTONE_STAIRS = Blocks.field_150372_bz.func_176223_P();
    protected static final IBlockState FENCE = Blocks.field_180407_aO.func_176223_P();
    protected static final IBlockState PLATE = Blocks.field_150452_aw.func_176223_P();

    public ComponentVillagePetsSeller() {
    }

    public ComponentVillagePetsSeller(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox structureBoundingBox, EnumFacing direction) {
        super(startPiece, componentType);
        this.func_186164_a(direction);
        this.field_74887_e = structureBoundingBox;
    }

    public static ComponentVillagePetsSeller buildComponent(StructureVillagePieces.Start startPiece, List list, Random random, int par3, int par4, int par5, EnumFacing facing, int par7) {
        StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)15, (int)8, (int)9, (EnumFacing)facing);
        return ComponentVillagePetsSeller.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureboundingbox) == null ? new ComponentVillagePetsSeller(startPiece, par7, random, structureboundingbox, facing) : null;
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox boundingBox) {
        return this.generateComponent(world, random, boundingBox);
    }

    public boolean generateComponent(World world, Random random, StructureBoundingBox boundingBox) {
        IBlockState stairsRoof;
        IBlockState stairsFloor;
        IBlockState slab;
        IBlockState wallPlanks;
        IBlockState wallLogs;
        IBlockState ground;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, boundingBox);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 8 - 1, 0);
        }
        Biome biome = world.func_180494_b(new BlockPos(this.func_74865_a(0, 0), this.func_74862_a(0), this.func_74873_b(0, 0)));
        this.func_74878_a(world, boundingBox, 0, 1, 0, 14, 8, 8);
        if (biomeSetSandy.contains(biome)) {
            ground = SANDSTONE;
            wallLogs = SANDSTONE;
            wallPlanks = SANDSTONE;
            slab = SANDSTONE_SLAB;
            stairsFloor = SANDSTONE_STAIRS;
            stairsRoof = SANDSTONE_STAIRS;
        } else {
            ground = COBBLESTONE;
            wallLogs = OAK;
            wallPlanks = PLANKS_OAK;
            slab = OAK_SLAB;
            stairsFloor = STONE_STAIRS;
            stairsRoof = OAK_STAIRS;
        }
        stairsFloor = ComponentVillagePetsSeller.getStairs(stairsFloor, this.func_186165_e());
        stairsRoof = ComponentVillagePetsSeller.getStairs(stairsRoof, this.func_186165_e());
        IBlockState stairsRoof_opposite = ComponentVillagePetsSeller.getStairs(stairsRoof, this.func_186165_e().func_176734_d());
        IBlockState stairsRoof_down = stairsRoof_opposite.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
        IBlockState stairsRoof_down_opposite = stairsRoof.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
        this.fillWithBlocks(world, boundingBox, 1, 0, 1, 13, 0, 7, ground);
        this.fillWithBlocks(world, boundingBox, 2, 1, 1, 12, 3, 1, wallPlanks);
        this.fillWithBlocks(world, boundingBox, 2, 1, 7, 12, 3, 7, wallPlanks);
        this.fillWithBlocks(world, boundingBox, 1, 1, 2, 1, 3, 6, wallPlanks);
        this.fillWithBlocks(world, boundingBox, 13, 1, 2, 13, 3, 6, wallPlanks);
        this.fillWithBlocks(world, boundingBox, 1, 1, 1, 1, 3, 1, wallLogs);
        this.fillWithBlocks(world, boundingBox, 13, 1, 1, 13, 3, 1, wallLogs);
        this.fillWithBlocks(world, boundingBox, 1, 1, 7, 1, 3, 7, wallLogs);
        this.fillWithBlocks(world, boundingBox, 13, 1, 7, 13, 3, 7, wallLogs);
        this.fillWithBlocks(world, boundingBox, 4, 2, 1, 5, 2, 1, GLASS_PANE);
        this.fillWithBlocks(world, boundingBox, 9, 2, 1, 10, 2, 1, GLASS_PANE);
        this.fillWithBlocks(world, boundingBox, 4, 2, 7, 5, 2, 7, GLASS_PANE);
        this.fillWithBlocks(world, boundingBox, 9, 2, 7, 10, 2, 7, GLASS_PANE);
        this.fillWithBlocks(world, boundingBox, 6, 0, 0, 8, 0, 0, stairsFloor);
        this.placeDoorCurrentPosition(world, boundingBox, random, 7, 1, 1, EnumFacing.NORTH);
        this.fillWithBlocks(world, boundingBox, 1, 4, 2, 13, 4, 6, wallPlanks);
        this.fillWithBlocks(world, boundingBox, 1, 5, 3, 13, 5, 5, wallPlanks);
        this.fillWithBlocks(world, boundingBox, 1, 6, 4, 13, 6, 4, wallPlanks);
        this.fillWithBlocks(world, boundingBox, 0, 3, 0, 14, 3, 0, stairsRoof);
        this.fillWithBlocks(world, boundingBox, 0, 4, 1, 14, 4, 1, stairsRoof);
        this.fillWithBlocks(world, boundingBox, 0, 5, 2, 14, 5, 2, stairsRoof);
        this.fillWithBlocks(world, boundingBox, 0, 6, 3, 14, 6, 3, stairsRoof);
        this.fillWithBlocks(world, boundingBox, 0, 3, 8, 14, 3, 8, stairsRoof_opposite);
        this.fillWithBlocks(world, boundingBox, 0, 4, 7, 14, 4, 7, stairsRoof_opposite);
        this.fillWithBlocks(world, boundingBox, 0, 5, 6, 14, 5, 6, stairsRoof_opposite);
        this.fillWithBlocks(world, boundingBox, 0, 6, 5, 14, 6, 5, stairsRoof_opposite);
        this.fillWithBlocks(world, boundingBox, 0, 7, 4, 14, 7, 4, slab);
        this.func_175811_a(world, stairsRoof_down, 0, 3, 1, boundingBox);
        this.func_175811_a(world, stairsRoof_down, 0, 4, 2, boundingBox);
        this.func_175811_a(world, stairsRoof_down, 0, 5, 3, boundingBox);
        this.func_175811_a(world, stairsRoof_down, 14, 3, 1, boundingBox);
        this.func_175811_a(world, stairsRoof_down, 14, 4, 2, boundingBox);
        this.func_175811_a(world, stairsRoof_down, 14, 5, 3, boundingBox);
        this.func_175811_a(world, stairsRoof_down_opposite, 0, 3, 7, boundingBox);
        this.func_175811_a(world, stairsRoof_down_opposite, 0, 4, 6, boundingBox);
        this.func_175811_a(world, stairsRoof_down_opposite, 0, 5, 5, boundingBox);
        this.func_175811_a(world, stairsRoof_down_opposite, 14, 3, 7, boundingBox);
        this.func_175811_a(world, stairsRoof_down_opposite, 14, 4, 6, boundingBox);
        this.func_175811_a(world, stairsRoof_down_opposite, 14, 5, 5, boundingBox);
        this.func_175811_a(world, wallPlanks, 0, 6, 4, boundingBox);
        this.func_175811_a(world, wallPlanks, 14, 6, 4, boundingBox);
        this.fillWithBlocks(world, boundingBox, 3, 1, 2, 3, 3, 6, GLASS_PANE);
        this.fillWithBlocks(world, boundingBox, 11, 1, 2, 11, 3, 6, GLASS_PANE);
        this.fillWithBlocks(world, boundingBox, 2, 1, 3, 2, 3, 3, GLASS_PANE);
        this.fillWithBlocks(world, boundingBox, 2, 1, 5, 2, 3, 5, GLASS_PANE);
        this.fillWithBlocks(world, boundingBox, 12, 1, 3, 12, 3, 3, GLASS_PANE);
        this.fillWithBlocks(world, boundingBox, 12, 1, 5, 12, 3, 5, GLASS_PANE);
        this.fillWithBlocks(world, boundingBox, 6, 1, 5, 8, 1, 5, FENCE);
        this.fillWithBlocks(world, boundingBox, 6, 2, 5, 8, 2, 5, PLATE);
        this.func_189926_a(world, this.func_186165_e().func_176734_d(), 2, 2, 0, boundingBox);
        this.func_189926_a(world, this.func_186165_e().func_176734_d(), 6, 2, 0, boundingBox);
        this.func_189926_a(world, this.func_186165_e().func_176734_d(), 8, 2, 0, boundingBox);
        this.func_189926_a(world, this.func_186165_e().func_176734_d(), 12, 2, 0, boundingBox);
        this.func_189926_a(world, this.func_186165_e().func_176734_d(), 6, 2, 6, boundingBox);
        this.func_189926_a(world, this.func_186165_e().func_176734_d(), 8, 2, 6, boundingBox);
        this.func_189926_a(world, this.func_186165_e(), 6, 2, 2, boundingBox);
        this.func_189926_a(world, this.func_186165_e(), 8, 2, 2, boundingBox);
        this.spawnPet(world, random, boundingBox, 2, 1, 2);
        this.spawnPet(world, random, boundingBox, 2, 1, 4);
        this.spawnPet(world, random, boundingBox, 2, 1, 6);
        this.spawnPet(world, random, boundingBox, 12, 1, 2);
        this.spawnPet(world, random, boundingBox, 12, 1, 4);
        this.spawnPet(world, random, boundingBox, 12, 1, 6);
        for (int i = 1; i < 14; ++i) {
            for (int j = 1; j < 8; ++j) {
                this.func_74871_b(world, i, 8, j, boundingBox);
                this.func_175811_a(world, ground, i, -1, j, boundingBox);
            }
        }
        this.func_74893_a(world, boundingBox, 7, 1, 4, 1);
        return true;
    }

    protected void spawnPet(World world, Random random, StructureBoundingBox boundingBox, int x, int y, int z) {
        int zPos;
        int yPos;
        int xPos = this.func_74865_a(x, z);
        if (boundingBox.func_175898_b((Vec3i)new BlockPos(xPos, yPos = this.func_74862_a(y), zPos = this.func_74873_b(x, z)))) {
            EntityLivingBase pet = this.getPet(world, random);
            pet.func_70012_b((double)xPos + 0.5, (double)yPos, (double)zPos + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)pet);
        }
    }

    protected EntityLivingBase getPet(World world, Random random) {
        switch (random.nextInt(6)) {
            case 0: {
                return new EntityChicken(world);
            }
            default: {
                return this.getWolf(world);
            }
            case 2: {
                return this.getSWolf(world, random);
            }
            case 3: {
                return this.getCat(world, random);
            }
            case 4: {
                return this.getRabbit(world, random);
            }
            case 5: 
        }
        return this.getParrot(world, random);
    }

    protected EntityLivingBase getWolf(World world) {
        EntityWolf pet = new EntityWolf(world);
        pet.func_70903_f(true);
        pet.func_184754_b(uuid);
        return pet;
    }

    protected EntityLivingBase getSWolf(World world, Random random) {
        EntitySophisticatedWolf pet = new EntitySophisticatedWolf(world);
        pet.func_70903_f(true);
        pet.func_184754_b(uuid);
        pet.updateSpecies(EnumWolfSpecies.values()[random.nextInt(EnumWolfSpecies.values().length)]);
        return pet;
    }

    protected EntityLivingBase getCat(World world, Random random) {
        EntityOcelot pet = new EntityOcelot(world);
        pet.func_70903_f(true);
        pet.func_184754_b(uuid);
        pet.func_70912_b(random.nextInt(CatPetCarrier.EnumCatType.values().length));
        return pet;
    }

    protected EntityLivingBase getRabbit(World world, Random random) {
        EntityRabbit pet = new EntityRabbit(world);
        pet.func_175529_r(random.nextInt(RabbitPetCarrier.RABBITS_SPECIES.length));
        return pet;
    }

    protected EntityLivingBase getParrot(World world, Random random) {
        EntityParrot pet = new EntityParrot(world);
        pet.func_70903_f(true);
        pet.func_184754_b(uuid);
        pet.func_191997_m(random.nextInt(ParrotPetCarrier.PARROTS_SPECIES.length));
        return pet;
    }

    public static IBlockState getStairs(IBlockState stairs, EnumFacing direction) {
        return stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)direction);
    }

    protected void placeDoorCurrentPosition(World worldIn, StructureBoundingBox boundingBoxIn, Random rand, int x, int y, int z, EnumFacing facing) {
        this.func_175811_a(worldIn, OAK_DOOR.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)facing), x, y, z, boundingBoxIn);
        this.func_175811_a(worldIn, OAK_DOOR.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)facing).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), x, y + 1, z, boundingBoxIn);
    }

    protected void func_175811_a(World world, IBlockState blockState, int x, int y, int z, StructureBoundingBox boundingBox) {
        int zPos;
        int yPos;
        int xPos = this.func_74865_a(x, z);
        BlockPos pos = new BlockPos(xPos, yPos = this.func_74862_a(y), zPos = this.func_74873_b(x, z));
        if (boundingBox.func_175898_b((Vec3i)pos)) {
            world.func_180501_a(pos, blockState, 2);
        }
    }

    protected void fillWithBlocks(World world, StructureBoundingBox boundingBox, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, IBlockState state) {
        super.func_175804_a(world, boundingBox, xMin, yMin, zMin, xMax, yMax, zMax, state, state, false);
    }

    protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
        return VillagersHandler.petsSellerProfession;
    }
}

