/*
 * Decompiled with CFR 0.152.
 */
package sophisticated_wolves.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sophisticated_wolves.entity.EntitySophisticatedWolf;

public class FoodMessageToServer
implements IMessage,
IMessageHandler<FoodMessageToServer, IMessage> {
    private int playerID;
    private int dimensionID;
    private boolean rottenMeatAndBones;
    private boolean rawMeat;
    private boolean rawFish;
    private boolean specialFish;
    private boolean cookedMeat;
    private boolean cookedFish;

    public FoodMessageToServer() {
    }

    public FoodMessageToServer(EntityTameable entity, boolean rottenMeatAndBones, boolean rawMeat, boolean rawFish, boolean specialFish, boolean cookedMeat, boolean cookedFish) {
        this.playerID = entity.func_145782_y();
        this.dimensionID = entity.field_70170_p.field_73011_w.getDimension();
        this.rottenMeatAndBones = rottenMeatAndBones;
        this.rawMeat = rawMeat;
        this.rawFish = rawFish;
        this.specialFish = specialFish;
        this.cookedMeat = cookedMeat;
        this.cookedFish = cookedFish;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerID = buf.readInt();
        this.dimensionID = buf.readInt();
        this.rottenMeatAndBones = buf.readBoolean();
        this.rawMeat = buf.readBoolean();
        this.rawFish = buf.readBoolean();
        this.specialFish = buf.readBoolean();
        this.cookedMeat = buf.readBoolean();
        this.cookedFish = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.playerID);
        buf.writeInt(this.dimensionID);
        buf.writeBoolean(this.rottenMeatAndBones);
        buf.writeBoolean(this.rawMeat);
        buf.writeBoolean(this.rawFish);
        buf.writeBoolean(this.specialFish);
        buf.writeBoolean(this.cookedMeat);
        buf.writeBoolean(this.cookedFish);
    }

    public IMessage onMessage(FoodMessageToServer message, MessageContext ctx) {
        Entity entity;
        WorldServer world;
        if (ctx.side.isServer() && (world = DimensionManager.getWorld((int)message.dimensionID)) != null && (entity = world.func_73045_a(message.playerID)) != null && entity instanceof EntitySophisticatedWolf) {
            ((EntitySophisticatedWolf)entity).updateFood(message.rottenMeatAndBones, message.rawMeat, message.rawFish, message.specialFish, message.cookedMeat, message.cookedFish);
        }
        return null;
    }
}

