/*
 * Decompiled with CFR 0.152.
 */
package sophisticated_wolves.item.pet_carrier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sophisticated_wolves.SophisticatedWolvesMod;
import sophisticated_wolves.api.EnumWolfSpecies;
import sophisticated_wolves.api.pet_carrier.PetCarrier;
import sophisticated_wolves.compatibility.Compatibility;
import sophisticated_wolves.compatibility.CompatibilityWolfArmor;
import sophisticated_wolves.entity.EntitySophisticatedWolf;

public class SophisticatedWolfPetCarrier
extends PetCarrier {
    @Override
    public Class getPetClass() {
        return EntitySophisticatedWolf.class;
    }

    @Override
    public String getPetId() {
        return "SWWolf";
    }

    @Override
    public EntityLiving spawnPet(World world, EntityPlayer player) {
        return new EntitySophisticatedWolf(world);
    }

    @Override
    public List<String> getInfo(NBTTagCompound infoNbt) {
        if (infoNbt.func_74764_b("WolfType")) {
            ArrayList<String> list = new ArrayList<String>(1);
            StringBuilder str = new StringBuilder(SophisticatedWolvesMod.proxy.getLocalizedString("carrier.dog_type")).append(" - ").append(SophisticatedWolvesMod.proxy.getLocalizedString("wolf_type." + EnumWolfSpecies.getSpeciesByNum(infoNbt.func_74762_e("WolfType")).toString().toLowerCase()));
            list.add(str.toString());
            return list;
        }
        return null;
    }

    @Override
    public NBTTagCompound getInfo(EntityLivingBase pet) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("WolfType", ((EntitySophisticatedWolf)pet).getSpecies().ordinal());
        return nbt;
    }

    @Override
    public NBTTagCompound getAdditionalData(EntityLivingBase pet) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (Compatibility.IS_WOLF_ARMOR_INSTALLED) {
            CompatibilityWolfArmor.storeWolfItems((EntityWolf)pet, nbt);
        }
        return nbt;
    }

    @Override
    public void setAdditionalData(EntityLiving pet, NBTTagCompound nbt) {
        if (Compatibility.IS_WOLF_ARMOR_INSTALLED) {
            CompatibilityWolfArmor.getWolfItems((EntityWolf)pet, nbt);
        }
    }

    @Override
    public List<NBTTagCompound> getDefaultPetCarriers() {
        ArrayList<NBTTagCompound> list = new ArrayList<NBTTagCompound>();
        for (EnumWolfSpecies species : EnumWolfSpecies.values()) {
            NBTTagCompound infoNbt = new NBTTagCompound();
            infoNbt.func_74768_a("WolfType", species.ordinal());
            NBTTagCompound entityNbt = new NBTTagCompound();
            entityNbt.func_74768_a("Species", species.ordinal());
            list.add(this.getDefaultPetCarrier(infoNbt, entityNbt));
        }
        return list;
    }
}

