/*
 * Decompiled with CFR 0.152.
 */
package sophisticated_wolves.item.pet_carrier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sophisticated_wolves.SophisticatedWolvesMod;
import sophisticated_wolves.api.pet_carrier.PetCarrier;

public class RabbitPetCarrier
extends PetCarrier {
    public static final int[] RABBITS_SPECIES = new int[]{0, 1, 2, 3, 4, 5, 99};

    @Override
    public Class getPetClass() {
        return EntityRabbit.class;
    }

    @Override
    public String getPetId() {
        return "Rabbit";
    }

    @Override
    public EntityLiving spawnPet(World world, EntityPlayer player) {
        return new EntityRabbit(world);
    }

    @Override
    public List<String> getInfo(NBTTagCompound infoNbt) {
        if (infoNbt.func_74764_b("RabbitType")) {
            ArrayList<String> list = new ArrayList<String>(1);
            StringBuilder str = new StringBuilder(SophisticatedWolvesMod.proxy.getLocalizedString("carrier.rabbit_type")).append(" - ").append(SophisticatedWolvesMod.proxy.getLocalizedString("rabbit_type." + infoNbt.func_74762_e("RabbitType")).toString().toLowerCase());
            list.add(str.toString());
            return list;
        }
        return null;
    }

    @Override
    public NBTTagCompound getInfo(EntityLivingBase pet) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("RabbitType", ((EntityRabbit)pet).func_175531_cl());
        return nbt;
    }

    @Override
    public List<NBTTagCompound> getDefaultPetCarriers() {
        ArrayList<NBTTagCompound> list = new ArrayList<NBTTagCompound>();
        for (int species : RABBITS_SPECIES) {
            NBTTagCompound infoNbt = new NBTTagCompound();
            infoNbt.func_74768_a("RabbitType", species);
            NBTTagCompound entityNbt = new NBTTagCompound();
            entityNbt.func_74768_a("RabbitType", species);
            list.add(this.getDefaultPetCarrier(infoNbt, entityNbt));
        }
        return list;
    }
}

