/*
 * Decompiled with CFR 0.152.
 */
package sophisticated_wolves.item.pet_carrier;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import sophisticated_wolves.api.pet_carrier.IPetCarrierHandler;
import sophisticated_wolves.api.pet_carrier.PetCarrier;
import sophisticated_wolves.entity.EntitySophisticatedWolf;
import sophisticated_wolves.item.pet_carrier.CatPetCarrier;
import sophisticated_wolves.item.pet_carrier.ChickenPetCarrier;
import sophisticated_wolves.item.pet_carrier.ParrotPetCarrier;
import sophisticated_wolves.item.pet_carrier.RabbitPetCarrier;
import sophisticated_wolves.item.pet_carrier.SophisticatedWolfPetCarrier;
import sophisticated_wolves.item.pet_carrier.WolfPetCarrier;

public class PetCarrierHelper
implements IPetCarrierHandler {
    public static final PetCarrierHelper INSTANCE = new PetCarrierHelper();
    public static final Map<String, PetCarrier> PETS_MAP = new LinkedHashMap<String, PetCarrier>();

    private PetCarrierHelper() {
    }

    @Override
    public void addPet(Class petClass, PetCarrier petCarrier) {
        PETS_MAP.put(petClass.getSimpleName(), petCarrier);
    }

    public void addPetCarriers() {
        this.addPet(EntityWolf.class, new WolfPetCarrier());
        this.addPet(EntitySophisticatedWolf.class, new SophisticatedWolfPetCarrier());
        this.addPet(EntityOcelot.class, new CatPetCarrier());
        this.addPet(EntityChicken.class, new ChickenPetCarrier());
        this.addPet(EntityRabbit.class, new RabbitPetCarrier());
        this.addPet(EntityParrot.class, new ParrotPetCarrier());
    }
}

