/*
 * Decompiled with CFR 0.152.
 */
package sophisticated_wolves.item.pet_carrier;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sophisticated_wolves.SWTabs;
import sophisticated_wolves.SophisticatedWolvesMod;
import sophisticated_wolves.api.pet_carrier.PetCarrier;
import sophisticated_wolves.item.pet_carrier.PetCarrierHelper;

public class ItemPetCarrier
extends Item {
    public ItemPetCarrier() {
        this.setRegistryName("sophisticatedwolves", "SWPetCarrier");
        this.func_77655_b("petcarrier");
        this.func_77637_a(SWTabs.tab);
        this.func_77625_d(1);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        EntityTameable pet;
        if (!(entity.field_70170_p.field_72995_K || stack == null || stack.func_77942_o() && stack.func_77978_p().func_74764_b("ClassName") || !(entity instanceof EntityTameable ? (pet = (EntityTameable)entity).func_70909_n() && pet.func_184753_b() != null && pet.func_184753_b().equals(player.func_110124_au()) : PetCarrierHelper.PETS_MAP.containsKey(entity.getClass().getSimpleName())))) {
            return ItemPetCarrier.getPetInfo(stack, player, entity, hand);
        }
        return super.func_111207_a(stack, player, entity, hand);
    }

    private static boolean getPetInfo(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        NBTTagCompound entityNbt = new NBTTagCompound();
        entity.func_189511_e(entityNbt);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("ClassName", entity.getClass().getSimpleName());
        PetCarrier petCarrier = PetCarrierHelper.PETS_MAP.get(entity.getClass().getSimpleName());
        if (petCarrier != null) {
            NBTTagCompound additionalNbt;
            NBTTagCompound infoNbt = petCarrier.getInfo(entity);
            if (infoNbt != null) {
                nbt.func_74782_a("InfoList", (NBTBase)infoNbt);
            }
            if ((additionalNbt = petCarrier.getAdditionalData(entity)) != null) {
                nbt.func_74782_a("AdditionalData", (NBTBase)additionalNbt);
            }
        }
        if (entity.func_145818_k_()) {
            nbt.func_74778_a("CustomName", entity.func_95999_t());
        }
        nbt.func_74782_a("MobData", (NBTBase)entityNbt);
        stack.func_77982_d(nbt);
        player.func_184611_a(hand, stack);
        entity.func_70106_y();
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (stack != null && stack.func_77942_o()) {
            EntityLiving entity;
            PetCarrier petCarrier;
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_74764_b("ClassName") && (petCarrier = PetCarrierHelper.PETS_MAP.get(nbt.func_74779_i("ClassName"))) != null && (entity = petCarrier.spawnPet(world, player)) != null) {
                IBlockState block = world.func_180495_p(pos);
                double d0 = 0.0;
                if (facing == EnumFacing.UP && block instanceof BlockFence) {
                    d0 = 0.5;
                }
                pos = pos.func_177972_a(facing);
                entity.func_180482_a(world.func_175649_E(new BlockPos((Entity)entity)), null);
                entity.func_70037_a(nbt.func_74775_l("MobData"));
                if (nbt.func_74764_b("AdditionalData")) {
                    petCarrier.setAdditionalData(entity, nbt.func_74775_l("AdditionalData"));
                }
                entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                entity.field_70759_as = entity.field_70177_z;
                entity.field_70761_aq = entity.field_70177_z;
                if (nbt.func_74764_b("CustomName")) {
                    entity.func_96094_a(nbt.func_74779_i("CustomName"));
                }
                world.func_72838_d((Entity)entity);
                entity.func_70642_aH();
                if (entity instanceof EntityTameable) {
                    ((EntityTameable)entity).func_184754_b(player.func_110124_au());
                    ((EntityTameable)entity).func_70903_f(true);
                }
                stack.func_77982_d(new NBTTagCompound());
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        PetCarrier petCarrier;
        NBTTagCompound nbt;
        if (stack != null && stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("ClassName") && (petCarrier = PetCarrierHelper.PETS_MAP.get(nbt.func_74779_i("ClassName"))) != null) {
            List<String> tooltipList;
            NBTTagCompound infoNbt;
            StringBuilder str = new StringBuilder(SophisticatedWolvesMod.proxy.getLocalizedString("carrier.pet_type")).append(" - ").append(SophisticatedWolvesMod.proxy.getLocalizedString("entity." + petCarrier.getPetId() + ".name"));
            tooltip.add(str.toString());
            if (nbt.func_74764_b("CustomName")) {
                StringBuilder name = new StringBuilder(SophisticatedWolvesMod.proxy.getLocalizedString("carrier.pet_name")).append(" - ").append(nbt.func_74779_i("CustomName"));
                tooltip.add(name.toString());
            }
            if (nbt.func_74764_b("InfoList") && (infoNbt = nbt.func_74775_l("InfoList")) != null && (tooltipList = petCarrier.getInfo(infoNbt)) != null) {
                for (String tooltipStr : tooltipList) {
                    tooltip.add(tooltipStr);
                }
            }
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1));
            for (Map.Entry<String, PetCarrier> entry : PetCarrierHelper.PETS_MAP.entrySet()) {
                List<NBTTagCompound> nbtList;
                PetCarrier petCarrier;
                if (entry == null || (petCarrier = entry.getValue()) == null || (nbtList = petCarrier.getDefaultPetCarriers()) == null) continue;
                for (NBTTagCompound nbt : nbtList) {
                    ItemStack stack = new ItemStack((Item)this, 1);
                    stack.func_77982_d(nbt);
                    items.add((Object)stack);
                }
            }
        }
    }
}

