/*
 * Decompiled with CFR 0.152.
 */
package sophisticated_wolves.item.pet_carrier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sophisticated_wolves.SophisticatedWolvesMod;
import sophisticated_wolves.api.pet_carrier.PetCarrier;

public class CatPetCarrier
extends PetCarrier {
    @Override
    public Class getPetClass() {
        return EntityOcelot.class;
    }

    @Override
    public String getPetId() {
        return "Ozelot";
    }

    @Override
    public EntityLiving spawnPet(World world, EntityPlayer player) {
        return new EntityOcelot(world);
    }

    @Override
    public List<String> getInfo(NBTTagCompound infoNbt) {
        if (infoNbt.func_74764_b("CatType")) {
            ArrayList<String> list = new ArrayList<String>(1);
            StringBuilder str = new StringBuilder(SophisticatedWolvesMod.proxy.getLocalizedString("carrier.cat_type")).append(" - ").append(SophisticatedWolvesMod.proxy.getLocalizedString("cat_type." + EnumCatType.getSpeciesByNum(infoNbt.func_74762_e("CatType")).toString().toLowerCase()));
            list.add(str.toString());
            return list;
        }
        return null;
    }

    @Override
    public NBTTagCompound getInfo(EntityLivingBase pet) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("CatType", ((EntityOcelot)pet).func_70913_u());
        return nbt;
    }

    @Override
    public List<NBTTagCompound> getDefaultPetCarriers() {
        ArrayList<NBTTagCompound> list = new ArrayList<NBTTagCompound>();
        for (EnumCatType species : EnumCatType.values()) {
            NBTTagCompound infoNbt = new NBTTagCompound();
            infoNbt.func_74768_a("CatType", species.ordinal());
            NBTTagCompound entityNbt = new NBTTagCompound();
            entityNbt.func_74768_a("CatType", species.ordinal());
            list.add(this.getDefaultPetCarrier(infoNbt, entityNbt));
        }
        return list;
    }

    public static enum EnumCatType {
        OCELOT,
        BLACK,
        RED,
        SIAMESE;


        public static EnumCatType getSpeciesByNum(int num) {
            if (num >= 0 && num < EnumCatType.values().length) {
                return EnumCatType.values()[num];
            }
            return OCELOT;
        }
    }
}

