/*
 * Decompiled with CFR 0.152.
 */
package sophisticated_wolves.entity;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBeg;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeForest;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sophisticated_wolves.FoodHelper;
import sophisticated_wolves.SWConfiguration;
import sophisticated_wolves.SWItems;
import sophisticated_wolves.SophisticatedWolvesMod;
import sophisticated_wolves.api.AEntitySophisticatedWolf;
import sophisticated_wolves.api.EnumWolfSpecies;
import sophisticated_wolves.entity.ai.AIFeed;
import sophisticated_wolves.entity.ai.AIFeedFromBowl;
import sophisticated_wolves.entity.ai.EntityAIAttackCancel;
import sophisticated_wolves.entity.ai.EntityAIAvoidCreeper;
import sophisticated_wolves.entity.ai.EntityAIAvoidFire;
import sophisticated_wolves.entity.ai.EntityAIMoveCancel;
import sophisticated_wolves.entity.ai.EntityAINewBeg;
import sophisticated_wolves.entity.ai.EntityAINewFollowOwner;
import sophisticated_wolves.entity.ai.EntityAINewOwnerHurtByTarget;
import sophisticated_wolves.entity.ai.EntityAINewOwnerHurtTarget;
import sophisticated_wolves.entity.ai.EntityAIShake;
import sophisticated_wolves.entity.ai.EntityAITeleportAtDrowning;
import sophisticated_wolves.item.ItemDogTag;
import sophisticated_wolves.item.pet_carrier.ItemPetCarrier;

public class EntitySophisticatedWolf
extends AEntitySophisticatedWolf {
    public static final int DEFAULT_WILD_WOLF_HEALTH = 8;
    public static final int DEFAULT_TAMED_WOLF_HEALTH = 20;
    private static final DataParameter<Integer> WOLF_SPECIES = EntityDataManager.func_187226_a(EntityWolf.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final int POTION_POISON_ID = 19;
    private static final int POTION_WITHER_ID = 20;
    protected boolean rottenMeatAndBones;
    protected boolean rawMeat;
    protected boolean rawFish;
    protected boolean specialFish;
    protected boolean cookedMeat;
    protected boolean cookedFish;
    protected boolean anyFood;
    public boolean puking;
    protected boolean isDrowning = false;
    protected int drownCount = 0;

    public EntitySophisticatedWolf(World world) {
        super(world);
        EntityAIBase task;
        boolean removeTask;
        Iterator taskIterator = this.field_70714_bg.field_75782_a.iterator();
        while (taskIterator.hasNext()) {
            removeTask = false;
            task = ((EntityAITasks.EntityAITaskEntry)taskIterator.next()).field_75733_a;
            if (task instanceof EntityAISit) {
                removeTask = true;
            } else if (task instanceof EntityAILeapAtTarget) {
                removeTask = true;
            } else if (task instanceof EntityAIAttackMelee) {
                removeTask = true;
            } else if (task instanceof EntityAIFollowOwner) {
                removeTask = true;
            } else if (task instanceof EntityAIMate) {
                removeTask = true;
            } else if (task instanceof EntityAIWander) {
                removeTask = true;
            } else if (task instanceof EntityAIBeg) {
                removeTask = true;
            } else if (task instanceof EntityAIWatchClosest) {
                removeTask = true;
            } else if (task instanceof EntityAILookIdle) {
                removeTask = true;
            }
            if (!removeTask) continue;
            taskIterator.remove();
        }
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidCreeper((EntityCreature)this, 8, 6, 3, 1.0, 1.4));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIShake(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIAttackCancel((EntityTameable)this));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(20, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(22, (EntityAIBase)new EntityAIMoveCancel((EntityTameable)this, 6.0f));
        this.field_70714_bg.func_75776_a(25, (EntityAIBase)new EntityAINewFollowOwner((EntityTameable)this, 1.0, 6.0f, 2.0f));
        this.field_70714_bg.func_75776_a(27, (EntityAIBase)new EntityAIAvoidFire((EntityCreature)this, 1.0, 1.4));
        this.field_70714_bg.func_75776_a(28, (EntityAIBase)new EntityAITeleportAtDrowning((EntityTameable)this));
        this.field_70714_bg.func_75776_a(30, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(31, (EntityAIBase)new AIFeedFromBowl((EntityTameable)this));
        this.field_70714_bg.func_75776_a(32, (EntityAIBase)new AIFeed(this));
        this.field_70714_bg.func_75776_a(40, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(35, (EntityAIBase)new EntityAINewBeg(this, 8.0f));
        this.field_70714_bg.func_75776_a(45, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(50, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        taskIterator = this.field_70715_bh.field_75782_a.iterator();
        while (taskIterator.hasNext()) {
            removeTask = false;
            task = ((EntityAITasks.EntityAITaskEntry)taskIterator.next()).field_75733_a;
            if (task instanceof EntityAIOwnerHurtByTarget) {
                removeTask = true;
            } else if (task instanceof EntityAIOwnerHurtTarget) {
                removeTask = true;
            } else if (task instanceof EntityAITargetNonTamed && !SWConfiguration.attackAnimals) {
                removeTask = true;
            } else if (task instanceof EntityAINearestAttackableTarget && !SWConfiguration.attackSkeletons) {
                removeTask = true;
            }
            if (!removeTask) continue;
            taskIterator.remove();
        }
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINewOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINewOwnerHurtTarget((EntityTameable)this));
        this.updateSpecies(this.getSpeciesByBiome());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WOLF_SPECIES, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)SWConfiguration.wolvesHealthTamed);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)SWConfiguration.wolvesHealthWild);
        }
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("Species", this.getSpecies().ordinal());
        nbtTagCompound.func_74757_a("RottenMeatAndBones", this.rottenMeatAndBones);
        nbtTagCompound.func_74757_a("RawMeat", this.rawMeat);
        nbtTagCompound.func_74757_a("RawFish", this.rawFish);
        nbtTagCompound.func_74757_a("SpecialFish", this.specialFish);
        nbtTagCompound.func_74757_a("CookedMeat", this.cookedMeat);
        nbtTagCompound.func_74757_a("CookedFish", this.cookedFish);
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.updateSpecies(EnumWolfSpecies.getSpeciesByNum(nbtTagCompound.func_74762_e("Species")));
        if (nbtTagCompound.func_74764_b("RottenMeatAndBones")) {
            this.rottenMeatAndBones = nbtTagCompound.func_74767_n("RottenMeatAndBones");
        }
        if (nbtTagCompound.func_74764_b("RawMeat")) {
            this.rawMeat = nbtTagCompound.func_74767_n("RawMeat");
        }
        if (nbtTagCompound.func_74764_b("RawFish")) {
            this.rawFish = nbtTagCompound.func_74767_n("RawFish");
        }
        if (nbtTagCompound.func_74764_b("SpecialFish")) {
            this.specialFish = nbtTagCompound.func_74767_n("SpecialFish");
        }
        if (nbtTagCompound.func_74764_b("CookedMeat")) {
            this.cookedMeat = nbtTagCompound.func_74767_n("CookedMeat");
        }
        if (nbtTagCompound.func_74764_b("CookedFish")) {
            this.cookedFish = nbtTagCompound.func_74767_n("CookedFish");
        }
        this.updateFood();
    }

    protected SoundEvent func_184639_G() {
        if (this.func_70919_bu()) {
            return SoundEvents.field_187861_gG;
        }
        if (this.func_70909_n() && this.CreeperAlert()) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0 && !this.CreeperAlert()) {
            if (this.func_70909_n() && this.func_110143_aJ() < (float)(SWConfiguration.wolvesHealthTamed / 2)) {
                return SoundEvents.field_187871_gL;
            }
            return SoundEvents.field_187865_gI;
        }
        if (!this.func_70906_o()) {
            return SoundEvents.field_187857_gE;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return SoundEvents.field_187857_gE;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70920_v() {
        if (this.func_70919_bu()) {
            return 1.5393804f;
        }
        if (this.func_70909_n()) {
            return (0.55f - ((float)SWConfiguration.wolvesHealthTamed - this.func_110143_aJ()) * 0.02f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70909_n()) {
            this.func_70916_h(false);
        }
    }

    public void func_70071_h_() {
        if (!this.field_70925_g && (this.func_70027_ad() && !this.field_70170_p.func_147470_e(this.func_174813_aQ().func_191195_a(0.001, 0.001, 0.001)) || this.func_70644_a((Potion)Potion.field_188414_b.func_148754_a(19)) || this.func_70644_a((Potion)Potion.field_188414_b.func_148754_a(20)))) {
            this.field_70928_h = true;
            this.field_70929_i = 0.0f;
            this.field_70927_j = 0.0f;
            this.field_70925_g = true;
        }
        if (!this.func_70026_G() && this.field_70925_g) {
            if (this.field_70929_i == 0.0f) {
                if (this.func_70027_ad()) {
                    this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                } else if (this.func_70644_a((Potion)Potion.field_188414_b.func_148754_a(19)) || this.func_70644_a((Potion)Potion.field_188414_b.func_148754_a(20))) {
                    this.puking = true;
                } else {
                    this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
            }
            if ((double)this.field_70927_j >= 1.95) {
                if (this.func_70027_ad()) {
                    this.func_70066_B();
                    this.func_184185_a(SoundEvents.field_187646_bt, 0.7f, 1.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                }
                if (this.puking) {
                    this.func_70674_bp();
                    this.puking = false;
                }
            }
            if ((double)this.field_70929_i > 0.35) {
                if (this.func_70027_ad()) {
                    this.func_70908_e(false);
                }
                if (!this.puking) {
                    float var1 = (float)this.func_174813_aQ().field_72338_b;
                    int var2 = (int)(MathHelper.func_76126_a((float)((this.field_70929_i - 0.4f) * (float)Math.PI)) * 7.0f);
                    for (int var3 = 0; var3 < var2; ++var3) {
                        float var4 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                        float var5 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)var4, (double)var1 + 0.8, this.field_70161_v + (double)var5, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                    }
                }
            }
        }
        if (this.isDrowning) {
            if (this.drownCount > 0) {
                --this.drownCount;
            } else {
                this.isDrowning = false;
            }
        }
        super.func_70071_h_();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (stack != null) {
                if (FoodHelper.isFoodItem(stack) && this.func_110143_aJ() < (float)SWConfiguration.wolvesHealthTamed) {
                    int hp = FoodHelper.getHealPoints(stack);
                    if (hp > 0) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                        this.func_70691_i(hp);
                        this.field_70911_d.func_75270_a(this.func_70906_o());
                        return true;
                    }
                } else {
                    if (stack.func_77973_b() instanceof ItemDogTag || stack.func_77973_b() instanceof ItemPetCarrier) {
                        this.field_70911_d.func_75270_a(this.func_70906_o());
                        return false;
                    }
                    if (FoodHelper.isBone(stack)) {
                        SophisticatedWolvesMod.proxy.openFoodGui(this);
                        stack.func_190918_g(1);
                        return true;
                    }
                }
            }
        } else if (stack.func_77973_b() == Items.field_151103_aS && !this.func_70919_bu()) {
            super.func_184645_a(player, hand);
            if (this.func_70909_n() && !this.field_70170_p.field_72995_K) {
                this.func_70606_j(SWConfiguration.wolvesHealthTamed);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (SWConfiguration.customBreeding) {
            return stack.func_77973_b().equals(SWItems.DOG_TREAT);
        }
        return super.func_70877_b(stack);
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)SWConfiguration.wolvesHealthTamed);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)SWConfiguration.wolvesHealthWild);
        }
    }

    public EntityWolf func_90011_a(EntityAgeable entity) {
        EntitySophisticatedWolf wolf = new EntitySophisticatedWolf(this.field_70170_p);
        wolf.updateSpecies(this.getSpecies());
        UUID ownerId = this.func_184753_b();
        if (ownerId != null) {
            wolf.func_184754_b(ownerId);
            wolf.func_70903_f(true);
        }
        wolf.func_70606_j(SWConfiguration.wolvesHealthTamed);
        return wolf;
    }

    public boolean func_70878_b(EntityAnimal animal) {
        if (animal == this || !this.func_70909_n() || !(animal instanceof EntitySophisticatedWolf)) {
            return false;
        }
        EntitySophisticatedWolf wolf = (EntitySophisticatedWolf)animal;
        return wolf.func_70909_n() && !wolf.func_70906_o() && this.func_70880_s() && wolf.func_70880_s();
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n() && SWConfiguration.respawningWolves && this.field_70173_aa > 5000;
    }

    public boolean isFavoriteFood(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (itemstack.func_77973_b() instanceof ItemFood) {
            return this.func_110143_aJ() < (float)SWConfiguration.wolvesHealthTamed && (((ItemFood)itemstack.func_77973_b()).func_77845_h() || itemstack.func_77973_b().equals(Items.field_151115_aP) || itemstack.func_77973_b().equals(Items.field_179566_aV));
        }
        return itemstack.func_77973_b().equals(SWItems.DOG_TREAT) && this.func_70874_b() == 0;
    }

    public boolean CreeperAlert() {
        List list = this.field_70170_p.func_72872_a(EntityCreeper.class, this.func_174813_aQ().func_72321_a(16.0, 4.0, 16.0));
        if (!list.isEmpty()) {
            this.func_184185_a(SoundEvents.field_187861_gG, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            return true;
        }
        return false;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.field_73011_w.getDimension() == 0;
    }

    @Override
    public EnumWolfSpecies getSpeciesByBiome() {
        Biome biome = this.field_70170_p.getBiomeForCoordsBody(new BlockPos((Entity)this));
        if (biome instanceof BiomeForest) {
            if (this.field_70146_Z.nextInt(7) == 0) {
                return EnumWolfSpecies.BROWN;
            }
            return EnumWolfSpecies.FOREST;
        }
        if (this.field_70146_Z.nextInt(7) == 0) {
            return EnumWolfSpecies.BLACK;
        }
        return EnumWolfSpecies.VANILLA;
    }

    @Override
    public EnumWolfSpecies getSpecies() {
        return EnumWolfSpecies.values()[(Integer)this.field_70180_af.func_187225_a(WOLF_SPECIES)];
    }

    @Override
    public void updateSpecies(EnumWolfSpecies species) {
        this.field_70180_af.func_187227_b(WOLF_SPECIES, (Object)species.ordinal());
    }

    public void func_70645_a(DamageSource damageSource) {
        if (this.func_70909_n() && this.func_70902_q() != null) {
            ((EntityPlayer)this.func_70902_q()).func_145747_a(this.func_110142_aN().func_151521_b());
        }
        super.func_70645_a(damageSource);
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (damageSource.func_76346_g() != null && damageSource.func_76346_g().equals((Object)this.func_70902_q()) && !damageSource.func_76346_g().func_70093_af() || SWConfiguration.immuneToCacti && damageSource.equals(DamageSource.field_76367_g)) {
            return false;
        }
        if (damageSource.equals(DamageSource.field_76369_e)) {
            this.isDrowning = true;
            this.drownCount = 30;
        }
        return super.func_70097_a(damageSource, amount);
    }

    public void func_70108_f(Entity entity) {
        if (!(entity instanceof EntitySophisticatedWolf) || !SWConfiguration.wolvesWalksThroughEachOther) {
            super.func_70108_f(entity);
        }
    }

    public boolean isDrowning() {
        return this.isDrowning;
    }

    public void setDrowning(boolean isDrowning) {
        this.isDrowning = isDrowning;
        if (isDrowning) {
            this.drownCount = 30;
        }
    }

    protected int func_190531_bD() {
        return 5;
    }

    public boolean func_70026_G() {
        return super.func_70026_G() || this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72321_a(0.0, -0.25, 0.0).func_191195_a(0.001, 0.001, 0.001), Material.field_151586_h, (Entity)this);
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    public boolean isRottenMeatAndBones() {
        return this.rottenMeatAndBones;
    }

    public void setRottenMeatAndBones(boolean rottenMeatAndBones) {
        this.rottenMeatAndBones = rottenMeatAndBones;
    }

    public boolean isRawMeat() {
        return this.rawMeat;
    }

    public void setRawMeat(boolean rawMeat) {
        this.rawMeat = rawMeat;
    }

    public boolean isRawFish() {
        return this.rawFish;
    }

    public void setRawFish(boolean rawFish) {
        this.rawFish = rawFish;
    }

    public boolean isSpecialFish() {
        return this.specialFish;
    }

    public void setSpecialFish(boolean specialFish) {
        this.specialFish = specialFish;
    }

    public boolean isCookedMeat() {
        return this.cookedMeat;
    }

    public void setCookedMeat(boolean cookedMeat) {
        this.cookedMeat = cookedMeat;
    }

    public boolean isCookedFish() {
        return this.cookedFish;
    }

    public void setCookedFish(boolean cookedFish) {
        this.cookedFish = cookedFish;
    }

    public boolean isAnyFood() {
        return this.anyFood;
    }

    public void setAnyFood(boolean anyFood) {
        this.anyFood = anyFood;
    }

    public void updateFood(boolean rottenMeatAndBones, boolean rawMeat, boolean rawFish, boolean specialFish, boolean cookedMeat, boolean cookedFish) {
        this.setRottenMeatAndBones(rottenMeatAndBones);
        this.setRawMeat(rawMeat);
        this.setRawFish(rawFish);
        this.setSpecialFish(specialFish);
        this.setCookedMeat(cookedMeat);
        this.setCookedFish(cookedFish);
        this.updateFood();
    }

    public void updateFood() {
        this.anyFood = this.rottenMeatAndBones && this.rawMeat && this.rawFish && this.specialFish && this.cookedMeat && this.cookedFish;
    }
}

