/*
 * Decompiled with CFR 0.152.
 */
package sophisticated_wolves;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class SWConfiguration {
    private static SWConfiguration instance;
    private static Configuration config;
    public static boolean customWolfTextures;
    public static boolean respawningWolves;
    public static boolean customBreeding;
    public static boolean nameTagForAnyPets;
    public static boolean immuneToCacti;
    public static boolean attackAnimals;
    public static boolean attackSkeletons;
    public static int spawnProbability;
    public static int spawnMinCount;
    public static int spawnMaxCount;
    public static boolean enablePetsSeller;
    public static boolean wolvesWalksThroughEachOther;
    public static int wolvesHealthWild;
    public static int wolvesHealthTamed;

    private SWConfiguration(File configFile) {
        config = new Configuration(configFile);
        this.getConfigs();
    }

    public static SWConfiguration getInstance(File configFile) {
        if (instance == null) {
            return new SWConfiguration(configFile);
        }
        return instance;
    }

    public final void getConfigs() {
        config.load();
        customWolfTextures = config.get("general", "CustomWolfTextures", true).getBoolean();
        respawningWolves = config.get("general", "RespawningWolves", true).getBoolean();
        customBreeding = config.get("general", "CustomBreeding", true).getBoolean();
        nameTagForAnyPets = config.get("general", "NameTagForAnyPets", true).getBoolean();
        immuneToCacti = config.get("general", "ImmuneToCacti", true).getBoolean();
        attackAnimals = config.get("general", "AttackAnimals", false).getBoolean();
        attackSkeletons = config.get("general", "AttackSkeletons", true).getBoolean();
        Property spawnProbabilityProperty = config.get("general", "SpawnProbability", 5);
        spawnProbabilityProperty.setComment("Chance to spawn wolf. The higher value - higher chance to be spawned. It should be in range of 0 an 100!");
        spawnProbability = spawnProbabilityProperty.getInt();
        spawnMinCount = config.get("general", "SpawnMinCount", 4).getInt();
        spawnMaxCount = config.get("general", "SpawnMaxCount", 6).getInt();
        if (spawnMinCount < 0) {
            spawnMinCount = 0;
        }
        if (spawnMaxCount < spawnMinCount) {
            spawnMaxCount = spawnMinCount;
        }
        enablePetsSeller = config.get("general", "EnablePetsSeller", true).getBoolean();
        wolvesWalksThroughEachOther = config.get("general", "WolvesWalksThroughEachOther", true).getBoolean();
        wolvesHealthWild = config.get("general", "WolvesHealthWild", 8).getInt();
        wolvesHealthTamed = config.get("general", "WolvesHealthTamed", 20).getInt();
        if (wolvesHealthWild <= 0) {
            wolvesHealthWild = 1;
        }
        if (wolvesHealthTamed <= 0) {
            wolvesHealthTamed = 1;
        }
        config.save();
    }
}

