/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.items.wrapper.transactions;

import info.jbcs.minecraft.vending.EnderPayApiUtils;
import info.jbcs.minecraft.vending.Vending;
import info.jbcs.minecraft.vending.forge.LoaderWrapper;
import info.jbcs.minecraft.vending.inventory.InventoryVendingMachine;
import info.jbcs.minecraft.vending.items.wrapper.AdvancedInventoryWrapper;
import info.jbcs.minecraft.vending.items.wrapper.AdvancedItemHandlerHelper;
import info.jbcs.minecraft.vending.items.wrapper.IItemHandlerAdvanced;
import info.jbcs.minecraft.vending.items.wrapper.StorageAttachmentStorageInvWrapper;
import info.jbcs.minecraft.vending.items.wrapper.VendingMachineBoughtInvWrapper;
import info.jbcs.minecraft.vending.items.wrapper.VendingMachineCombinedInvWrapper;
import info.jbcs.minecraft.vending.items.wrapper.VendingMachineSoldInvWrapper;
import info.jbcs.minecraft.vending.items.wrapper.VendingMachineStorageInvWrapper;
import info.jbcs.minecraft.vending.items.wrapper.transactions.BuyRequest;
import info.jbcs.minecraft.vending.items.wrapper.transactions.BuyResponse;
import info.jbcs.minecraft.vending.items.wrapper.transactions.VendingStatus;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingMachine;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;

public class VendingMachineInvWrapper {
    private InventoryVendingMachine inventory;
    private TileEntityVendingMachine machine;
    private IItemHandlerAdvanced soldHandler;
    private IItemHandlerAdvanced boughtHandler;

    public VendingMachineInvWrapper(TileEntityVendingMachine machine, InventoryVendingMachine inventory) {
        this.soldHandler = new AdvancedInventoryWrapper(new VendingMachineSoldInvWrapper(inventory));
        this.boughtHandler = new AdvancedInventoryWrapper(new VendingMachineBoughtInvWrapper(inventory));
        this.inventory = inventory;
        this.machine = machine;
    }

    public IItemHandlerAdvanced getSoldHandler() {
        return this.soldHandler;
    }

    public IItemHandlerAdvanced getStorageHandler() {
        if (this.inventory.hasAttachedStorage()) {
            return new AdvancedInventoryWrapper((IItemHandlerModifiable)new VendingMachineCombinedInvWrapper(new VendingMachineStorageInvWrapper(this.inventory), new StorageAttachmentStorageInvWrapper(this.inventory.getAttachedStorage())));
        }
        return new AdvancedInventoryWrapper((IItemHandlerModifiable)new VendingMachineStorageInvWrapper(this.inventory));
    }

    public boolean Accepts(ItemStack stack) {
        return !EnderPayApiUtils.isFilledBanknote(stack) && this.boughtHandler.containsItem(stack);
    }

    public boolean Vends(ItemStack stack) {
        return !EnderPayApiUtils.isFilledBanknote(stack) && this.soldHandler.containsItem(stack);
    }

    public boolean isInfinite() {
        return this.machine.isInfinite();
    }

    boolean hasNothingToSell() {
        boolean noItemsToSell;
        boolean bl = noItemsToSell = AdvancedItemHandlerHelper.countNotNull(this.getSoldItemsWithoutFilledBanknotes()) == 0;
        if (!LoaderWrapper.isEnderPayLoaded()) {
            return noItemsToSell;
        }
        return noItemsToSell && this.soldHandler.getCreditsSum(false) == 0L;
    }

    boolean hasNothingToBuy() {
        boolean noItemsToBuy;
        boolean bl = noItemsToBuy = AdvancedItemHandlerHelper.countNotNull(this.boughtHandler.getItemStacksWithoutFilledBanknotes()) == 0;
        if (!LoaderWrapper.isEnderPayLoaded()) {
            return noItemsToBuy;
        }
        return noItemsToBuy && this.boughtHandler.getCreditsSum(false) == 0L;
    }

    private void extractItem(ItemStack stack) {
        ItemStack extractedItem = this.getStorageHandler().extractItem(stack, false);
        ItemStack leftToExtract = stack.func_77946_l();
        leftToExtract.func_190920_e(stack.func_190916_E() - extractedItem.func_190916_E());
        if (leftToExtract.func_190916_E() > 0) {
            this.soldHandler.extractItem(leftToExtract, false);
            if (Vending.settings.shouldCloseOnPartialSoldOut()) {
                this.machine.setOpen(false);
            }
        }
    }

    public void extractItems(NonNullList<ItemStack> soldItems) {
        for (ItemStack item : soldItems) {
            this.extractItem(item);
        }
    }

    long storeCredits(long amount, boolean simulate) {
        if (!LoaderWrapper.isEnderPayLoaded()) {
            return 0L;
        }
        if (this.machine.isInfinite()) {
            return 0L;
        }
        long leftToTake = this.getStorageHandler().storeCredits(amount, simulate);
        if (leftToTake > 0L) {
            leftToTake = this.soldHandler.storeCredits(-leftToTake, simulate);
            if (Vending.settings.shouldCloseOnPartialSoldOut()) {
                this.machine.setOpen(false);
            }
            return leftToTake;
        }
        return 0L;
    }

    public long soldCreditsSum(boolean subtractTax) {
        return this.soldHandler.getCreditsSum(subtractTax);
    }

    public long getTotalAvailableCreditSums(boolean subtractTax) {
        return this.soldHandler.getCreditsSum(subtractTax) + this.getStorageHandler().getCreditsSum(subtractTax);
    }

    public long boughtCreditsSum(boolean subtractTax) {
        return this.boughtHandler.getCreditsSum(subtractTax);
    }

    public boolean hasBanknote() {
        return this.getStorageHandler().hasBanknote();
    }

    public NonNullList<ItemStack> getSoldItems() {
        return this.soldHandler.getItemStacks();
    }

    public NonNullList<ItemStack> getSoldItemsWithoutFilledBanknotes() {
        return this.soldHandler.getItemStacksWithoutFilledBanknotes();
    }

    public ItemStack getBoughtItemWithoutFilledBanknotes() {
        ItemStack itemStack = this.boughtHandler.getStackInSlot(0);
        if (!LoaderWrapper.isEnderPayLoaded() || !EnderPayApiUtils.isFilledBanknote(itemStack)) {
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getBoughtItem() {
        return this.boughtHandler.getStackInSlot(0);
    }

    public void setBoughtItem(ItemStack boughtItem) {
        this.boughtHandler.setStackInSlot(0, boughtItem);
    }

    public NonNullList<ItemStack> getInventoryItems() {
        return this.getStorageHandler().getItemStacks();
    }

    private boolean hasEnoughCreditsToReturn() {
        long realTotalSum;
        if (this.machine.isInfinite() || !LoaderWrapper.isEnderPayLoaded()) {
            return true;
        }
        long soldSum = this.soldHandler.getCreditsSum(false);
        return soldSum <= (realTotalSum = this.getTotalAvailableCreditSums(true));
    }

    @Nonnull
    public BuyResponse Accept(BuyRequest request) {
        return request.Visit(this);
    }

    public VendingStatus getVendingStatus() {
        if (!this.machine.isOpen()) {
            return VendingStatus.CLOSED;
        }
        if (this.hasNothingToSell() && this.hasNothingToBuy()) {
            return VendingStatus.NOTHING_TO_TRADE;
        }
        if (!this.machine.isInfinite()) {
            if (!this.hasEnoughCreditsToReturn()) {
                return VendingStatus.NOT_ENOUGH_CREDITS_IN_STORAGE;
            }
            if (this.boughtCreditsSum(false) > 0L) {
                if (this.storeCredits(this.getCreditsToTake(), true) != 0L) {
                    if (this.getStorageHandler().hasBanknote()) {
                        return VendingStatus.NO_BANKNOTE_IN_INVENTORY;
                    }
                    return VendingStatus.NOT_ENOUGH_SPACE_TO_STORE_ITEMS;
                }
            } else if (!this.getStorageHandler().insertItem(this.getBoughtItem(), true).func_190926_b()) {
                return VendingStatus.NOT_ENOUGH_SPACE_TO_STORE_ITEMS;
            }
        }
        return VendingStatus.OPEN;
    }

    public long getCreditsToReturn() {
        return this.soldCreditsSum(false) - this.boughtCreditsSum(false);
    }

    public long getCreditsToTake() {
        return -this.getCreditsToReturn();
    }

    public VendingStatus getVendingStatus(long offeredCredits, ItemStack offeredStack) {
        VendingStatus status = this.getVendingStatus();
        if (status != VendingStatus.OPEN) {
            return status;
        }
        if (this.getBoughtItemWithoutFilledBanknotes() != ItemStack.field_190927_a) {
            if (!AdvancedItemHandlerHelper.areStacksEqualIgnoreCount(this.getBoughtItem(), offeredStack)) {
                return VendingStatus.WRONG_ITEM_OFFERED_TYPE;
            }
            if (offeredStack.func_190916_E() < this.getBoughtItem().func_190916_E()) {
                return VendingStatus.NOT_ENOUGH_ITEM_OFFERED;
            }
        }
        if (offeredCredits < this.boughtCreditsSum(false)) {
            return VendingStatus.NOT_ENOUGH_CREDITS_OFFERED;
        }
        return VendingStatus.OPEN;
    }

    public void setOpen(boolean open) {
        this.machine.setOpen(open);
    }
}

