/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.items.wrapper.transactions;

import info.jbcs.minecraft.vending.Vending;
import info.jbcs.minecraft.vending.items.wrapper.transactions.BuyResponse;
import info.jbcs.minecraft.vending.items.wrapper.transactions.VendingMachineInvWrapper;
import info.jbcs.minecraft.vending.items.wrapper.transactions.VendingStatus;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class BuyRequest {
    private long availableCredits;
    private ItemStack offeredStack;
    private boolean simulate;

    BuyRequest(long availableCredits, ItemStack offeredStack, boolean simulate) {
        this.availableCredits = availableCredits;
        this.offeredStack = offeredStack;
        this.simulate = simulate;
    }

    @Nonnull
    public BuyResponse Visit(VendingMachineInvWrapper vendingMachineInvWrapper) {
        if (vendingMachineInvWrapper.getVendingStatus(this.availableCredits, this.offeredStack) != VendingStatus.OPEN) {
            return BuyResponse.UNCOMPLETED;
        }
        this.offeredStack = this.offeredStack.func_77946_l();
        BuyResponse response = new BuyResponse(vendingMachineInvWrapper.getCreditsToReturn(), this.splitOffered(this.offeredStack, vendingMachineInvWrapper.getBoughtItemWithoutFilledBanknotes()), vendingMachineInvWrapper.getSoldItemsWithoutFilledBanknotes(), true);
        if (!this.simulate && !vendingMachineInvWrapper.isInfinite()) {
            vendingMachineInvWrapper.getStorageHandler().insertItem(vendingMachineInvWrapper.getBoughtItemWithoutFilledBanknotes(), false);
            vendingMachineInvWrapper.storeCredits(vendingMachineInvWrapper.getCreditsToTake(), false);
            vendingMachineInvWrapper.extractItems(vendingMachineInvWrapper.getSoldItemsWithoutFilledBanknotes());
            if (Vending.settings.shouldCloseOnSoldOut() && vendingMachineInvWrapper.hasNothingToSell()) {
                vendingMachineInvWrapper.setOpen(false);
            }
        }
        return response;
    }

    private ItemStack splitOffered(@Nonnull ItemStack offered, @Nonnull ItemStack bought) {
        if ((offered = offered.func_77946_l()).func_190926_b() || bought.func_190926_b()) {
            return offered;
        }
        offered.func_77979_a(bought.func_190916_E());
        if (offered.func_190916_E() == 0) {
            offered = ItemStack.field_190927_a;
        }
        return offered;
    }
}

