/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.items.wrapper;

import info.jbcs.minecraft.vending.Utils;
import info.jbcs.minecraft.vending.items.wrapper.transactions.InsertionResultMultiple;
import info.jbcs.minecraft.vending.items.wrapper.transactions.InsertionResultSingle;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class AdvancedItemHandlerHelper
extends ItemHandlerHelper {
    public static int countNotNull(@Nonnull NonNullList<ItemStack> itemStacks) {
        int counter = 0;
        for (ItemStack itemStack : itemStacks) {
            if (itemStack.func_190926_b()) continue;
            ++counter;
        }
        return counter;
    }

    @Nonnull
    public static NonNullList<ItemStack> insertItems(@Nonnull IItemHandlerModifiable itemHandler, NonNullList<ItemStack> itemStacks, boolean simulate) {
        return AdvancedItemHandlerHelper.insertItemsPrivate(itemHandler, itemStacks, simulate).getItemsLeft();
    }

    private static InsertionResultMultiple insertItemsPrivate(@Nonnull IItemHandlerModifiable itemHandler, NonNullList<ItemStack> items, boolean simulate) {
        NonNullList itemStacksThatDidNotFit = NonNullList.func_191196_a();
        items = Utils.joinItems(items);
        int emptySlots = AdvancedItemHandlerHelper.getEmptyCount(itemHandler);
        int emptySlotsUsed = 0;
        for (ItemStack itemStack2 : items) {
            InsertionResultSingle insertionResultSingle = AdvancedItemHandlerHelper.insertItem(itemHandler, itemStack2, emptySlots, simulate);
            emptySlots -= insertionResultSingle.getEmptySlotsUsed();
            emptySlotsUsed += insertionResultSingle.getEmptySlotsUsed();
            if (insertionResultSingle.noItemsLeftToInsert()) continue;
            itemStacksThatDidNotFit.addAll(Utils.splitItemsStack(insertionResultSingle.getItemsLeft()));
        }
        return new InsertionResultMultiple((NonNullList<ItemStack>)itemStacksThatDidNotFit, emptySlotsUsed);
    }

    private static InsertionResultSingle insertItem(@Nonnull IItemHandlerModifiable itemHandler, ItemStack itemStack, int emptySlots, boolean simulate) {
        int i;
        int emptySlotsUsed = 0;
        for (i = 0; i < itemHandler.getSlots(); ++i) {
            if (itemStack.func_190926_b()) {
                return new InsertionResultSingle(itemStack, 0);
            }
            if (itemHandler.getStackInSlot(i).func_190926_b()) continue;
            itemStack = itemHandler.insertItem(i, itemStack, simulate);
        }
        for (i = 0; i < itemHandler.getSlots(); ++i) {
            if (emptySlots <= 0 || itemStack.func_190926_b()) {
                return new InsertionResultSingle(itemStack, emptySlotsUsed);
            }
            if (!itemHandler.getStackInSlot(i).func_190926_b()) continue;
            ++emptySlotsUsed;
            itemStack = itemHandler.insertItem(i, itemStack, simulate);
            --emptySlots;
        }
        return new InsertionResultSingle(itemStack, emptySlotsUsed);
    }

    private static int getEmptyCount(@Nonnull IItemHandlerModifiable itemHandler) {
        int emptySlots = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!itemHandler.getStackInSlot(i).func_190926_b()) continue;
            ++emptySlots;
        }
        return emptySlots;
    }

    public static boolean areStacksEqualIgnoreCount(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() && stack2.func_190926_b()) {
            return true;
        }
        if (stack1.func_190916_E() == 0 || stack2.func_190916_E() == 0) {
            return false;
        }
        stack1 = stack1.func_77946_l();
        stack2 = stack2.func_77946_l();
        stack1.func_190920_e(1);
        stack2.func_190920_e(1);
        return ItemStack.func_77989_b((ItemStack)stack1, (ItemStack)stack2);
    }
}

