/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.items.wrapper;

import com.kamildanak.minecraft.enderpay.EnderPay;
import com.kamildanak.minecraft.enderpay.api.EnderPayApi;
import com.kamildanak.minecraft.enderpay.api.NotABanknoteException;
import info.jbcs.minecraft.vending.EnderPayApiUtils;
import info.jbcs.minecraft.vending.forge.LoaderWrapper;
import info.jbcs.minecraft.vending.items.wrapper.AdvancedItemHandlerHelper;
import info.jbcs.minecraft.vending.items.wrapper.DummyInventoryWrapper;
import info.jbcs.minecraft.vending.items.wrapper.IItemHandlerAdvanced;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandlerModifiable;

public class AdvancedInventoryWrapper
extends DummyInventoryWrapper
implements IItemHandlerAdvanced {
    public AdvancedInventoryWrapper(IItemHandlerModifiable itemHandlerModifiable) {
        super(itemHandlerModifiable);
    }

    @Override
    public long storeCredits(long credits, boolean simulate) {
        if (!LoaderWrapper.isEnderPayLoaded()) {
            return 0L;
        }
        return this.storeCreditsOptional(credits, simulate);
    }

    @Optional.Method(modid="enderpay")
    private long takeCreditsOptional(long credits, boolean simulate) {
        int i;
        if (credits < 0L) {
            return this.storeCreditsOptional(-credits, simulate);
        }
        if (credits == 0L) {
            return 0L;
        }
        int banknotes = 0;
        long creditsSum = 0L;
        for (i = 0; i < this.getSlots(); ++i) {
            if (!EnderPayApiUtils.isBanknote(this.getStackInSlot(i))) continue;
            banknotes += this.getStackInSlot(i).func_190916_E();
            try {
                creditsSum += EnderPayApi.getBanknoteCurrentValue((ItemStack)this.getStackInSlot(i));
            }
            catch (NotABanknoteException notABanknoteException) {
                // empty catch block
            }
            if (simulate) continue;
            this.setStackInSlot(i, ItemStack.field_190927_a);
        }
        if (simulate) {
            return Math.max(0L, -(creditsSum - credits));
        }
        for (i = 0; i < this.getSlots(); ++i) {
            if (!this.getStackInSlot(i).func_190926_b()) continue;
            long toStoreBack = creditsSum - credits;
            if (toStoreBack > 0L) {
                this.setStackInSlot(i, EnderPayApi.getBanknote((long)toStoreBack));
                --banknotes;
            }
            this.storeBlankBanknotes(banknotes);
            if (toStoreBack > 0L) {
                return 0L;
            }
            return -toStoreBack;
        }
        return creditsSum;
    }

    @Optional.Method(modid="enderpay")
    private long storeCreditsOptional(long credits, boolean simulate) {
        if (credits < 0L) {
            return this.takeCreditsOptional(-credits, simulate);
        }
        if (credits == 0L) {
            return 0L;
        }
        if (!this.canStoreCredits()) {
            return credits;
        }
        if (simulate) {
            return 0L;
        }
        int banknotes = 0;
        try {
            int i;
            for (i = 0; i < this.getSlots(); ++i) {
                ItemStack itemStack = this.getStackInSlot(i);
                if (!EnderPayApiUtils.isBanknote(itemStack)) continue;
                if (itemStack.func_190916_E() == 1) {
                    this.setStackInSlot(i, EnderPayApi.getBanknote((long)(credits + EnderPayApi.getBanknoteCurrentValue((ItemStack)itemStack))));
                    return 0L;
                }
                banknotes += itemStack.func_190916_E();
            }
            for (i = 0; i < this.getSlots(); ++i) {
                if (!EnderPayApiUtils.isBanknote(this.getStackInSlot(i))) continue;
                this.setStackInSlot(i, ItemStack.field_190927_a);
            }
            for (i = 0; i < this.getSlots(); ++i) {
                if (!this.getStackInSlot(i).func_190926_b()) continue;
                this.setStackInSlot(i, EnderPayApi.getBanknote((long)credits));
                --banknotes;
                break;
            }
            this.storeBlankBanknotes(banknotes);
            return 0L;
        }
        catch (NotABanknoteException notABanknoteException) {
            return credits;
        }
    }

    @Optional.Method(modid="enderpay")
    private boolean canStoreCredits() {
        if (!this.hasBanknote()) {
            return false;
        }
        int spacesForBanknotes = 0;
        int banknotes = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack itemStack = this.getStackInSlot(i);
            if (EnderPayApiUtils.isBanknote(itemStack) && itemStack.func_190916_E() == 1) {
                return true;
            }
            if (itemStack.func_190926_b()) {
                ++spacesForBanknotes;
            }
            if (!EnderPayApiUtils.isBanknote(itemStack)) continue;
            banknotes += itemStack.func_190916_E();
            ++spacesForBanknotes;
        }
        return (banknotes - 2) / 64 < spacesForBanknotes - 1;
    }

    @Override
    @Optional.Method(modid="enderpay")
    public boolean hasBanknote() {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!EnderPayApiUtils.isBanknote(this.getStackInSlot(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEmptySlots() {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!this.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="enderpay")
    private void storeBlankBanknotes(int banknotes) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!this.getStackInSlot(i).func_190926_b()) continue;
            if (banknotes <= 0) break;
            int m = Math.min(banknotes, 64);
            banknotes -= m;
            this.setStackInSlot(i, new ItemStack(EnderPay.itemBlankBanknote, m));
        }
    }

    @Override
    public boolean containsItem(ItemStack stack) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!AdvancedItemHandlerHelper.areStacksEqualIgnoreCount(stack, this.getStackInSlot(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getItemStacks() {
        NonNullList itemStacks = NonNullList.func_191196_a();
        for (int i = 0; i < this.getSlots(); ++i) {
            itemStacks.add((Object)this.getStackInSlot(i).func_77946_l());
        }
        return itemStacks;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getItemStacksWithoutFilledBanknotes() {
        if (!LoaderWrapper.isEnderPayLoaded()) {
            return this.getItemStacks();
        }
        return EnderPayApiUtils.filterFilledBanknotes(this.getItemStacks());
    }

    @Override
    public long getCreditsSum(boolean subtractTax) {
        if (!LoaderWrapper.isEnderPayLoaded()) {
            return 0L;
        }
        return subtractTax ? EnderPayApiUtils.currentValueCreditsSum(this.getItemStacks()) : EnderPayApiUtils.originalValueCreditsSum(this.getItemStacks());
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> insertItems(NonNullList<ItemStack> itemStacks, boolean simulate) {
        return AdvancedItemHandlerHelper.insertItems(this, itemStacks, simulate);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(ItemStack itemStack, boolean simulate) {
        itemStack = itemStack.func_77946_l();
        for (int i = 0; i < this.getSlots(); ++i) {
            itemStack = this.insertItem(i, itemStack, simulate);
        }
        return itemStack;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(ItemStack itemStack, boolean simulate) {
        int count = itemStack.func_190916_E();
        int extracted = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!AdvancedItemHandlerHelper.areStacksEqualIgnoreCount(itemStack, this.getStackInSlot(i))) continue;
            extracted += this.extractItem(i, count - extracted, simulate).func_190916_E();
        }
        return AdvancedItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)extracted);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

