/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.inventory;

import info.jbcs.minecraft.vending.inventory.InventorySerializable;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingStorageAttachment;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class InventoryVendingStorageAttachment
extends InventorySerializable
implements ISidedInventory {
    private static int[] storageSlots = IntStream.rangeClosed(0, 26).toArray();
    private static int[] inputSlots = IntStream.rangeClosed(27, 35).toArray();
    private static int[] outputSlots = IntStream.rangeClosed(36, 53).toArray();
    private TileEntityVendingStorageAttachment teSA;

    public InventoryVendingStorageAttachment(TileEntityVendingStorageAttachment te) {
        super("Vending Machine Attachment", false, 54);
        this.teSA = te;
    }

    private boolean isOutputSlot(int index) {
        return index >= 36 && index <= 53;
    }

    private boolean isInputSlot(int index) {
        return index >= 27 && index <= 35;
    }

    private boolean isInventorySlot(int index) {
        return index >= 0 && index <= 26;
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (side == EnumFacing.UP) {
            return new int[0];
        }
        if (side == EnumFacing.DOWN) {
            return outputSlots;
        }
        return inputSlots;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return this.isOutputSlot(index);
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return this.isOutputSlot(index) || this.isInputSlot(index);
    }
}

