/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.gui.hud;

import com.kamildanak.minecraft.foamflower.gui.elements.GuiElement;
import com.kamildanak.minecraft.foamflower.gui.elements.GuiItemsList;
import com.kamildanak.minecraft.foamflower.gui.elements.GuiLabel;
import com.kamildanak.minecraft.foamflower.gui.elements.GuiLabelCarousel;
import com.kamildanak.minecraft.foamflower.gui.hud.HUD;
import com.kamildanak.minecraft.foamflower.gui.layouts.CenteredLayout;
import com.kamildanak.minecraft.foamflower.gui.layouts.LinearLayout;
import info.jbcs.minecraft.vending.EnderPayApiUtils;
import info.jbcs.minecraft.vending.Utils;
import info.jbcs.minecraft.vending.Vending;
import info.jbcs.minecraft.vending.forge.LoaderWrapper;
import info.jbcs.minecraft.vending.items.wrapper.AdvancedItemHandlerHelper;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingMachine;
import java.util.Vector;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class HintHUD
extends HUD {
    private Minecraft mc;
    private GuiElement root;
    private LinearLayout layout;
    private LinearLayout boughtAndSold;
    private LinearLayout bought;
    private LinearLayout sold;
    private LinearLayout boughtItems;
    private LinearLayout soldItems;
    private GuiLabel labelBoughtCredits;
    private GuiLabel labelSoldCredits;
    private GuiLabel labelSeller;
    private GuiLabel labelClosed;
    private GuiLabel labelSelling;
    private GuiLabel labelFor;
    private GuiLabelCarousel labelBoughtDesc;
    private GuiLabelCarousel labelSoldDesc;
    private GuiItemsList soldItemList;
    private GuiItemsList boughtItemList;

    public HintHUD(Minecraft mc) {
        super(mc);
        this.mc = mc;
        ScaledResolution resolution = new ScaledResolution(mc);
        this.root = new CenteredLayout(0, 0, resolution.func_78326_a(), resolution.func_78328_b(), true, false);
        this.root.gui = this;
        this.layout = new LinearLayout(0, 0, false);
        this.root.addChild((GuiElement)this.layout);
        this.labelSeller = new GuiLabel(0, 0, "<seller>", 0xFFFFFF);
        this.layout.addChild((GuiElement)this.labelSeller);
        this.labelClosed = new GuiLabel(0, 0, "gui.vendingBlock.closed", 0xA0A0A0);
        this.layout.addChild((GuiElement)this.labelClosed);
        this.boughtAndSold = new LinearLayout(0, 0, false);
        this.layout.addChild((GuiElement)this.boughtAndSold);
        this.sold = new LinearLayout(0, 0, false);
        this.boughtAndSold.addChild((GuiElement)this.sold);
        this.bought = new LinearLayout(0, 0, false);
        this.boughtAndSold.addChild((GuiElement)this.bought);
        this.soldItems = new LinearLayout(0, 0, true);
        this.sold.addChild((GuiElement)this.soldItems);
        this.labelSelling = new GuiLabel(0, 0, "gui.vendingBlock.isSelling", 0xA0A0A0);
        this.soldItems.addChild((GuiElement)this.labelSelling);
        this.soldItemList = new GuiItemsList(0, 0, 0, 0);
        this.soldItems.addChild((GuiElement)this.soldItemList);
        this.labelSoldDesc = new GuiLabelCarousel(0, 0, "", 0xA0A0A0);
        this.sold.addChild((GuiElement)this.labelSoldDesc);
        this.labelSoldCredits = new GuiLabel(0, 0, "<sCredits>", 0xA0A0A0);
        this.sold.addChild((GuiElement)this.labelSoldCredits);
        this.boughtItems = new LinearLayout(0, 0, true);
        this.bought.addChild((GuiElement)this.boughtItems);
        this.labelFor = new GuiLabel(0, 0, "gui.vendingBlock.for", 0xA0A0A0);
        this.boughtItems.addChild((GuiElement)this.labelFor);
        this.boughtItemList = new GuiItemsList(0, 0, 0, 0);
        this.boughtItems.addChild((GuiElement)this.boughtItemList);
        this.labelBoughtDesc = new GuiLabelCarousel(0, 0, "", 0xA0A0A0);
        this.bought.addChild((GuiElement)this.labelBoughtDesc);
        this.labelBoughtCredits = new GuiLabel(0, 0, "<bCredits>", 0xA0A0A0);
        this.bought.addChild((GuiElement)this.labelBoughtCredits);
    }

    public GuiElement getRoot() {
        return this.root;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderInfo(RenderGameOverlayEvent.Post event) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (this.mc == null || this.mc.field_71439_g == null || this.mc.field_71441_e == null) {
            return;
        }
        RayTraceResult mop = this.mc.field_71476_x;
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        IBlockState blockState = this.mc.field_71441_e.func_180495_p(mop.func_178782_a());
        if (!blockState.func_177230_c().hasTileEntity(blockState)) {
            return;
        }
        TileEntity te = this.mc.field_71441_e.func_175625_s(mop.func_178782_a());
        if (te == null) {
            return;
        }
        if (!(this.mc.field_71441_e.func_175625_s(mop.func_178782_a()) instanceof TileEntityVendingMachine)) {
            return;
        }
        ScaledResolution resolution = new ScaledResolution(this.mc);
        this.root.h = resolution.func_78328_b();
        this.root.w = resolution.func_78326_a();
        this.boughtAndSold.setHorizontal(this.mc.field_71439_g.func_70093_af());
        TileEntityVendingMachine tileEntity = (TileEntityVendingMachine)te;
        this.root.y = Vending.settings.getOffsetY();
        this.labelSeller.setCaption(tileEntity.getOwnerName());
        this.labelSeller.center = true;
        boolean isOpened = tileEntity.isOpen();
        if (LoaderWrapper.isEnderPayLoaded()) {
            if (isOpened && !tileEntity.isInfinite()) {
                long realTotalSum;
                long soldSum = tileEntity.getInventoryWrapper().soldCreditsSum(false);
                boolean bl = isOpened = soldSum <= (realTotalSum = tileEntity.getInventoryWrapper().getTotalAvailableCreditSums(true));
                if (!isOpened) {
                    this.labelClosed.setCaption("gui.vendingBlock.shopNotEnoughCredits");
                } else {
                    boolean bl2 = isOpened = tileEntity.getInventoryWrapper().boughtCreditsSum(false) <= 0L || tileEntity.getInventoryWrapper().hasBanknote();
                    if (!isOpened) {
                        this.labelClosed.setCaption("gui.vendingBlock.banknoteInStorageRequiredToAcceptPayments");
                    }
                }
            } else {
                this.labelClosed.setCaption("gui.vendingBlock.closed");
            }
        }
        this.labelClosed.hidden = isOpened;
        this.boughtAndSold.hidden = !isOpened;
        NonNullList soldItemStacks = NonNullList.func_191196_a();
        NonNullList boughtItemStacks = NonNullList.func_191196_a();
        soldItemStacks.addAll(tileEntity.getInventoryWrapper().getSoldItemsWithoutFilledBanknotes());
        boughtItemStacks.add((Object)tileEntity.getInventoryWrapper().getBoughtItemWithoutFilledBanknotes());
        if (LoaderWrapper.isEnderPayLoaded()) {
            long amountSold = 0L;
            long amountBought = 0L;
            amountSold = tileEntity.getInventoryWrapper().soldCreditsSum(false);
            amountBought = tileEntity.getInventoryWrapper().boughtCreditsSum(false);
            String label = AdvancedItemHandlerHelper.countNotNull((NonNullList<ItemStack>)soldItemStacks) == 0 ? (amountBought == 0L && AdvancedItemHandlerHelper.countNotNull((NonNullList<ItemStack>)boughtItemStacks) == 0 ? "gui.vendingBlock.isGivingAway" : "gui.vendingBlock.isSelling") : "gui.vendingBlock.and";
            String amountStr = this.mc.field_71439_g.func_70093_af() ? I18n.func_135052_a((String)label, (Object[])new Object[0]).trim() + " " + amountSold + " " + this.getCurrencyName(amountSold) : I18n.func_135052_a((String)label, (Object[])new Object[0]).trim() + " " + Utils.format(amountSold) + " " + this.getCurrencyName(amountSold);
            this.labelSoldCredits.setCaption(amountStr);
            boolean bl = this.labelSoldCredits.hidden = amountSold == 0L;
            label = AdvancedItemHandlerHelper.countNotNull((NonNullList<ItemStack>)boughtItemStacks) == 0 ? (amountSold == 0L && AdvancedItemHandlerHelper.countNotNull((NonNullList<ItemStack>)soldItemStacks) == 0 ? "gui.vendingBlock.isAccepting" : "gui.vendingBlock.for") : "gui.vendingBlock.and";
            amountStr = this.mc.field_71439_g.func_70093_af() ? I18n.func_135052_a((String)label, (Object[])new Object[0]).trim() + " " + amountBought + " " + this.getCurrencyName(amountBought) : I18n.func_135052_a((String)label, (Object[])new Object[0]).trim() + " " + Utils.format(amountBought) + " " + this.getCurrencyName(amountBought);
            this.labelBoughtCredits.setCaption(amountStr);
            this.labelBoughtCredits.hidden = amountBought == 0L;
        }
        this.soldItems.hidden = AdvancedItemHandlerHelper.countNotNull((NonNullList<ItemStack>)soldItemStacks) == 0;
        this.boughtItems.hidden = AdvancedItemHandlerHelper.countNotNull((NonNullList<ItemStack>)boughtItemStacks) == 0;
        this.layout.hidden = this.soldItems.hidden && this.boughtItems.hidden && this.labelBoughtCredits.hidden && this.labelSoldCredits.hidden;
        this.soldItemList.setItems(soldItemStacks);
        this.boughtItemList.setItems(boughtItemStacks);
        this.labelSoldDesc.hidden = !this.mc.field_71439_g.func_70093_af();
        boolean bl = this.labelBoughtDesc.hidden = !this.mc.field_71439_g.func_70093_af();
        if (this.mc.field_71439_g.func_70093_af()) {
            this.labelBoughtDesc.setCaption(this.getTooltips((NonNullList<ItemStack>)boughtItemStacks));
            this.labelSoldDesc.setCaption(this.getTooltips((NonNullList<ItemStack>)soldItemStacks));
        }
        this.labelSelling.setCaption(this.boughtItems.hidden && this.labelBoughtCredits.hidden ? "gui.vendingBlock.isGivingAway" : "gui.vendingBlock.isSelling");
        this.labelFor.setCaption(this.soldItems.hidden && this.labelSoldCredits.hidden ? "gui.vendingBlock.isAccepting" : "gui.vendingBlock.for");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.layout.hidden) {
            this.func_73733_a(this.layout.x - 6, this.layout.y - 5, this.layout.x + this.layout.getWidth() + 6, this.layout.y + this.layout.getHeight() + 5 - 2, -1072689136, -804253680);
        }
        if (!LoaderWrapper.isEnderPayLoaded()) {
            this.labelSoldCredits.hidden = true;
            this.labelBoughtCredits.hidden = true;
        }
        super.render();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.bind("textures/gui/icons.png");
    }

    private String[] getTooltips(NonNullList<ItemStack> itemStacks) {
        Vector<String> tooltips = new Vector<String>();
        for (ItemStack stack : itemStacks) {
            if (stack.func_190926_b()) continue;
            StringBuilder tooltip = new StringBuilder();
            for (int i = 0; i < stack.func_82840_a((EntityPlayer)this.mc.field_71439_g, () -> false).size(); ++i) {
                if (i != 0) {
                    tooltip.append("\n");
                }
                tooltip.append((String)stack.func_82840_a((EntityPlayer)this.mc.field_71439_g, () -> false).get(i));
            }
            tooltips.add(tooltip.toString());
        }
        return tooltips.toArray(new String[tooltips.size()]);
    }

    private String getCurrencyName(long amount) {
        return EnderPayApiUtils.getCurrencyName(amount);
    }
}

