/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.block;

import info.jbcs.minecraft.vending.Vending;
import info.jbcs.minecraft.vending.stats.ModStats;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingMachine;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingStorageAttachment;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockVendingStorageAttachment
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockVendingStorageAttachment(String name, Material material) {
        super(material);
        this.setProperties();
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    private void setProperties() {
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.3f);
        this.func_149752_b(6000000.0f);
        this.func_149722_s();
        this.func_149647_a(Vending.tabVending);
    }

    public void func_180649_a(World world, BlockPos blockPos, EntityPlayer entityplayer) {
        TileEntityVendingMachine tileEntity = (TileEntityVendingMachine)world.func_175625_s(blockPos.func_177984_a());
        TileEntityVendingStorageAttachment storageAttachment = (TileEntityVendingStorageAttachment)world.func_175625_s(blockPos);
        if (tileEntity == null || storageAttachment == null) {
            this.destroy(world, blockPos);
            return;
        }
        if (!entityplayer.getDisplayNameString().equals(tileEntity.getOwnerName()) || !storageAttachment.func_191420_l()) {
            return;
        }
        this.destroy(world, blockPos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.isBlocked(worldIn, pos)) {
            playerIn.func_71029_a(ModStats.STORAGE_ATTACHMENTS_OPENED);
        }
        Vending.guiStorage.open(playerIn, worldIn, pos);
        return true;
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        worldIn.func_180501_a(pos, state, 3);
    }

    public TileEntity func_149915_a(@Nonnull World world, int i) {
        return new TileEntityVendingStorageAttachment();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    private boolean isBlocked(World worldIn, BlockPos pos) {
        IBlockState blockSafeState = worldIn.func_180495_p(pos);
        return !worldIn.func_180495_p(pos.func_177972_a((EnumFacing)blockSafeState.func_177229_b((IProperty)FACING))).func_185904_a().func_76222_j() || !worldIn.func_180495_p(pos.func_177972_a((EnumFacing)blockSafeState.func_177229_b((IProperty)FACING)).func_177972_a(((EnumFacing)blockSafeState.func_177229_b((IProperty)FACING)).func_176746_e())).func_185904_a().func_76222_j();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    private void destroy(World world, BlockPos pos) {
        this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
        world.func_175698_g(pos);
    }
}

